/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.ClusterElementChooser;
import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.PagedView;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XRootNode;
import com.tc.admin.common.XTreeModel;
import com.tc.admin.common.XTreeNode;
import com.tc.admin.dso.ClientNode;
import com.tc.admin.dso.ClientsNode;
import com.tc.admin.model.IClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.terracotta.modules.ehcache.presentation.BaseClusterModelPanel;
import org.terracotta.modules.ehcache.presentation.ClientCacheManagerSizingPanel;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.ManageStatisticsMessage;
import org.terracotta.modules.ehcache.presentation.QueryForStatsMessage;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelAdapter;

public class CacheManagerSizingPanel
extends BaseClusterModelPanel
implements ActionListener,
PropertyChangeListener,
TreeModelListener,
HierarchyListener {
    private final CacheManagerModel cacheManagerModel;
    private CacheManagerListener cacheManagerAdapter;
    private static final Font LABEL_FONT = new Font("Dialog", 1, 12);
    private ElementChooser elementChooser;
    private ClientsNode clientsNode;
    private PagedView pagedView;
    private XContainer cacheManagerSizesPanel;
    private final ManageStatisticsAction manageStatsAction;
    private final QueryForStatsMessage queryForStatsMessage;
    public static final String ENTRIES = "Entries";
    public static final String BYTES = "Bytes";

    public CacheManagerSizingPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        super(appContext, cacheManagerModel.getClusterModel());
        this.cacheManagerModel = cacheManagerModel;
        this.cacheManagerAdapter = new CacheManagerListener();
        this.cacheManagerModel.addCacheManagerModelListener(this.cacheManagerAdapter);
        this.manageStatsAction = new ManageStatisticsAction();
        this.addHierarchyListener(this);
        this.queryForStatsMessage = new QueryForStatsMessage(this.manageStatsAction);
    }

    public void clientConnected(IClient client) {
    }

    public void clientDisconnected(IClient client) {
        ClientCacheManagerSizingPanel panel;
        String name = client.toString();
        if (this.pagedView.hasPage(name) && (panel = (ClientCacheManagerSizingPanel)((Object)this.pagedView.getPage(name))) != null) {
            this.pagedView.removePage(name);
            panel.tearDown();
        }
    }

    protected void init() {
        this.elementChooser.setupTreeModel();
        this.pagedView.removeAll();
        this.pagedView.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private JComponent createClientSizingPanel(IClient client) {
        ClientCacheManagerSizingPanel result = new ClientCacheManagerSizingPanel(this.appContext, this.cacheManagerModel, this.cacheManagerModel.getInstance(client));
        result.setup();
        result.setName(client.toString());
        return result;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("CurrentPage".equals(prop)) {
            String newPage = (String)evt.getNewValue();
            this.elementChooser.setSelectedPath(newPage);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Component child;
        ElementChooser chsr = (ElementChooser)((Object)e.getSource());
        XTreeNode node = (XTreeNode)chsr.getSelectedObject();
        String name = node.getName();
        if (!this.pagedView.hasPage(name) && node instanceof ClientNode) {
            IClient client = ((ClientNode)node).getClient();
            this.pagedView.addPage((Component)this.createClientSizingPanel(client));
        }
        if ((child = this.pagedView.getPage(name)) instanceof ClientCacheManagerSizingPanel) {
            this.updateSizingMessage(((ClientCacheManagerSizingPanel)((Object)child)).getCacheManagerInstance());
        } else {
            this.cacheManagerSizesPanel.setVisible(false);
        }
        this.pagedView.setPage(name);
    }

    protected XContainer createMainPanel() {
        XContainer result = new XContainer((LayoutManager)new BorderLayout());
        result.add((Component)this.createSelectorPanel(), (Object)"North");
        this.pagedView = new PagedView();
        result.add((Component)this.pagedView, (Object)"Center");
        return result;
    }

    private void refreshCurrentPage() {
        Component currentPage = this.pagedView.getPage(this.pagedView.getPage());
        if (currentPage instanceof ClientCacheManagerSizingPanel) {
            ((ClientCacheManagerSizingPanel)((Object)currentPage)).refresh();
        }
    }

    private XContainer createSelectorPanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        this.cacheManagerSizesPanel = new XContainer((LayoutManager)new GridBagLayout());
        panel.add((Component)this.cacheManagerSizesPanel, (Object)"Center");
        XContainer clusterElementChooserPanel = new XContainer((LayoutManager)new FlowLayout());
        XLabel label = new XLabel("Select View:");
        clusterElementChooserPanel.add((Component)label);
        label.setFont(LABEL_FONT);
        this.elementChooser = new ElementChooser();
        clusterElementChooserPanel.add((Component)((Object)this.elementChooser));
        panel.add((Component)clusterElementChooserPanel, (Object)"East");
        panel.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        return panel;
    }

    public void updateSizingMessage(CacheManagerInstance cmi) {
        this.cacheManagerSizesPanel.removeAll();
        if (cmi != null) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(1, 5, 1, 5);
            if (cmi.hasSizeBasedPooling()) {
                StringBuilder sb = new StringBuilder("<html>This CacheManager is using size-based pooling for ");
                ArrayList<String> pooledTiers = new ArrayList<String>();
                if (cmi.getMaxBytesLocalHeap() > 0L) {
                    pooledTiers.add("local heap");
                }
                if (cmi.getMaxBytesLocalOffHeap() > 0L) {
                    pooledTiers.add("local offheap");
                }
                if (cmi.getMaxBytesLocalDisk() > 0L) {
                    pooledTiers.add("local disk");
                }
                sb.append(StringUtils.join((Object[])pooledTiers.toArray(new String[0]), (String)", "));
                sb.append(".");
                sb.append("</html>");
                this.cacheManagerSizesPanel.add((Component)new XLabel(sb.toString()), (Object)gbc);
            } else if (cmi.hasSizeBasedCache()) {
                this.cacheManagerSizesPanel.add((Component)new XLabel("This non-pooled CacheManager can contain a mix of size-based and entry count-based caches.", EhcachePresentationUtils.ALERT_ICON), (Object)gbc);
            }
            if (this.cacheManagerSizesPanel.getComponentCount() > 0) {
                ++gbc.gridx;
                gbc.fill = 2;
                gbc.weightx = 1.0;
                this.cacheManagerSizesPanel.add((Component)new XLabel(), (Object)gbc);
                this.cacheManagerSizesPanel.setVisible(true);
            }
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
    }

    public void treeNodesInserted(TreeModelEvent e) {
        Object parent = e.getTreePath().getLastPathComponent();
        if (parent instanceof ClientsNode) {
            Object[] arr$;
            int len$;
            int i$;
            this.elementChooser.expandPath(new TreePath(this.clientsNode.getPath()));
            if (this.elementChooser.getSelectedPath() == null && (i$ = 0) < (len$ = (arr$ = e.getChildren()).length)) {
                Object child = arr$[i$];
                this.elementChooser.setSelectedPath(new TreePath(((ClientNode)child).getPath()));
                return;
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        for (Object child : e.getChildren()) {
            this.pagedView.removePage(((XTreeNode)child).getName());
        }
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }

    private void testDismissQueryForStatsMessage() {
        JDialog queryForStatsDialog;
        if (this.queryForStatsMessage.isShowing() && (queryForStatsDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, (Component)((Object)this.queryForStatsMessage))) != null) {
            queryForStatsDialog.setVisible(false);
        }
    }

    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing() && this.cacheManagerModel.getStatisticsEnabledCount() < this.cacheManagerModel.getCacheModelInstanceCount() && this.queryForStatsMessage.shouldShowAgain()) {
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
            int answer = JOptionPane.showConfirmDialog((Component)((Object)this), this.queryForStatsMessage, frame.getTitle(), 0);
            if (answer == 0) {
                this.cacheManagerModel.setStatisticsEnabled(true, true);
                this.refreshCurrentPage();
            }
            if (!this.queryForStatsMessage.shouldShowAgain()) {
                this.removeHierarchyListener(this);
            }
        }
    }

    public void tearDown() {
        this.cacheManagerModel.removeCacheManagerModelListener(this.cacheManagerAdapter);
        this.elementChooser.resetTreeModel();
        this.pagedView.removePropertyChangeListener((PropertyChangeListener)this);
        this.elementChooser.removeActionListener(this);
        super.tearDown();
    }

    private class ManageStatisticsAction
    extends AbstractAction {
        private ManageStatisticsAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            CacheManagerSizingPanel c = CacheManagerSizingPanel.this;
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)c));
            ManageStatisticsMessage msg = new ManageStatisticsMessage(frame, CacheManagerSizingPanel.this.appContext, CacheManagerSizingPanel.this.cacheManagerModel);
            int result = JOptionPane.showConfirmDialog((Component)((Object)c), msg, msg.getTitle(), 2);
            if (result == 0) {
                Boolean toNewcomers = null;
                if (msg.hasApplyToNewcomersToggle()) {
                    toNewcomers = msg.shouldApplyToNewcomers();
                }
                msg.apply(toNewcomers);
                CacheManagerSizingPanel.this.testDismissQueryForStatsMessage();
            }
            msg.tearDown();
        }
    }

    private class ElementChooser
    extends ClusterElementChooser {
        ElementChooser() {
            super(CacheManagerSizingPanel.this.cacheManagerModel.getClusterModel(), (ActionListener)CacheManagerSizingPanel.this);
        }

        protected TreeModel createTreeModel() {
            return new XTreeModel();
        }

        protected XTreeNode[] createTopLevelNodes() {
            CacheManagerSizingPanel.this.clientsNode = new ClientsNode(CacheManagerSizingPanel.this.appContext, CacheManagerSizingPanel.this.cacheManagerModel.getClusterModel()){

                protected void updateLabel() {
                }

                public XTreeModel getModel() {
                    return (XTreeModel)ElementChooser.this.treeModel;
                }
            };
            CacheManagerSizingPanel.this.clientsNode.setLabel(CacheManagerSizingPanel.this.appContext.getString("runtime.stats.per.client.view"));
            this.treeModel.addTreeModelListener(CacheManagerSizingPanel.this);
            ((XTreeModel)this.treeModel).setRoot((TreeNode)CacheManagerSizingPanel.this.clientsNode);
            return new XTreeNode[0];
        }

        protected boolean acceptPath(TreePath path) {
            return path.getLastPathComponent() instanceof ClientNode;
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            XTreeNode node = (XTreeNode)event.getPath().getLastPathComponent();
            if (node == CacheManagerSizingPanel.this.clientsNode) {
                throw new ExpandVetoException(event);
            }
        }

        public void expandPath(TreePath treePath) {
            this.tree.expandPath(treePath);
            this.treeModelChanged();
        }

        private void resetTreeModel() {
            ((XTreeModel)this.treeModel).setRoot((TreeNode)new XRootNode());
        }
    }

    private class CacheManagerListener
    extends CacheManagerModelAdapter {
        private CacheManagerListener() {
        }

        public void instanceAdded(CacheManagerInstance instance) {
            IClient client = instance.getClient();
            String name = client.toString();
            if (CacheManagerSizingPanel.this.pagedView.hasPage(name)) {
                boolean isCurrentPage = CacheManagerSizingPanel.this.pagedView.getPage().equals(name);
                ClientCacheManagerSizingPanel panel = (ClientCacheManagerSizingPanel)((Object)CacheManagerSizingPanel.this.pagedView.getPage(name));
                if (panel != null) {
                    CacheManagerSizingPanel.this.pagedView.removePage(name);
                    panel.tearDown();
                }
                if (isCurrentPage) {
                    CacheManagerSizingPanel.this.pagedView.addPage((Component)CacheManagerSizingPanel.this.createClientSizingPanel(client));
                    CacheManagerSizingPanel.this.pagedView.setPage(name);
                }
            }
        }

        public void instanceRemoved(CacheManagerInstance instance) {
            ClientCacheManagerSizingPanel panel;
            IClient client = instance.getClient();
            String name = client.toString();
            if (CacheManagerSizingPanel.this.pagedView.hasPage(name) && (panel = (ClientCacheManagerSizingPanel)((Object)CacheManagerSizingPanel.this.pagedView.getPage(name))) != null) {
                CacheManagerSizingPanel.this.pagedView.removePage(name);
                panel.tearDown();
            }
        }
    }
}

