/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.terracotta.modules.ehcache.presentation.BaseClusterModelPanel;
import org.terracotta.modules.ehcache.presentation.CacheManagerSizingPanel;
import org.terracotta.modules.ehcache.presentation.EhcacheOverviewPanel;
import org.terracotta.modules.ehcache.presentation.EhcachePerformancePanel;
import org.terracotta.modules.ehcache.presentation.EhcacheRuntimeStatsPanel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;

public class CacheManagerPanel
extends BaseClusterModelPanel
implements PropertyChangeListener {
    private final CacheManagerModel cacheManagerModel;
    private EhcacheOverviewPanel cacheOverviewPanel;
    private EhcachePerformancePanel cachePerformancePanel;
    private EhcacheRuntimeStatsPanel cacheStatsPanel;
    private CacheManagerSizingPanel sizingPanel;

    public CacheManagerPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        super(appContext, cacheManagerModel.getClusterModel());
        this.cacheManagerModel = cacheManagerModel;
    }

    CacheManagerModel getCacheManagerModel() {
        return this.cacheManagerModel;
    }

    public void setup() {
        super.setup();
        this.revalidate();
        this.repaint();
    }

    protected void init() {
        this.cacheOverviewPanel.setup();
        this.cachePerformancePanel.setup();
        this.cacheStatsPanel.setup();
        this.sizingPanel.setup();
    }

    protected XContainer createMainPanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        XTabbedPane tabbedPane = new XTabbedPane();
        this.cacheOverviewPanel = new EhcacheOverviewPanel(this.appContext, this.cacheManagerModel);
        tabbedPane.add(bundle.getString("overview"), (Component)((Object)this.cacheOverviewPanel));
        this.cachePerformancePanel = new EhcachePerformancePanel(this.appContext, this.cacheManagerModel);
        tabbedPane.add(bundle.getString("performance"), (Component)((Object)this.cachePerformancePanel));
        this.cacheStatsPanel = new EhcacheRuntimeStatsPanel(this.appContext, this.cacheManagerModel);
        tabbedPane.add(bundle.getString("statistics"), (Component)((Object)this.cacheStatsPanel));
        this.sizingPanel = new CacheManagerSizingPanel(this.appContext, this.cacheManagerModel);
        tabbedPane.add(bundle.getString("sizing"), (Component)((Object)this.sizingPanel));
        panel.add((Component)tabbedPane, (Object)"Center");
        this.cacheStatsPanel.addPropertyChangeListener(this);
        return panel;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("SelectedCacheModel".equals(prop)) {
            CacheModel cacheModel = (CacheModel)evt.getNewValue();
            this.cacheStatsPanel.setSelectedCacheModel(cacheModel);
        }
    }
}

