/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.BasicWorker;
import com.tc.admin.common.ExceptionHelper;
import com.tc.admin.common.XCheckBox;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XSpinner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.DefaultFormatter;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.EhcacheResourceBundle;
import org.terracotta.modules.ehcache.presentation.EhcacheToolBar;
import org.terracotta.modules.ehcache.presentation.model.SettingsCacheModel;

public class CacheDetailPanel
extends XContainer
implements PropertyChangeListener {
    private final ApplicationContext appContext;
    private SettingsCacheModel cacheModel;
    private TitledBorder titledBorder;
    private XSpinner tti;
    private XSpinner ttl;
    private XSpinner maxEntriesLocalDisk;
    private XSpinner maxEntriesLocalHeap;
    private BulkLoadControlAction enableBulkLoadAction;
    private BulkLoadControlAction disableBulkLoadAction;
    private XCheckBox loggingToggle;
    private static final ResourceBundle bundle = ResourceBundle.getBundle(EhcacheResourceBundle.class.getName());

    public CacheDetailPanel(ApplicationContext appContext) {
        super((LayoutManager)new BorderLayout());
        this.appContext = appContext;
        this.add(this.createOperationsPanel(), "North");
        this.add((Component)this.createSettingsPanel(), "Center");
        this.titledBorder = BorderFactory.createTitledBorder("");
        this.setBorder(this.titledBorder);
    }

    private EhcacheToolBar createOperationsPanel() {
        EhcacheToolBar toolBar = new EhcacheToolBar();
        this.enableBulkLoadAction = new BulkLoadControlAction(true);
        toolBar.add(this.enableBulkLoadAction);
        this.disableBulkLoadAction = new BulkLoadControlAction(false);
        toolBar.add(this.disableBulkLoadAction);
        return toolBar;
    }

    private XContainer createSettingsPanel() {
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        Insets labelInsets = new Insets(0, 2, 0, 2);
        Insets fieldInsets = new Insets(0, 2, 3, 2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = labelInsets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        XLabel label = new XLabel(bundle.getString("tti"));
        panel.add((Component)label, (Object)gbc);
        ++gbc.gridy;
        gbc.insets = fieldInsets;
        this.tti = CacheDetailPanel.createIntegerField();
        panel.add((Component)this.tti, (Object)gbc);
        this.tti.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CacheDetailPanel.this.setTTI();
            }
        });
        new IntegerFieldDocumentListener(this.tti);
        --gbc.gridy;
        ++gbc.gridx;
        gbc.insets = labelInsets;
        label = new XLabel(bundle.getString("target.max.total.count"));
        panel.add((Component)label, (Object)gbc);
        ++gbc.gridy;
        gbc.insets = fieldInsets;
        this.maxEntriesLocalDisk = CacheDetailPanel.createIntegerField();
        panel.add((Component)this.maxEntriesLocalDisk, (Object)gbc);
        this.maxEntriesLocalDisk.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CacheDetailPanel.this.setMaxEntriesLocalDisk();
            }
        });
        new IntegerFieldDocumentListener(this.maxEntriesLocalDisk);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = labelInsets;
        label = new XLabel(bundle.getString("ttl"));
        panel.add((Component)label, (Object)gbc);
        ++gbc.gridy;
        gbc.insets = fieldInsets;
        this.ttl = CacheDetailPanel.createIntegerField();
        panel.add((Component)this.ttl, (Object)gbc);
        this.ttl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CacheDetailPanel.this.setTTL();
            }
        });
        new IntegerFieldDocumentListener(this.ttl);
        --gbc.gridy;
        ++gbc.gridx;
        gbc.insets = labelInsets;
        label = new XLabel(bundle.getString("target.max.in-memory.count"));
        panel.add((Component)label, (Object)gbc);
        ++gbc.gridy;
        gbc.insets = fieldInsets;
        this.maxEntriesLocalHeap = CacheDetailPanel.createIntegerField();
        panel.add((Component)this.maxEntriesLocalHeap, (Object)gbc);
        this.maxEntriesLocalHeap.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CacheDetailPanel.this.setMaxEntriesLocalHeap();
            }
        });
        new IntegerFieldDocumentListener(this.maxEntriesLocalHeap);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets = labelInsets;
        this.loggingToggle = new XCheckBox(bundle.getString("logging.enabled"));
        panel.add((Component)this.loggingToggle, (Object)gbc);
        this.loggingToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CacheDetailPanel.this.cacheModel.setLoggingEnabled(CacheDetailPanel.this.loggingToggle.isSelected());
            }
        });
        XContainer result = new XContainer((LayoutManager)new BorderLayout());
        result.add((Component)panel, (Object)"West");
        result.setBorder((Border)BorderFactory.createTitledBorder(bundle.getString("cache.settings")));
        return result;
    }

    private void queryEnableBulkLoad() {
        XLabel msg = new XLabel(MessageFormat.format(bundle.getString("enable.cache.bulkload.confirm"), this.cacheModel.getCacheName()));
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        int answer = JOptionPane.showConfirmDialog(this.getParent(), msg, frame.getTitle(), 2);
        if (answer == 0) {
            this.appContext.submit((Runnable)((Object)new BulkLoadControlWorker(true)));
        }
    }

    private void queryDisableBulkLoad() {
        XLabel msg = new XLabel(MessageFormat.format(bundle.getString("disable.cache.bulkload.confirm"), this.cacheModel.getCacheName()));
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        int answer = JOptionPane.showConfirmDialog(this.getParent(), msg, frame.getTitle(), 2);
        if (answer == 0) {
            this.appContext.submit((Runnable)((Object)new BulkLoadControlWorker(false)));
        }
    }

    public SettingsCacheModel setCacheModel(SettingsCacheModel cacheModel) {
        SettingsCacheModel oldCacheModel = this.cacheModel;
        if (oldCacheModel != cacheModel && (this.cacheModel = cacheModel) != null) {
            cacheModel.addPropertyChangeListener(this);
            this.refreshUI();
            this.revalidate();
            this.repaint();
        }
        return oldCacheModel;
    }

    private void refreshUI() {
        this.titledBorder.setTitle(this.cacheModel.getCacheName());
        this.tti.getModel().setValue(this.cacheModel.getTimeToIdleSeconds());
        this.ttl.getModel().setValue(this.cacheModel.getTimeToLiveSeconds());
        this.maxEntriesLocalDisk.getModel().setValue(this.cacheModel.getMaxEntriesLocalDisk());
        this.maxEntriesLocalHeap.getModel().setValue(this.cacheModel.getMaxEntriesLocalHeap());
        this.loggingToggle.setSelected(this.cacheModel.isLoggingEnabled());
    }

    public void updateCache() {
        this.setCacheModel(this.cacheModel);
    }

    private void setTTI() {
        if (this.cacheModel != null) {
            this.cacheModel.setTimeToIdleSeconds(((Number)this.tti.getValue()).intValue());
        }
    }

    private void setTTL() {
        if (this.cacheModel != null) {
            this.cacheModel.setTimeToLiveSeconds(((Number)this.ttl.getValue()).intValue());
        }
    }

    private void setMaxEntriesLocalDisk() {
        if (this.cacheModel != null) {
            this.cacheModel.setMaxEntriesLocalDisk(((Number)this.maxEntriesLocalDisk.getValue()).intValue());
        }
    }

    private void setMaxEntriesLocalHeap() {
        if (this.cacheModel != null) {
            this.cacheModel.setMaxEntriesLocalHeap(((Number)this.maxEntriesLocalHeap.getValue()).intValue());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshUI();
    }

    private static XSpinner createIntegerField() {
        XSpinner spinner = new XSpinner();
        JFormattedTextField editor = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
        editor.setColumns(10);
        spinner.setUI((SpinnerUI)new BasicSpinnerUI(){

            protected Component createNextButton() {
                JButton c = new JButton();
                ((Component)c).setPreferredSize(new Dimension(0, 0));
                c.setFocusable(false);
                return c;
            }

            protected Component createPreviousButton() {
                JButton c = new JButton();
                ((Component)c).setPreferredSize(new Dimension(0, 0));
                c.setFocusable(false);
                return c;
            }
        });
        spinner.setBorder(null);
        ((DefaultFormatter)((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().getFormatter()).setAllowsInvalid(false);
        ((JComponent)editor.getParent()).setBorder(UIManager.getBorder("TextField.border"));
        return spinner;
    }

    private static class IntegerFieldDocumentListener
    implements DocumentListener,
    ChangeListener {
        private final XSpinner field;
        private final Timer timer;

        private IntegerFieldDocumentListener(XSpinner field) {
            this.field = field;
            JFormattedTextField editor = ((JSpinner.DefaultEditor)field.getEditor()).getTextField();
            editor.getDocument().addDocumentListener(this);
            this.timer = new Timer(750, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        IntegerFieldDocumentListener.this.getField().commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            });
            this.timer.setRepeats(false);
            SpinnerNumberModel numberModel = (SpinnerNumberModel)field.getModel();
            numberModel.setMinimum(Integer.valueOf(-1));
            numberModel.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
            numberModel.setStepSize(1000);
            field.addChangeListener((ChangeListener)this);
        }

        private XSpinner getField() {
            return this.field;
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.timer.restart();
        }

        public void removeUpdate(DocumentEvent e) {
            this.timer.restart();
        }

        public void stateChanged(ChangeEvent e) {
            this.timer.stop();
        }
    }

    private class BulkLoadControlAction
    extends AbstractAction {
        private final boolean enable;

        BulkLoadControlAction(boolean enable) {
            this.enable = enable;
            this.putValue("Name", bundle.getString(enable ? "enable.bulkload" : "disable.bulkload"));
            this.putValue("ShortDescription", bundle.getString(enable ? "enable.bulkload.tip" : "disable.bulkload.tip"));
            this.putValue("SmallIcon", enable ? EhcachePresentationUtils.BULK_LOAD_DISABLED_ICON : EhcachePresentationUtils.BULK_LOAD_ENABLED_ICON);
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.enable) {
                CacheDetailPanel.this.queryEnableBulkLoad();
            } else {
                CacheDetailPanel.this.queryDisableBulkLoad();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BulkLoadControlWorker
    extends BasicWorker<Void> {
        AbstractAction action;

        private BulkLoadControlWorker(final boolean enable) {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CacheDetailPanel.this.cacheModel.setBulkLoadEnabled(enable);
                    return null;
                }
            });
            this.action = enable ? CacheDetailPanel.this.enableBulkLoadAction : CacheDetailPanel.this.disableBulkLoadAction;
            this.action.setEnabled(false);
        }

        protected void finished() {
            Throwable rootCause;
            Exception e = this.getException();
            if (e != null && !((rootCause = ExceptionHelper.getRootCause((Throwable)e)) instanceof IOException)) {
                CacheDetailPanel.this.appContext.log((Throwable)e);
            }
            this.action.setEnabled(true);
        }
    }
}

