/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.AbstractClusterListener;
import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.StatusView;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XTabbedPane;
import com.tc.admin.dso.BaseRuntimeStatsPanel;
import com.tc.admin.model.ClientConnectionListener;
import com.tc.admin.model.IClient;
import com.tc.admin.model.IClusterModel;
import com.tc.admin.model.IClusterNode;
import com.tc.admin.model.IServer;
import com.tc.admin.model.PolledAttributesResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimeSeries;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.EhcacheResourceBundle;
import org.terracotta.modules.ehcache.presentation.EhcacheStatsUtils;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;

public class BaseEhcacheStatsChartPanel
extends BaseRuntimeStatsPanel
implements ClientConnectionListener,
PreferenceChangeListener {
    protected final IClusterModel clusterModel;
    protected final CacheManagerModel cacheManagerModel;
    protected final ClusterListener clusterListener;
    protected ObjectName statsBeanObjectName;
    private XTabbedPane tabbedPane;
    protected BaseRuntimeStatsPanel usagePanel;
    protected BaseRuntimeStatsPanel searchPanel;
    private int searchTabIndex;
    protected BaseRuntimeStatsPanel jtaPanel;
    private int jtaTabIndex;
    protected BaseRuntimeStatsPanel writeBehindPanel;
    private int writeBehindTabIndex;
    public static final int CHART_COUNT = 4;
    public ChartPanel[] chartPanels = new ChartPanel[4];
    public ChartContentProvider[] chartProviders = new ChartContentProvider[4];
    private final Map<String, ChartContentProvider> contentProviderMap;
    protected final Preferences activeProvidersPrefs;
    protected static final String ACTIVE_PROVIDERS_PREFS_KEY = "ActiveChartProviders";
    protected static final String DEFAULT_ACTIVE_PROVIDERS = "CacheHitRatio,CacheHitMissRate,CacheUpdateRate,CachePutRate";
    protected TimeSeries cacheSearchRateSeries;
    protected TimeSeries cacheAverageSearchTimeSeries;
    protected TimeSeries transactionCommitRateSeries;
    protected TimeSeries transactionRollbackRateSeries;
    protected TimeSeries writerQueueLengthSeries;
    protected TimeSeries writerMaxQueueSizeSeries;
    protected XLabel cacheSearchRateLabel;
    protected XLabel cacheAverageSearchTimeLabel;
    protected XLabel transactionCommitRateLabel;
    protected XLabel transactionRollbackRateLabel;
    protected StatusView writerQueueLengthLabel;
    protected StatusView writerMaxQueueSizeLabel;
    protected final String cacheSearchRateLabelFormat = "{0,number,integer} Searches/sec.";
    protected final String cacheAverageSearchTimeLabelFormat = "{0,number,integer} millis./Search";
    protected final String transactionCommitRateLabelFormat = "{0,number,integer} Commits/sec.";
    protected final String transactionRollbackRateLabelFormat = "{0,number,integer} Rollbacks/sec.";
    protected final String writerQueueLengthLabelFormat = "{0,number,integer} Pending Writes";
    protected final String writerMaxQueueSizeLabelFormat = "Max Pending Writes: {0,number,integer}";
    private static final boolean showCacheHitRatioLabel = true;
    protected static final String CACHE_HIT_SAMPLE_ATTR = "CacheHitRate";
    protected static final String CACHE_IN_MEMORY_HIT_SAMPLE_ATTR = "CacheInMemoryHitRate";
    protected static final String CACHE_OFF_HEAP_HIT_SAMPLE_ATTR = "CacheOffHeapHitRate";
    protected static final String CACHE_ON_DISK_HIT_SAMPLE_ATTR = "CacheOnDiskHitRate";
    protected static final String CACHE_MISS_SAMPLE_ATTR = "CacheMissRate";
    protected static final String CACHE_IN_MEMORY_MISS_SAMPLE_ATTR = "CacheInMemoryMissRate";
    protected static final String CACHE_OFF_HEAP_MISS_SAMPLE_ATTR = "CacheOffHeapMissRate";
    protected static final String CACHE_ON_DISK_MISS_SAMPLE_ATTR = "CacheOnDiskMissRate";
    protected static final String CACHE_PUT_SAMPLE_ATTR = "CachePutRate";
    protected static final String CACHE_UPDATE_SAMPLE_ATTR = "CacheUpdateRate";
    protected static final String CACHE_REMOVE_SAMPLE_ATTR = "CacheRemoveRate";
    protected static final String CACHE_EVICTION_SAMPLE_ATTR = "CacheEvictionRate";
    protected static final String CACHE_EXPIRATION_SAMPLE_ATTR = "CacheExpirationRate";
    protected static final String CACHE_AVERAGE_GET_TIME_ATTR = "CacheAverageGetTime";
    protected static final String CACHE_SEARCH_RATE_ATTR = "CacheSearchRate";
    protected static final String CACHE_AVERAGE_SEARCH_TIME_ATTR = "CacheAverageSearchTime";
    protected static final String TRANSACTION_COMMIT_RATE_ATTR = "TransactionCommitRate";
    protected static final String TRANSACTION_ROLLBACK_RATE_ATTR = "TransactionRollbackRate";
    protected static final String WRITER_QUEUE_LENGTH_ATTR = "WriterQueueLength";
    protected static final String WRITER_MAX_QUEUE_SIZE_ATTR = "WriterMaxQueueSize";
    protected static final String HAS_WRITE_BEHIND_WRITER_ATTR = "HasWriteBehindWriter";
    protected static final String TRANSACTIONAL_ATTR = "Transactional";
    protected static final String SEARCHABLE_ATTR = "Searchable";
    protected static final String[] POLLED_ATTRS = new String[]{"CacheHitRate", "CacheInMemoryHitRate", "CacheOffHeapHitRate", "CacheOnDiskHitRate", "CacheMissRate", "CacheInMemoryMissRate", "CacheOffHeapMissRate", "CacheOnDiskMissRate", "CachePutRate", "CacheUpdateRate", "CacheRemoveRate", "CacheEvictionRate", "CacheExpirationRate", "CacheAverageGetTime", "CacheSearchRate", "CacheAverageSearchTime", "TransactionCommitRate", "TransactionRollbackRate", "WriterQueueLength", "WriterMaxQueueSize", "HasWriteBehindWriter", "Transactional", "Searchable"};
    protected static final Set<String> POLLED_ATTRS_SET = new HashSet<String>(Arrays.asList(POLLED_ATTRS));
    protected static final ResourceBundle bundle = ResourceBundle.getBundle(EhcacheResourceBundle.class.getName());

    protected BaseEhcacheStatsChartPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        super(appContext);
        this.clusterModel = cacheManagerModel.getClusterModel();
        this.cacheManagerModel = cacheManagerModel;
        this.clusterListener = new ClusterListener(this.clusterModel);
        this.contentProviderMap = new LinkedHashMap<String, ChartContentProvider>();
        this.contentProviderMap.put("CacheHitRatio", new HitRatioProvider());
        this.contentProviderMap.put("CacheHitMissRate", new HitMissRateProvider());
        this.contentProviderMap.put(CACHE_UPDATE_SAMPLE_ATTR, new UpdateRateProvider());
        this.contentProviderMap.put(CACHE_PUT_SAMPLE_ATTR, new PutRateProvider());
        this.contentProviderMap.put(CACHE_REMOVE_SAMPLE_ATTR, new RemoveRateProvider());
        this.contentProviderMap.put(CACHE_EVICTION_SAMPLE_ATTR, new EvictionRateProvider());
        this.contentProviderMap.put(CACHE_EXPIRATION_SAMPLE_ATTR, new ExpirationRateProvider());
        this.contentProviderMap.put(CACHE_IN_MEMORY_HIT_SAMPLE_ATTR, new InMemoryHitRateProvider());
        this.contentProviderMap.put(CACHE_OFF_HEAP_HIT_SAMPLE_ATTR, new OffHeapHitRateProvider());
        this.contentProviderMap.put(CACHE_ON_DISK_HIT_SAMPLE_ATTR, new OnDiskHitRateProvider());
        this.contentProviderMap.put(CACHE_IN_MEMORY_MISS_SAMPLE_ATTR, new InMemoryMissRateProvider());
        this.contentProviderMap.put(CACHE_OFF_HEAP_MISS_SAMPLE_ATTR, new OffHeapMissRateProvider());
        this.contentProviderMap.put(CACHE_ON_DISK_MISS_SAMPLE_ATTR, new OnDiskMissRateProvider());
        this.contentProviderMap.put(CACHE_AVERAGE_GET_TIME_ATTR, new AverageGetTimeProvider());
        this.activeProvidersPrefs = appContext.getPrefs().node(BaseEhcacheStatsChartPanel.class.getName());
        this.setup(this.chartsPanel);
        this.activeProvidersPrefs.addPreferenceChangeListener(this);
    }

    protected ObjectName getBeanName() throws MalformedObjectNameException {
        return EhcacheStatsUtils.getSampledCacheManagerBeanName(this.cacheManagerModel.getName());
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        String key = evt.getKey();
        String newValue = evt.getNewValue();
        if (ACTIVE_PROVIDERS_PREFS_KEY.equals(key)) {
            String[] providerNames = StringUtils.split((String)newValue, (String)",");
            for (int i = 0; i < 4; ++i) {
                String providerName = providerNames[i];
                ChartContentProvider contentProvider = this.chartProviders[i];
                if (contentProvider.getName().equals(providerName)) continue;
                ChartPanel chartPanel = this.chartPanels[i];
                chartPanel.removeAll();
                ChartContentProvider chartProvider = this.contentProviderMap.get(providerName);
                chartProvider.configure(chartPanel);
                this.chartProviders[i] = chartProvider;
            }
        }
    }

    public void setup() {
        try {
            this.statsBeanObjectName = this.getBeanName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.clusterModel.addPropertyChangeListener((PropertyChangeListener)((Object)this.clusterListener));
        if (this.clusterModel.isReady()) {
            this.init();
        }
    }

    public CacheManagerModel getCacheManagerModel() {
        return this.cacheManagerModel;
    }

    public IClusterModel getClusterModel() {
        return this.clusterModel;
    }

    protected void init() {
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            activeCoord.addClientConnectionListener((ClientConnectionListener)this);
        }
        this.addPolledAttributeListener();
        this.setAutoStart(false);
        this.startMonitoringRuntimeStats();
    }

    public void suspend() {
        this.removePolledAttributeListener();
    }

    protected void addPolledAttributeListener() {
    }

    protected void removePolledAttributeListener() {
    }

    public void clientConnected(IClient client) {
    }

    public void clientDisconnected(IClient client) {
    }

    private XContainer createUsagePanel() {
        XContainer result = new XContainer((LayoutManager)new BorderLayout());
        XLabel label = new XLabel("Use chart context-menu to change graphed metric", EhcachePresentationUtils.LIGHT_BULB_ICON);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        result.add((Component)label, (Object)"North");
        label.setHorizontalAlignment(4);
        this.usagePanel = new BaseRuntimeStatsPanel(this.appContext);
        result.add((Component)this.usagePanel);
        return result;
    }

    protected synchronized void setup(XContainer chartsPanel) {
        chartsPanel.setLayout((LayoutManager)new BorderLayout());
        this.tabbedPane = new XTabbedPane();
        chartsPanel.add((Component)this.tabbedPane);
        this.tabbedPane.addTab("Usage", (Component)this.createUsagePanel());
        this.tabbedPane.setToolTipTextAt(0, "Use chart context-menus to change graphed metric.");
        this.searchTabIndex = this.tabbedPane.getTabCount();
        this.searchPanel = new BaseRuntimeStatsPanel(this.appContext);
        this.tabbedPane.addTab("Search", (Component)this.searchPanel);
        this.jtaTabIndex = this.tabbedPane.getTabCount();
        this.jtaPanel = new BaseRuntimeStatsPanel(this.appContext);
        this.tabbedPane.addTab("JTA", (Component)this.jtaPanel);
        this.writeBehindTabIndex = this.tabbedPane.getTabCount();
        this.writeBehindPanel = new BaseRuntimeStatsPanel(this.appContext);
        this.tabbedPane.addTab("Write-Behind", (Component)this.writeBehindPanel);
        this.usagePanel.getChartsPanel().setLayout((LayoutManager)new GridLayout(2, 2));
        int i = 0;
        String activeProvidersPrefValue = this.activeProvidersPrefs.get(ACTIVE_PROVIDERS_PREFS_KEY, DEFAULT_ACTIVE_PROVIDERS);
        String[] activeProviders = StringUtils.split((String)activeProvidersPrefValue, (String)",");
        String[] defaultProviders = StringUtils.split((String)DEFAULT_ACTIVE_PROVIDERS, (String)",");
        for (String providerName : activeProviders) {
            this.chartProviders[i] = this.contentProviderMap.get(providerName);
            if (this.chartProviders[i] == null) {
                this.chartProviders[i] = this.contentProviderMap.get(defaultProviders[i]);
            }
            this.chartPanels[i] = this.setupChartContentProvider(this.usagePanel.getChartsPanel(), this.chartProviders[i]);
            ++i;
        }
        this.searchPanel.getChartsPanel().setLayout((LayoutManager)new GridLayout(2, 1));
        this.setupCacheSearchRatePanel(this.searchPanel.getChartsPanel());
        this.setupCacheAverageSearchTimePanel(this.searchPanel.getChartsPanel());
        this.jtaPanel.getChartsPanel().setLayout((LayoutManager)new GridLayout(2, 1));
        this.setupTransactionCommitRatePanel(this.jtaPanel.getChartsPanel());
        this.setupTransactionRollbackRatePanel(this.jtaPanel.getChartsPanel());
        this.writeBehindPanel.getChartsPanel().setLayout((LayoutManager)new GridLayout(1, 1));
        this.setupWriteBehindPanel(this.writeBehindPanel.getChartsPanel());
    }

    public ChartPanel[] getChartPanels() {
        return this.chartPanels;
    }

    public ChartContentProvider[] getChartContentProviders() {
        return this.chartProviders;
    }

    private String[] chartProviderNames() {
        String[] result = new String[4];
        int i = 0;
        for (ChartContentProvider provider : this.chartProviders) {
            result[i++] = provider.getName();
        }
        return result;
    }

    private int indexOfChartPanel(ChartPanel chartPanel) {
        return Arrays.asList(this.chartPanels).indexOf(chartPanel);
    }

    protected ChartPanel setupChartContentProvider(XContainer parent, ChartContentProvider provider) {
        ChartPanel chartPanel = BaseEhcacheStatsChartPanel.createChartPanel(null);
        provider.configure(chartPanel);
        JPopupMenu popup = chartPanel.getPopupMenu();
        JMenu changeChartMenu = new JMenu("Change chart to...");
        popup.add(changeChartMenu);
        for (String providerName : this.contentProviderMap.keySet()) {
            JMenuItem subitem = new JMenuItem(providerName);
            changeChartMenu.add(subitem);
            subitem.addActionListener(new ChartPanelProviderHandler(chartPanel, providerName));
        }
        changeChartMenu.addSeparator();
        JMenuItem restoreDefaultsMenu = new JMenuItem("Restore default charts");
        restoreDefaultsMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseEhcacheStatsChartPanel.this.activeProvidersPrefs.put(BaseEhcacheStatsChartPanel.ACTIVE_PROVIDERS_PREFS_KEY, BaseEhcacheStatsChartPanel.DEFAULT_ACTIVE_PROVIDERS);
            }
        });
        changeChartMenu.add(restoreDefaultsMenu);
        parent.add((Component)chartPanel);
        chartPanel.setPreferredSize(fDefaultGraphSize);
        return chartPanel;
    }

    protected void setupCacheSearchRatePanel(XContainer parent) {
        String text = bundle.getString("cache.search.rate");
        this.cacheSearchRateSeries = this.createTimeSeries(text);
        ChartPanel chartPanel = BaseEhcacheStatsChartPanel.createChartPanel((JFreeChart)this.createChart(this.cacheSearchRateSeries, false));
        parent.add((Component)chartPanel);
        chartPanel.setPreferredSize(fDefaultGraphSize);
        chartPanel.setBorder((Border)new TitledBorder(text));
        chartPanel.setToolTipText(text);
        chartPanel.setLayout((LayoutManager)new BorderLayout());
        this.cacheSearchRateLabel = BaseEhcacheStatsChartPanel.createOverlayLabel();
        chartPanel.add((Component)this.cacheSearchRateLabel);
    }

    protected void setupCacheAverageSearchTimePanel(XContainer parent) {
        String text = bundle.getString("cache.average.search.time");
        this.cacheAverageSearchTimeSeries = this.createTimeSeries(text);
        ChartPanel chartPanel = BaseEhcacheStatsChartPanel.createChartPanel((JFreeChart)this.createChart(this.cacheAverageSearchTimeSeries, false));
        parent.add((Component)chartPanel);
        chartPanel.setPreferredSize(fDefaultGraphSize);
        chartPanel.setBorder((Border)new TitledBorder(text));
        chartPanel.setToolTipText(text);
        chartPanel.setLayout((LayoutManager)new BorderLayout());
        this.cacheAverageSearchTimeLabel = BaseEhcacheStatsChartPanel.createOverlayLabel();
        chartPanel.add((Component)this.cacheAverageSearchTimeLabel);
    }

    protected void setupTransactionCommitRatePanel(XContainer parent) {
        String text = bundle.getString("transaction.commit.rate");
        this.transactionCommitRateSeries = this.createTimeSeries(text);
        ChartPanel chartPanel = BaseEhcacheStatsChartPanel.createChartPanel((JFreeChart)this.createChart(this.transactionCommitRateSeries, false));
        parent.add((Component)chartPanel);
        chartPanel.setPreferredSize(fDefaultGraphSize);
        chartPanel.setBorder((Border)new TitledBorder(text));
        chartPanel.setToolTipText(text);
        chartPanel.setLayout((LayoutManager)new BorderLayout());
        this.transactionCommitRateLabel = BaseEhcacheStatsChartPanel.createOverlayLabel();
        chartPanel.add((Component)this.transactionCommitRateLabel);
    }

    protected void setupTransactionRollbackRatePanel(XContainer parent) {
        String text = bundle.getString("transaction.rollback.rate");
        this.transactionRollbackRateSeries = this.createTimeSeries(text);
        ChartPanel chartPanel = BaseEhcacheStatsChartPanel.createChartPanel((JFreeChart)this.createChart(this.transactionRollbackRateSeries, false));
        parent.add((Component)chartPanel);
        chartPanel.setPreferredSize(fDefaultGraphSize);
        chartPanel.setBorder((Border)new TitledBorder(text));
        chartPanel.setToolTipText(text);
        chartPanel.setLayout((LayoutManager)new BorderLayout());
        this.transactionRollbackRateLabel = BaseEhcacheStatsChartPanel.createOverlayLabel();
        chartPanel.add((Component)this.transactionRollbackRateLabel);
    }

    protected void setupWriteBehindPanel(XContainer parent) {
        String text = bundle.getString("writer.queue.length");
        this.writerQueueLengthSeries = this.createTimeSeries(text);
        this.writerMaxQueueSizeSeries = this.createTimeSeries(bundle.getString("writer.max.queue.size"));
        JFreeChart chart = this.createChart(new TimeSeries[]{this.writerMaxQueueSizeSeries, this.writerQueueLengthSeries}, false);
        ChartPanel chartPanel = BaseEhcacheStatsChartPanel.createChartPanel((JFreeChart)chart);
        parent.add((Component)chartPanel);
        chartPanel.setPreferredSize(fDefaultGraphSize);
        chartPanel.setBorder((Border)new TitledBorder(text));
        chartPanel.setToolTipText(text);
        chartPanel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        XContainer labelHolder = new XContainer((LayoutManager)new GridLayout(0, 1));
        this.writerMaxQueueSizeLabel = BaseEhcacheStatsChartPanel.createStatusLabel((Color)EhcachePresentationUtils.MISS_DRAW_COLOR);
        labelHolder.add((Component)this.writerMaxQueueSizeLabel);
        this.writerQueueLengthLabel = BaseEhcacheStatsChartPanel.createStatusLabel((Color)EhcachePresentationUtils.PUT_DRAW_COLOR);
        labelHolder.add((Component)this.writerQueueLengthLabel);
        labelHolder.setOpaque(false);
        chartPanel.add((Component)labelHolder, (Object)gbc);
        ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.MISS_FILL_COLOR);
        ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(1, (Paint)EhcachePresentationUtils.PUT_FILL_COLOR);
    }

    protected void updateAllSeries(long searchRate, long averageSearchTime, long txCommitRate, long txRollbackRate, long writerQueueLength, int writerMaxQueueSize, boolean hasAnyWriters, boolean isTransactional, boolean isSearchable) {
        boolean isWriteBehindTabEnabled;
        boolean isJTATabEnabled;
        if (!this.isMonitoringRuntimeStats()) {
            return;
        }
        this.tmpDate.setTime(System.currentTimeMillis());
        for (ChartContentProvider chartProvider : this.chartProviders) {
            chartProvider.render();
        }
        if (this.cacheSearchRateSeries != null) {
            this.updateSeries(this.cacheSearchRateSeries, searchRate);
            this.cacheSearchRateLabel.setText(MessageFormat.format("{0,number,integer} Searches/sec.", searchRate));
        }
        if (this.cacheAverageSearchTimeSeries != null) {
            this.updateSeries(this.cacheAverageSearchTimeSeries, averageSearchTime);
            this.cacheAverageSearchTimeLabel.setText(MessageFormat.format("{0,number,integer} millis./Search", averageSearchTime));
        }
        if (this.transactionCommitRateSeries != null) {
            this.updateSeries(this.transactionCommitRateSeries, txCommitRate);
            this.transactionCommitRateLabel.setText(MessageFormat.format("{0,number,integer} Commits/sec.", txCommitRate));
        }
        if (this.transactionRollbackRateSeries != null) {
            this.updateSeries(this.transactionRollbackRateSeries, txRollbackRate);
            this.transactionRollbackRateLabel.setText(MessageFormat.format("{0,number,integer} Rollbacks/sec.", txRollbackRate));
        }
        if (this.writerQueueLengthSeries != null) {
            this.updateSeries(this.writerQueueLengthSeries, writerQueueLength);
            this.writerQueueLengthLabel.setText(MessageFormat.format("{0,number,integer} Pending Writes", writerQueueLength));
        }
        if (this.writerMaxQueueSizeSeries != null) {
            this.updateSeries(this.writerMaxQueueSizeSeries, writerMaxQueueSize);
            this.writerMaxQueueSizeLabel.setText(MessageFormat.format("Max Pending Writes: {0,number,integer}", writerMaxQueueSize));
        }
        int selectedTab = this.tabbedPane.getSelectedIndex();
        boolean isSearchTabEnabled = this.tabbedPane.isEnabledAt(this.searchTabIndex);
        if (isSearchTabEnabled != isSearchable) {
            this.tabbedPane.setEnabledAt(this.searchTabIndex, isSearchable);
            if (selectedTab == this.searchTabIndex && !isSearchable) {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
        if ((isJTATabEnabled = this.tabbedPane.isEnabledAt(this.jtaTabIndex)) != isTransactional) {
            this.tabbedPane.setEnabledAt(this.jtaTabIndex, isTransactional);
            if (selectedTab == this.jtaTabIndex && !isTransactional) {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
        if ((isWriteBehindTabEnabled = this.tabbedPane.isEnabledAt(this.writeBehindTabIndex)) != hasAnyWriters) {
            this.tabbedPane.setEnabledAt(this.writeBehindTabIndex, hasAnyWriters);
            if (selectedTab == this.writeBehindTabIndex && !hasAnyWriters) {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
    }

    private void clearAllTimeSeries() {
        for (Map.Entry<String, ChartContentProvider> entry : this.contentProviderMap.entrySet()) {
            entry.getValue().clear();
        }
        if (this.cacheSearchRateSeries != null) {
            this.cacheSearchRateSeries.clear();
        }
        if (this.cacheAverageSearchTimeSeries != null) {
            this.cacheAverageSearchTimeSeries.clear();
        }
        if (this.transactionCommitRateSeries != null) {
            this.transactionCommitRateSeries.clear();
        }
        if (this.transactionRollbackRateSeries != null) {
            this.transactionRollbackRateSeries.clear();
        }
        if (this.writerQueueLengthSeries != null) {
            this.writerQueueLengthSeries.clear();
        }
        if (this.writerMaxQueueSizeSeries != null) {
            this.writerMaxQueueSizeSeries.clear();
        }
    }

    public void tearDown() {
        this.removePolledAttributeListener();
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            activeCoord.removeClientConnectionListener((ClientConnectionListener)this);
        }
        this.clusterModel.removePropertyChangeListener((PropertyChangeListener)((Object)this.clusterListener));
        this.clusterListener.tearDown();
        this.clearAllTimeSeries();
        super.tearDown();
    }

    private class ChartPanelProviderHandler
    implements ActionListener {
        private final ChartPanel chartPanel;
        private final String providerName;

        ChartPanelProviderHandler(ChartPanel chartPanel, String providerName) {
            this.chartPanel = chartPanel;
            this.providerName = providerName;
        }

        public void actionPerformed(ActionEvent e) {
            this.chartPanel.removeAll();
            ChartContentProvider chartProvider = (ChartContentProvider)BaseEhcacheStatsChartPanel.this.contentProviderMap.get(this.providerName);
            chartProvider.configure(this.chartPanel);
            BaseEhcacheStatsChartPanel.this.chartProviders[((BaseEhcacheStatsChartPanel)BaseEhcacheStatsChartPanel.this).indexOfChartPanel((ChartPanel)this.chartPanel)] = chartProvider;
            BaseEhcacheStatsChartPanel.this.activeProvidersPrefs.put(BaseEhcacheStatsChartPanel.ACTIVE_PROVIDERS_PREFS_KEY, StringUtils.join((Object[])BaseEhcacheStatsChartPanel.this.chartProviderNames(), (String)","));
            this.chartPanel.revalidate();
            this.chartPanel.repaint();
        }
    }

    public static interface ChartContentProvider {
        public String getName();

        public void configure(ChartPanel var1);

        public void acceptPolledAttributeResult(PolledAttributesResult var1, IClient var2, ObjectName var3);

        public void render();

        public void clear();
    }

    private class HitMissRateProvider
    implements ChartContentProvider {
        private TimeSeries hitRateSeries;
        private TimeSeries missRateSeries;
        private StatusView missRateLabel;
        private StatusView hitRateLabel;
        private final String missRateLabelFormat = "{0,number,integer} Misses/sec.";
        private final String hitRateLabelFormat = "{0,number,integer} Hits/sec.";
        private long missRate;
        private long hitRate;

        private HitMissRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            this.hitRateSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(bundle.getString("cache.hit.rate"));
            this.missRateSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(bundle.getString("cache.miss.rate"));
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(new TimeSeries[]{this.hitRateSeries, this.missRateSeries}, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder("Cache Hit/Miss Rate"));
            chartPanel.setToolTipText("Cache Hit/Miss Rate");
            chartPanel.setLayout((LayoutManager)new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            XContainer labelHolder = new XContainer((LayoutManager)new GridLayout(0, 1));
            this.hitRateLabel = BaseEhcacheStatsChartPanel.createStatusLabel((Color)EhcachePresentationUtils.HIT_DRAW_COLOR);
            labelHolder.add((Component)this.hitRateLabel);
            this.missRateLabel = BaseEhcacheStatsChartPanel.createStatusLabel((Color)EhcachePresentationUtils.MISS_DRAW_COLOR);
            labelHolder.add((Component)this.missRateLabel);
            labelHolder.setOpaque(false);
            chartPanel.add((Component)labelHolder, (Object)gbc);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.HIT_FILL_COLOR);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(1, (Paint)EhcachePresentationUtils.MISS_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_HIT_SAMPLE_ATTR);
            if (n != null) {
                this.hitRate += n.longValue();
            }
            if ((n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_MISS_SAMPLE_ATTR)) != null) {
                this.missRate += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.missRateSeries, this.missRate);
            this.missRateLabel.setText(MessageFormat.format("{0,number,integer} Misses/sec.", this.missRate));
            BaseEhcacheStatsChartPanel.this.updateSeries(this.hitRateSeries, this.hitRate);
            this.hitRateLabel.setText(MessageFormat.format("{0,number,integer} Hits/sec.", this.hitRate));
            this.hitRate = 0L;
            this.missRate = 0L;
        }

        public void clear() {
            if (this.hitRateSeries != null) {
                this.hitRateSeries.clear();
            }
            if (this.missRateSeries != null) {
                this.missRateSeries.clear();
            }
        }

        public String getName() {
            return "CacheHitMissRate";
        }
    }

    private class AverageGetTimeProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "Avg. Get Time: {0,number,#0.000} ms.";
        private float value;
        private int nodeCount;

        private AverageGetTimeProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = "Average Get Time";
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            XYPlot plot = (XYPlot)chart.getPlot();
            plot.getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.PUT_FILL_COLOR);
            NumberAxis numberAxis = (NumberAxis)plot.getRangeAxis();
            numberAxis.setAutoRangeMinimumSize(0.01);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_AVERAGE_GET_TIME_ATTR);
            if (n != null) {
                this.value += n.floatValue();
                ++this.nodeCount;
            }
        }

        public void render() {
            this.value = this.nodeCount > 0 ? (this.value /= (float)this.nodeCount) : 0.0f;
            Float f = Float.valueOf(this.value);
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, f);
            this.label.setText(MessageFormat.format("Avg. Get Time: {0,number,#0.000} ms.", f));
            this.value = 0.0f;
            this.nodeCount = 0;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_AVERAGE_GET_TIME_ATTR;
        }
    }

    private class OnDiskMissRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} OnDisk Misses/sec.";
        private long value;

        private OnDiskMissRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.on-disk.miss.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.MISS_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_ON_DISK_MISS_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} OnDisk Misses/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_ON_DISK_MISS_SAMPLE_ATTR;
        }
    }

    private class OffHeapMissRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} OffHeap Misses/sec.";
        private long value;

        private OffHeapMissRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.off-heap.miss.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.MISS_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_OFF_HEAP_MISS_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} OffHeap Misses/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_OFF_HEAP_MISS_SAMPLE_ATTR;
        }
    }

    private class InMemoryMissRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} InMemory Misses/sec.";
        private long value;

        private InMemoryMissRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.in-memory.miss.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.MISS_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_IN_MEMORY_MISS_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} InMemory Misses/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_IN_MEMORY_MISS_SAMPLE_ATTR;
        }
    }

    private class OnDiskHitRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} OnDisk Hits/sec.";
        private long value;

        private OnDiskHitRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.on-disk.hit.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.HIT_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_ON_DISK_HIT_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} OnDisk Hits/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_ON_DISK_HIT_SAMPLE_ATTR;
        }
    }

    private class OffHeapHitRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} OffHeap Hits/sec.";
        private long value;

        private OffHeapHitRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.off-heap.hit.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.HIT_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_OFF_HEAP_HIT_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} OffHeap Hits/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_OFF_HEAP_HIT_SAMPLE_ATTR;
        }
    }

    private class InMemoryHitRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} InMemory Hits/sec.";
        private long value;

        private InMemoryHitRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.in-memory.hit.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.HIT_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_IN_MEMORY_HIT_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} InMemory Hits/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_IN_MEMORY_HIT_SAMPLE_ATTR;
        }
    }

    private class ExpirationRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} Expirations/sec.";
        private long value;

        private ExpirationRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.expiration.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.MISS_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_EXPIRATION_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} Expirations/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_EXPIRATION_SAMPLE_ATTR;
        }
    }

    private class EvictionRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} Evictions/sec.";
        private long value;

        private EvictionRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.eviction.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.MISS_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_EVICTION_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} Evictions/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_EVICTION_SAMPLE_ATTR;
        }
    }

    private class RemoveRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} Removes/sec.";
        private long value;

        private RemoveRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.remove.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.MISS_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_REMOVE_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} Removes/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_REMOVE_SAMPLE_ATTR;
        }
    }

    private class PutRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} Puts/sec.";
        private long value;

        private PutRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.put.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.PUT_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_PUT_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} Puts/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_PUT_SAMPLE_ATTR;
        }
    }

    private class HitRatioProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,##}% Hit Ratio";
        private long hitRate;
        private long missRate;

        private HitRatioProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.hit.ratio");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            XYPlot plot = (XYPlot)chart.getPlot();
            ((NumberAxis)plot.getRangeAxis()).setRange(0.0, 105.0);
            plot.getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.HIT_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_HIT_SAMPLE_ATTR);
            if (n != null) {
                this.hitRate += n.longValue();
            }
            if ((n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_MISS_SAMPLE_ATTR)) != null) {
                this.missRate += n.longValue();
            }
        }

        public void render() {
            long readRate = this.hitRate + this.missRate;
            double cacheHitRatio = 0.0;
            if (readRate > 0L) {
                cacheHitRatio = (double)this.hitRate / (double)readRate * 100.0;
            }
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, cacheHitRatio);
            this.label.setText(MessageFormat.format("{0,number,##}% Hit Ratio", cacheHitRatio));
            this.missRate = 0L;
            this.hitRate = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return "CacheHitRatio";
        }
    }

    private class UpdateRateProvider
    implements ChartContentProvider {
        private TimeSeries timeSeries;
        private XLabel label;
        private final String labelFormat = "{0,number,integer} Updates/sec.";
        private long value;

        private UpdateRateProvider() {
        }

        public void configure(ChartPanel chartPanel) {
            String text = bundle.getString("cache.update.rate");
            this.timeSeries = BaseEhcacheStatsChartPanel.this.createTimeSeries(text);
            JFreeChart chart = BaseEhcacheStatsChartPanel.this.createChart(this.timeSeries, false);
            chartPanel.setChart(chart);
            chartPanel.setBorder((Border)new TitledBorder(text));
            chartPanel.setToolTipText(text);
            chartPanel.setLayout((LayoutManager)new BorderLayout());
            this.label = BaseEhcacheStatsChartPanel.createOverlayLabel();
            chartPanel.add((Component)this.label);
            ((XYPlot)chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)EhcachePresentationUtils.PUT_FILL_COLOR);
        }

        public void acceptPolledAttributeResult(PolledAttributesResult result, IClient client, ObjectName on) {
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, BaseEhcacheStatsChartPanel.CACHE_UPDATE_SAMPLE_ATTR);
            if (n != null) {
                this.value += n.longValue();
            }
        }

        public void render() {
            BaseEhcacheStatsChartPanel.this.updateSeries(this.timeSeries, this.value);
            this.label.setText(MessageFormat.format("{0,number,integer} Updates/sec.", this.value));
            this.value = 0L;
        }

        public void clear() {
            if (this.timeSeries != null) {
                this.timeSeries.clear();
            }
        }

        public String getName() {
            return BaseEhcacheStatsChartPanel.CACHE_UPDATE_SAMPLE_ATTR;
        }
    }

    private class ClusterListener
    extends AbstractClusterListener {
        private ClusterListener(IClusterModel clusterModel) {
            super(clusterModel);
        }

        protected void handleReady() {
            if (this.clusterModel.isReady()) {
                BaseEhcacheStatsChartPanel.this.init();
            } else {
                BaseEhcacheStatsChartPanel.this.suspend();
            }
        }

        protected void handleActiveCoordinator(IServer oldActive, IServer newActive) {
            if (oldActive != null) {
                oldActive.removeClientConnectionListener((ClientConnectionListener)BaseEhcacheStatsChartPanel.this);
            }
            if (newActive != null) {
                newActive.addClientConnectionListener((ClientConnectionListener)BaseEhcacheStatsChartPanel.this);
            }
        }

        protected void handleUncaughtError(Exception e) {
            if (BaseEhcacheStatsChartPanel.this.appContext != null) {
                BaseEhcacheStatsChartPanel.this.appContext.log((Throwable)e);
            } else {
                super.handleUncaughtError(e);
            }
        }
    }
}

