/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.BasicWorker;
import com.tc.admin.common.ExceptionHelper;
import com.tc.admin.common.LinkButton;
import com.tc.admin.common.SyncHTMLEditorKit;
import com.tc.admin.common.XAbstractAction;
import com.tc.admin.common.XButton;
import com.tc.admin.common.XCheckBox;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XObjectTable;
import com.tc.admin.common.XObjectTableModel;
import com.tc.admin.common.XScrollPane;
import com.tc.admin.common.XSplitPane;
import com.tc.admin.common.XTable;
import com.tc.admin.common.XTextPane;
import com.tc.admin.model.IClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.EditorKit;
import org.apache.commons.lang.StringUtils;
import org.terracotta.modules.ehcache.presentation.BaseClusterModelPanel;
import org.terracotta.modules.ehcache.presentation.CacheStatisticsTableModel;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.EhcacheToolBar;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheStatisticsModel;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

public abstract class BaseEhcacheRuntimeStatsPanel
extends BaseClusterModelPanel
implements HierarchyListener,
ListSelectionListener,
CacheManagerModelListener {
    protected final CacheManagerModel cacheManagerModel;
    protected XObjectTable cacheTable;
    protected CacheStatisticsTableModel cacheTableModel;
    protected CacheModel selectedCacheModel;
    private RefreshAction refreshStatisticsAction;
    private ClearStatisticsAction clearStatisticsAction;
    protected String[] DEFAULT_COLUMNS = new String[]{"ShortName", "CacheHitRatio", "AverageGetTimeMillis", "LocalHeapSize", "LocalDiskSize"};
    protected String[] selectedColumns;
    protected final Preferences visibleColumnsPrefs;
    protected static final String VISIBLE_COLUMNS_PREFS_KEY = "VisibleColumns";
    protected static final Map<String, String> COLUMN_HEADER_TIP_MAP = new HashMap<String, String>();
    protected static final Map<String, String> CUSTOMIZE_DESCRIPTION_MAP = new HashMap<String, String>();
    private static final TableModel EMPTY_TABLE_MODEL;
    protected int sortColumn = -1;
    protected int sortDirection = -1;
    private JButton selectColumnsButton;

    public BaseEhcacheRuntimeStatsPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        super(appContext, cacheManagerModel.getClusterModel());
        this.cacheManagerModel = cacheManagerModel;
        this.visibleColumnsPrefs = appContext.getPrefs().node(BaseEhcacheRuntimeStatsPanel.class.getName());
    }

    public void setup() {
        this.cacheManagerModel.addCacheManagerModelListener(this);
        super.setup();
    }

    protected CacheManagerModel getCacheManagerModel() {
        return this.cacheManagerModel;
    }

    private int indexOf(CacheModel cacheModel) {
        int rowCount = this.cacheTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            CacheStatisticsModel cacheStatisticsModel = (CacheStatisticsModel)this.cacheTableModel.getObjectAt(i);
            if (!cacheStatisticsModel.getCacheName().equals(cacheModel.getCacheName())) continue;
            return i;
        }
        return -1;
    }

    public void init() {
        this.updateStats();
    }

    public void suspend() {
    }

    protected XContainer createTopPanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        this.selectColumnsButton = LinkButton.makeLink((String)"Customize Columns...", (ActionListener)new CustomizeColumnsHandler());
        panel.add((Component)this.selectColumnsButton, (Object)"East");
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return panel;
    }

    protected XContainer createMainPanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        panel.add((Component)this.createTopPanel(), (Object)"North");
        this.cacheTableModel = new CacheStatisticsTableModel(this.getEffectiveTableColumns());
        this.cacheTable = new XObjectTable((TableModel)((Object)this.cacheTableModel)){

            public String getToolTipText(MouseEvent me) {
                int hitRowIndex = this.rowAtPoint(me.getPoint());
                int hitColIndex = this.columnAtPoint(me.getPoint());
                if (hitRowIndex != -1) {
                    if (hitColIndex == 0) {
                        CacheStatisticsModel crs = (CacheStatisticsModel)BaseEhcacheRuntimeStatsPanel.this.cacheTableModel.getObjectAt(hitRowIndex);
                        return crs.getCacheName();
                    }
                    if (hitColIndex > 1) {
                        int sum = 0;
                        for (int i = 0; i < BaseEhcacheRuntimeStatsPanel.this.cacheTableModel.getRowCount(); ++i) {
                            Number n = (Number)BaseEhcacheRuntimeStatsPanel.this.cacheTableModel.getValueAt(i, hitColIndex);
                            sum += n.intValue();
                        }
                        return Integer.toString(sum) + " Total " + BaseEhcacheRuntimeStatsPanel.this.cacheTableModel.getColumnName(hitColIndex);
                    }
                }
                return super.getToolTipText(me);
            }

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent me) {
                        int column = this.columnAtPoint(me.getPoint());
                        if (column != -1) {
                            TableColumn aColumn = this.columnModel.getColumn(column);
                            return COLUMN_HEADER_TIP_MAP.get(aColumn.getIdentifier());
                        }
                        return null;
                    }
                };
            }
        };
        this.cacheTable.setSelectionMode(0);
        this.cacheTable.addHierarchyListener((HierarchyListener)this);
        this.cacheTable.getSelectionModel().addListSelectionListener(this);
        panel.add((Component)new XScrollPane((Component)this.cacheTable), (Object)"Center");
        panel.add((Component)this.createBottomPanel(), (Object)"South");
        return panel;
    }

    protected JComponent createBottomPanel() {
        EhcacheToolBar bottomPanel = new EhcacheToolBar();
        this.refreshStatisticsAction = new RefreshAction();
        bottomPanel.add((Action)((Object)this.refreshStatisticsAction));
        this.clearStatisticsAction = new ClearStatisticsAction();
        bottomPanel.add((Action)((Object)this.clearStatisticsAction));
        return bottomPanel;
    }

    public void hierarchyChanged(HierarchyEvent e) {
        XObjectTable table = (XObjectTable)e.getComponent();
        if ((e.getChangeFlags() & 4L) != 0L && table.isShowing() && table == this.cacheTable) {
            this.updateStats();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            CacheModel cacheModel = null;
            int row = this.cacheTable.getSelectedRow();
            if (row != -1) {
                CacheStatisticsModel cacheStatisticsModel = (CacheStatisticsModel)this.cacheTableModel.getObjectAt(row);
                cacheModel = this.cacheManagerModel.getCacheModel(cacheStatisticsModel.getCacheName());
            }
            this.setSelectedCacheModel(cacheModel);
        }
    }

    public void setSelectedCacheModel(CacheModel cacheModel) {
        CacheModel oldSelectedCacheModel = this.selectedCacheModel;
        this.selectedCacheModel = cacheModel;
        if (cacheModel != null) {
            for (int i = 0; i < this.cacheTableModel.getRowCount(); ++i) {
                CacheStatisticsModel cacheStatisticsModel = (CacheStatisticsModel)this.cacheTableModel.getObjectAt(i);
                if (!cacheModel.getCacheName().equals(cacheStatisticsModel.getCacheName())) continue;
                this.cacheTable.setSelectedRow(i);
                break;
            }
        }
        if (oldSelectedCacheModel != cacheModel) {
            this.firePropertyChange("SelectedCacheModel", oldSelectedCacheModel, cacheModel);
        }
    }

    private void queryClearAllStats() {
        Frame frame;
        XLabel msg = new XLabel(bundle.getString("clear.all.counters.confirm"));
        int answer = JOptionPane.showConfirmDialog((Component)((Object)this), msg, (frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this))).getTitle(), 2);
        if (answer == 0) {
            this.appContext.submit((Runnable)((Object)new ClearAllStatsWorker()));
        }
    }

    protected void setSelectedTableColumns(String[] selectedColumns) {
        this.selectedColumns = selectedColumns;
        if (selectedColumns != null) {
            this.visibleColumnsPrefs.put(VISIBLE_COLUMNS_PREFS_KEY, StringUtils.join((Object[])selectedColumns, (String)","));
        } else {
            this.visibleColumnsPrefs.remove(VISIBLE_COLUMNS_PREFS_KEY);
        }
    }

    protected String[] getSelectedTableColumns() {
        return this.selectedColumns;
    }

    protected String[] getEffectiveTableColumns() {
        return this.selectedColumns != null ? this.selectedColumns : this.DEFAULT_COLUMNS;
    }

    protected abstract TableModelWorker createTableModelWorker();

    protected void setCacheStatisticsTableModel(CacheStatisticsTableModel tableModel) {
        int i;
        this.cacheTableModel = tableModel;
        this.cacheTable.setModel((TableModel)((Object)this.cacheTableModel));
        this.sortTable(this.cacheTable);
        try {
            i = this.cacheTable.getColumnModel().getColumnIndex("CacheHitRatio");
            this.cacheTable.getColumnModel().getColumn(i).setCellRenderer((TableCellRenderer)new XTable.PercentRenderer());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            i = this.cacheTable.getColumnModel().getColumnIndex("AverageGetTimeMillis");
            this.cacheTable.getColumnModel().getColumn(i).setCellRenderer((TableCellRenderer)((Object)new LatencyRenderer()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void cacheModelAdded(CacheModel cacheModel) {
    }

    public void cacheModelRemoved(CacheModel cacheModel) {
    }

    public void cacheModelChanged(CacheModel cacheModel) {
    }

    public void instanceAdded(CacheManagerInstance instance) {
    }

    public void instanceRemoved(CacheManagerInstance instance) {
    }

    public void clusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
    }

    public void clusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
    }

    public void clusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
    }

    public void standaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
    }

    public void standaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
    }

    public void standaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
    }

    public void clientConnected(IClient client) {
    }

    public void clientDisconnected(IClient client) {
    }

    protected void updateStats() {
        if (this.isShowing()) {
            this.cacheTable.setModel(EMPTY_TABLE_MODEL);
            this.refreshStatisticsAction.setEnabled(false);
            String vcp = this.visibleColumnsPrefs.get(VISIBLE_COLUMNS_PREFS_KEY, null);
            String[] vca = vcp == null ? this.DEFAULT_COLUMNS : StringUtils.split((String)vcp, (String)",");
            this.setSelectedTableColumns(vca);
            this.appContext.execute((Runnable)((Object)this.createTableModelWorker()));
        }
    }

    private void clearAllStats() {
        try {
            this.cacheManagerModel.clearStatistics();
        }
        catch (Exception e) {
            this.appContext.log((Throwable)e);
        }
    }

    private void sortTable(XObjectTable table) {
        if (this.sortColumn == -1) {
            this.sortColumn = table.getSortColumn();
            this.sortDirection = table.getSortDirection();
        }
        table.setSortColumn(this.sortColumn);
        table.setSortDirection(this.sortDirection);
        table.sort();
        ((XObjectTableModel)table.getModel()).fireTableDataChanged();
    }

    public void tearDown() {
        this.cacheManagerModel.removeCacheManagerModelListener(this);
        super.tearDown();
    }

    static {
        COLUMN_HEADER_TIP_MAP.put("CacheName", "<html>Full cache name</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("CacheName", "<html>The full cache name, as specified in the configuration<html/>");
        COLUMN_HEADER_TIP_MAP.put("ShortName", "<html>Short cache name</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("ShortName", "<html>The, possibly shortened, cache name.<p>If the name appears to be a fully-qualified Java class name, it will be shorted to include only the first letter of all non-final components:<p><code>com.myco.util.HelperClass --> c.m.u.HelperClass</code><html/>");
        COLUMN_HEADER_TIP_MAP.put("CacheHitRatio", "<html>Proportion of gets that resulted in cache hits</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("CacheHitRatio", "<html>The proportion of gets that resulted in cache hits.<p><code>hitRatio = hits/(hits+misses)</code></html>");
        COLUMN_HEADER_TIP_MAP.put("CacheHitCount", "<html>Number of gets that returned a non-null result</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("CacheHitCount", "<html>The total number of gets that returned a non-null result across all active caching tiers.</html>");
        COLUMN_HEADER_TIP_MAP.put("InMemoryHitCount", "<html>Number of gets that returned a non-null result<br>from local memory</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("InMemoryHitCount", "<html>The number of gets that returned a non-null result from the cache's local memory tier.</html>");
        COLUMN_HEADER_TIP_MAP.put("OffHeapHitCount", "<html>Number of gets that returned a non-null result<br>from the local off-heap memory</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("OffHeapHitCount", "<html>The number of gets that returned a non-null result from local off-heap memory.<p>The local off-heap memory feature is only available in the Terracotta Enterprise Edition.</html>");
        COLUMN_HEADER_TIP_MAP.put("OnDiskHitCount", "<html>Number of gets that returned a non-null result from the local disk<br>or the Terracotta Server Array</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("OnDiskHitCount", "<html>The number of gets that returned a non-null result from either the cache's local disk store or from the Terracotta Server Array.</html>");
        COLUMN_HEADER_TIP_MAP.put("CacheMissCount", "<html>Number of gets that returned a null result</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("CacheMissCount", "<html>The number of gets that returned a null result from each of the active caching tiers.</html>");
        COLUMN_HEADER_TIP_MAP.put("CacheMissCountExpired", "<html>Number of gets that returned a non-null result that was already expired</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("CacheMissCountExpired", "<html>The number of gets that returned a non-null result that was already expired due to TTI/TTL.</html>");
        COLUMN_HEADER_TIP_MAP.put("InMemoryMissCount", "<html>Number of gets that returned a null result from memory</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("InMemoryMissCount", "<html>The number of gets that returned a null result from the cache's local memory store.</html>");
        COLUMN_HEADER_TIP_MAP.put("OffHeapMissCount", "<html>Number of gets that returned a null result<br>from the Terracotta Server Array's off-heap memory</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("OffHeapMissCount", "<html>The number of gets that returned a null result from the Terracotta Server Array's off-heap memory store.<p>The TSA off-heap memory feature is only available in the Terracotta Enterprise Edition.</html>");
        COLUMN_HEADER_TIP_MAP.put("OnDiskMissCount", "<html>Number of gets that returned a null result from disk</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("OnDiskMissCount", "<html>The number of gets that returned a null result from either the cache's local disk store or the Terracotta Server Array's memory or persistent storage but not off-heap.</html>");
        COLUMN_HEADER_TIP_MAP.put("PutCount", "<html>Number of puts to the cache</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("PutCount", "<html>The number of puts to the cache.<p>An item put to the cache resides in one or more cache tiers, depending on how the cache has been configured.</html>");
        COLUMN_HEADER_TIP_MAP.put("UpdateCount", "<html>Number of puts to existing elements in the cache</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("UpdateCount", "<html>The number of puts to existing elements in the cache.</html>");
        COLUMN_HEADER_TIP_MAP.put("EvictedCount", "<html>Number of elements that have been removed from<br>the cache due to space limitations</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("EvictedCount", "<html>The number of elements that have been removed from the cache due to space limitations.<p>Eviction differs from expiration in that elements are expired from the cache due to the configured time-to-live (TTL) or time-to-expire (TTI).</html>");
        COLUMN_HEADER_TIP_MAP.put("ExpiredCount", "<html>Number of elements that have been removed from<br>the cache due to TTI/TTL</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("ExpiredCount", "<html>The number of elements that have been removed from the cache due to the configured time-to-live (TTL) or time-to-expire (TTI).<p>Expiration differs from eviction in that elements are evicted due to space limitations.</html>");
        COLUMN_HEADER_TIP_MAP.put("RemovedCount", "<html>Number of elements that have been manually<br>removed from the cache</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("RemovedCount", "<html>The number of elements that have been manually removed from the cache.<p>Clearing the cache, either programatically or via the JMX interface, is not consider for this metric.</html>");
        COLUMN_HEADER_TIP_MAP.put("AverageGetTimeMillis", "<html>Average cost in milliseconds to access an element in the cache</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("AverageGetTimeMillis", "<html>The average cost in milliseconds to attempt to access an element in the cache, regardless of whether or not a non-null value was returned.</html>");
        COLUMN_HEADER_TIP_MAP.put("MinGetTimeMillis", "<html>Minimum cost in milliseconds to access an element in the cache</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("MinGetTimeMillis", "<html>The minimum cost in milliseconds to attempt to access an element in the cache, regardless of whether or not a non-null value was returned.</html>");
        COLUMN_HEADER_TIP_MAP.put("MaxGetTimeMillis", "<html>Maximum cost in milliseconds to access an element in the cache</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("MaxGetTimeMillis", "<html>The maximun cost in milliseconds to attempt to access an element in the cache, regardless of whether or not a non-null value was returned.</html>");
        COLUMN_HEADER_TIP_MAP.put("LocalHeapSize", "<html>Number of elements held in cache's local memory store</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("LocalHeapSize", "<html>The number of elements held in the cache's local memory store.</html>");
        COLUMN_HEADER_TIP_MAP.put("LocalHeapSizeInBytes", "<html>Number of bytes held in cache's local memory store</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("LocalHeapSizeInBytes", "<html>The number of bytes held in the cache's local memory store.</html>");
        COLUMN_HEADER_TIP_MAP.put("LocalOffHeapSize", "<html>Number of elements held in cache's local offheap memory store</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("LocalOffHeapSize", "<html>The number of elements held in the cache's local offheap memory store.</html>");
        COLUMN_HEADER_TIP_MAP.put("LocalOffHeapSizeInBytes", "<html>Number of bytes held in cache's local offheap memory store</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("LocalOffHeapSizeInBytes", "<html>The number of bytes held in the cache's local offheap memory store.</html>");
        COLUMN_HEADER_TIP_MAP.put("LocalDiskSize", "<html>Number of elements residing in cache's local disk store</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("LocalDiskSize", "<html>The number of elements residing in the cache's local disk store</html>");
        COLUMN_HEADER_TIP_MAP.put("LocalDiskSizeInBytes", "<html>Number of bytes residing in cache's local disk store</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("LocalDiskSizeInBytes", "<html>The number of bytes residing in the cache's local disk store.</html>");
        COLUMN_HEADER_TIP_MAP.put("XaCommitCount", "<html>Number of times the cache has taken part in an XAResource commit</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("XaCommitCount", "<html>The number of times the cache has taken part in an XAResource commit.</html>");
        COLUMN_HEADER_TIP_MAP.put("XaRollbackCount", "<html>Number of times the cache has taken part in an XAResource rollback</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("XaRollbackCount", "<html>The number of times the cache has taken part in an XAResource rollback.</html>");
        COLUMN_HEADER_TIP_MAP.put("WriterQueueLength", "<html>Number of elements queued for write-through/write-behind to the database</html>");
        CUSTOMIZE_DESCRIPTION_MAP.put("WriterQueueLength", "<html>The number of elements queued for write-through/write-behind to the database.</html>");
        EMPTY_TABLE_MODEL = new XObjectTableModel();
    }

    public static class LatencyRenderer
    extends XTable.BaseRenderer {
        public LatencyRenderer() {
            super("#,##0.000;(#,##0.000)");
            this.label.setHorizontalAlignment(4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TableModelWorker
    extends BasicWorker<CacheStatisticsTableModel> {
        protected int selectedRow;

        protected TableModelWorker(Callable<CacheStatisticsTableModel> callable) {
            super(callable);
            this.selectedRow = BaseEhcacheRuntimeStatsPanel.this.cacheTable.getSelectedRow();
        }

        protected void finished() {
            Exception e = this.getException();
            if (e != null) {
                BaseEhcacheRuntimeStatsPanel.this.appContext.log(ExceptionHelper.getRootCause((Throwable)e));
            } else {
                BaseEhcacheRuntimeStatsPanel.this.setCacheStatisticsTableModel((CacheStatisticsTableModel)((Object)this.getResult()));
                if (this.selectedRow != -1) {
                    BaseEhcacheRuntimeStatsPanel.this.cacheTable.setSelectedRow(this.selectedRow);
                } else if (BaseEhcacheRuntimeStatsPanel.this.selectedCacheModel != null) {
                    this.selectedRow = BaseEhcacheRuntimeStatsPanel.this.indexOf(BaseEhcacheRuntimeStatsPanel.this.selectedCacheModel);
                    if (this.selectedRow != -1) {
                        BaseEhcacheRuntimeStatsPanel.this.cacheTable.setSelectedRow(this.selectedRow);
                    }
                }
            }
            BaseEhcacheRuntimeStatsPanel.this.refreshStatisticsAction.setEnabled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClearAllStatsWorker
    extends BasicWorker<Void> {
        private ClearAllStatsWorker() {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    BaseEhcacheRuntimeStatsPanel.this.clearAllStats();
                    return null;
                }
            });
            BaseEhcacheRuntimeStatsPanel.this.clearStatisticsAction.setEnabled(false);
        }

        protected void finished() {
            Exception e = this.getException();
            if (e != null) {
                Throwable rootCause = ExceptionHelper.getRootCause((Throwable)e);
                if (!(rootCause instanceof IOException)) {
                    BaseEhcacheRuntimeStatsPanel.this.appContext.log((Throwable)e);
                }
            } else {
                BaseEhcacheRuntimeStatsPanel.this.updateStats();
            }
            BaseEhcacheRuntimeStatsPanel.this.clearStatisticsAction.setEnabled(true);
        }
    }

    private class ClearStatisticsAction
    extends XAbstractAction {
        private ClearStatisticsAction() {
            super(BaseClusterModelPanel.bundle.getString("clear.all.statistics"), EhcachePresentationUtils.CLEAR_STATS_ICON);
        }

        public void actionPerformed(ActionEvent ae) {
            BaseEhcacheRuntimeStatsPanel.this.queryClearAllStats();
        }
    }

    private class RefreshAction
    extends XAbstractAction {
        private RefreshAction() {
            super(BaseClusterModelPanel.bundle.getString("refresh"), (Icon)new ImageIcon(RefreshAction.class.getResource("/com/tc/admin/icons/refresh.gif")));
        }

        public void actionPerformed(ActionEvent ae) {
            BaseEhcacheRuntimeStatsPanel.this.updateStats();
        }
    }

    protected class CustomizeColumnsHandler
    implements ActionListener {
        protected CustomizeColumnsHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            CustomizeColumnsMessage message = new CustomizeColumnsMessage();
            int result = JOptionPane.showConfirmDialog(BaseEhcacheRuntimeStatsPanel.this.selectColumnsButton, message, "Customize Columns", 2, -1);
            if (result == 0) {
                message.acceptResults();
            }
        }
    }

    protected class CustomizeColumnsMessage
    extends XContainer
    implements MouseListener,
    FocusListener {
        private final XCheckBox[] cbArray;
        private final XLabel textHeader;
        private final XTextPane textPane;
        private final XCheckBox selectToggle;

        protected CustomizeColumnsMessage() {
            super((LayoutManager)new BorderLayout());
            List<String> currentlySelectedColumns = Arrays.asList(BaseEhcacheRuntimeStatsPanel.this.getEffectiveTableColumns());
            XContainer controlsPanel = new XContainer((LayoutManager)new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridy = 0;
            gbc.gridx = 0;
            this.cbArray = new XCheckBox[CacheStatisticsModel.ATTRS.length];
            for (int i = 0; i < CacheStatisticsModel.ATTRS.length; ++i) {
                XCheckBox cb = new XCheckBox(CacheStatisticsModel.HEADERS[i]);
                controlsPanel.add((Component)cb, (Object)gbc);
                cb.setName(CacheStatisticsModel.ATTRS[i]);
                cb.setSelected(currentlySelectedColumns.contains(CacheStatisticsModel.ATTRS[i]));
                cb.addMouseListener((MouseListener)this);
                cb.addFocusListener((FocusListener)this);
                this.cbArray[i] = cb;
                ++gbc.gridy;
            }
            XContainer bottomPanel = new XContainer((LayoutManager)new FlowLayout());
            XButton resetButton = new XButton("Reset to defaults");
            bottomPanel.add((Component)resetButton);
            resetButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    CustomizeColumnsMessage.this.handleResetToggle();
                }
            });
            this.selectToggle = new XCheckBox("Select/De-select");
            bottomPanel.add((Component)this.selectToggle);
            this.selectToggle.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    CustomizeColumnsMessage.this.handleSelectToggle();
                }
            });
            XContainer textPanel = new XContainer((LayoutManager)new BorderLayout());
            this.textHeader = new XLabel();
            textPanel.add((Component)this.textHeader, (Object)"North");
            this.textHeader.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.textPane = new XTextPane();
            textPanel.add((Component)new XScrollPane((Component)this.textPane), (Object)"Center");
            XScrollPane controlScroller = new XScrollPane((Component)controlsPanel);
            controlScroller.setPreferredSize(new Dimension(200, 300));
            XSplitPane centerPanel = new XSplitPane(1, (Component)controlScroller, (Component)textPanel);
            this.textPane.setPreferredSize(new Dimension(320, 250));
            this.textPane.setEditable(false);
            this.textPane.setEditorKit((EditorKit)new SyncHTMLEditorKit());
            this.textPane.setBackground(Color.WHITE);
            centerPanel.setDefaultDividerLocation(0.35);
            this.add((Component)centerPanel);
            this.add((Component)bottomPanel, "South");
        }

        private void handleResetToggle() {
            List<String> defaultsList = Arrays.asList(BaseEhcacheRuntimeStatsPanel.this.DEFAULT_COLUMNS);
            for (int i = 0; i < CacheStatisticsModel.ATTRS.length; ++i) {
                this.cbArray[i].setSelected(defaultsList.contains(CacheStatisticsModel.ATTRS[i]));
            }
        }

        private void handleSelectToggle() {
            for (XCheckBox cb : this.cbArray) {
                cb.setSelected(this.selectToggle.isSelected());
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            ((XCheckBox)e.getSource()).requestFocus();
        }

        public void mouseExited(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
            XCheckBox cb = (XCheckBox)e.getSource();
            String name = cb.getName();
            this.textHeader.setText(cb.getText());
            String description = CUSTOMIZE_DESCRIPTION_MAP.get(name);
            if (description == null) {
                description = COLUMN_HEADER_TIP_MAP.get(name);
            }
            this.textPane.setText(description);
        }

        public void focusLost(FocusEvent e) {
            this.textPane.setText("");
        }

        void acceptResults() {
            ArrayList<String> selected = new ArrayList<String>();
            for (int i = 0; i < CacheStatisticsModel.ATTRS.length; ++i) {
                if (!this.cbArray[i].isSelected()) continue;
                selected.add(CacheStatisticsModel.ATTRS[i]);
            }
            BaseEhcacheRuntimeStatsPanel.this.setSelectedTableColumns(selected.toArray(new String[0]));
            BaseEhcacheRuntimeStatsPanel.this.updateStats();
        }
    }
}

