/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.AbstractClusterListener;
import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.model.ClientConnectionListener;
import com.tc.admin.model.IClient;
import com.tc.admin.model.IClusterModel;
import com.tc.admin.model.IServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import javax.management.MBeanException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.terracotta.modules.ehcache.presentation.EhcacheResourceBundle;
import org.terracotta.modules.ehcache.presentation.ErrorMessage;

public abstract class BaseClusterModelPanel
extends XContainer
implements ClientConnectionListener {
    protected final ApplicationContext appContext;
    protected final IClusterModel clusterModel;
    protected final ClusterListener clusterListener;
    protected XContainer mainPanel;
    protected XContainer messagePanel;
    protected XLabel messageLabel;
    protected static final ResourceBundle bundle = ResourceBundle.getBundle(EhcacheResourceBundle.class.getName());

    public BaseClusterModelPanel(ApplicationContext appContext, IClusterModel clusterModel) {
        super((LayoutManager)new BorderLayout());
        this.appContext = appContext;
        this.clusterModel = clusterModel;
        this.clusterListener = new ClusterListener(clusterModel);
    }

    protected abstract void init();

    protected abstract XContainer createMainPanel();

    public void clientConnected(IClient client) {
    }

    public void clientDisconnected(IClient client) {
    }

    public ApplicationContext getApplicationContext() {
        return this.appContext;
    }

    public IClusterModel getClusterModel() {
        return this.clusterModel;
    }

    public IServer getActiveCoordinator() {
        return this.clusterModel.getActiveCoordinator();
    }

    public void setup() {
        this.clusterModel.addPropertyChangeListener((PropertyChangeListener)((Object)this.clusterListener));
        IServer activeCoord = this.getActiveCoordinator();
        if (activeCoord != null) {
            activeCoord.addClientConnectionListener((ClientConnectionListener)this);
        }
        this.setLayout(new BorderLayout());
        this.mainPanel = this.createMainPanel();
        this.messagePanel = this.createMessagePanel();
        if (this.clusterModel.isReady()) {
            this.resume();
        } else {
            this.suspend();
        }
    }

    protected void resume() {
        this.removeAll();
        this.init();
        this.add((Component)this.mainPanel);
        this.revalidate();
        this.repaint();
    }

    protected void suspend() {
        this.removeAll();
        this.messageLabel.setText(this.appContext.getString("cluster.not.ready.msg"));
        this.add((Component)this.messagePanel);
        this.revalidate();
        this.repaint();
    }

    private XContainer createMessagePanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        this.messageLabel = new XLabel();
        panel.add((Component)this.messageLabel);
        this.messageLabel.setText(this.appContext.getString("initializing"));
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setFont((Font)this.appContext.getObject("message.label.font"));
        return panel;
    }

    protected void setStatus(String text) {
        this.appContext.setStatus(text);
    }

    protected static void updateAction(AbstractAction action, String name, Icon icon) {
        BaseClusterModelPanel.updateAction(action, name, null, icon);
    }

    protected static void updateAction(AbstractAction action, String name, String tooltip, Icon icon) {
        action.putValue("Name", name);
        action.putValue("SmallIcon", icon);
        if (icon != null && tooltip == null) {
            tooltip = name;
        }
        action.putValue("ShortDescription", tooltip);
    }

    protected void showError(String msg) {
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        JOptionPane.showMessageDialog((Component)((Object)this), new ErrorMessage(msg), f.getTitle(), 0);
    }

    protected void showError(String msg, Throwable t) {
        if (t instanceof MBeanException) {
            t = ((MBeanException)t).getCause();
        }
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getCause();
        }
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        JOptionPane.showMessageDialog((Component)((Object)this), new ErrorMessage(msg, t), f.getTitle(), 0);
    }

    protected static GridBagConstraints createConstraint() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 0;
        gbc.gridx = 0;
        return gbc;
    }

    public void tearDown() {
        IServer activeCoord = this.getActiveCoordinator();
        if (activeCoord != null) {
            activeCoord.removeClientConnectionListener((ClientConnectionListener)this);
        }
        this.clusterModel.removePropertyChangeListener((PropertyChangeListener)((Object)this.clusterListener));
        this.clusterListener.tearDown();
        if (this.mainPanel != null && this.mainPanel.getParent() == null) {
            this.mainPanel.tearDown();
        }
        if (this.messagePanel != null && this.messagePanel.getParent() == null) {
            this.messagePanel.tearDown();
        }
        super.tearDown();
    }

    private class ClusterListener
    extends AbstractClusterListener {
        private ClusterListener(IClusterModel clusterModel) {
            super(clusterModel);
        }

        protected void handleReady() {
            if (this.clusterModel.isReady()) {
                BaseClusterModelPanel.this.resume();
            } else {
                BaseClusterModelPanel.this.suspend();
            }
        }

        protected void handleActiveCoordinator(IServer oldActive, IServer newActive) {
            if (oldActive != null) {
                oldActive.removeClientConnectionListener((ClientConnectionListener)BaseClusterModelPanel.this);
            }
            if (newActive != null) {
                newActive.addClientConnectionListener((ClientConnectionListener)BaseClusterModelPanel.this);
            }
        }

        protected void handleUncaughtError(Exception e) {
            BaseClusterModelPanel.this.appContext.log((Throwable)e);
        }
    }
}

