/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.AbstractClusterListener;
import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.XContainer;
import com.tc.admin.model.ClientConnectionListener;
import com.tc.admin.model.IClient;
import com.tc.admin.model.IClusterModel;
import com.tc.admin.model.IClusterNode;
import com.tc.admin.model.IServer;
import com.tc.admin.model.PolledAttributeListener;
import com.tc.admin.model.PolledAttributesResult;
import com.tc.admin.options.RuntimeStatsOption;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.ObjectName;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.EhcacheStatsUtils;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;

public class AggregateVuMeterPanel
extends XContainer
implements PolledAttributeListener,
ClientConnectionListener,
Runnable {
    private static final String GLOBAL_MODE_CACHE_NAME = "";
    private static final int VU_HIT_HEIGHT = 10;
    private static final int VU_MISS_HEIGHT = 10;
    private static final int VU_PUT_HEIGHT = 10;
    private static final int VU_HEIGHT = 30;
    private static final int VU_X_MARGIN_LEFT = 55;
    private static final int VU_X_SPACING = 5;
    private static final int VU_X_MARGIN_RIGHT = 55;
    private static final int VU_Y_SPACING = 35;
    private static final int VU_MAX_DECAY_POLL_MULTIPLE = 3;
    private static final int ANIMATION_POLL_PERIOD_DIVIDER = 15;
    private static final int ANIMATION_FPS = 15;
    private static final int ANIMATION_THREAD_SLEEP = 66;
    private static final Color VU_BACKGROUND_COLOR = Color.WHITE;
    private static final Color VU_HIT_FILL_COLOR = EhcachePresentationUtils.HIT_FILL_COLOR;
    private static final Color VU_MISS_FILL_COLOR = EhcachePresentationUtils.MISS_FILL_COLOR;
    private static final Color VU_PUT_FILL_COLOR = EhcachePresentationUtils.PUT_FILL_COLOR;
    private static final Color VU_HIT_DRAW_COLOR = EhcachePresentationUtils.HIT_DRAW_COLOR;
    private static final Color VU_MISS_DRAW_COLOR = EhcachePresentationUtils.MISS_DRAW_COLOR;
    private static final Color VU_PUT_DRAW_COLOR = EhcachePresentationUtils.PUT_DRAW_COLOR;
    private static final String CACHE_METRICS_ATTR = "CacheMetrics";
    private static final String[] POLLED_ATTRS = new String[]{"CacheMetrics"};
    private static final Set<String> POLLED_ATTRS_SET = new HashSet<String>(Arrays.asList(POLLED_ATTRS));
    private final ApplicationContext appContext;
    private final boolean globalMode;
    private final IClusterModel clusterModel;
    private final ClusterListener clusterListener;
    private final ObjectName tmplName;
    private CacheSamplesPanel cacheSamplesPanel;
    private JScrollPane cacheSamplesScrollPane;

    protected AggregateVuMeterPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel, boolean globalMode) {
        this.appContext = appContext;
        this.clusterModel = cacheManagerModel.getClusterModel();
        this.globalMode = globalMode;
        this.clusterListener = new ClusterListener(this.clusterModel);
        try {
            this.tmplName = EhcacheStatsUtils.getSampledCacheManagerBeanName(cacheManagerModel.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setLayout(new BorderLayout());
        this.setupCacheSamplesPanel();
    }

    public void run() {
        if (this.cacheSamplesPanel != null) {
            this.cacheSamplesPanel.repaint();
        }
    }

    public void setup() {
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            activeCoord.addClientConnectionListener((ClientConnectionListener)this);
        }
        this.clusterModel.addPropertyChangeListener((PropertyChangeListener)((Object)this.clusterListener));
        if (this.clusterModel.isReady()) {
            this.init();
        }
    }

    protected void init() {
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            activeCoord.addClientConnectionListener((ClientConnectionListener)this);
        }
        if (!this.cacheSamplesPanel.isStarted()) {
            this.cacheSamplesPanel.start();
            this.addPolledAttributeListener();
        }
    }

    public void suspend() {
        this.removePolledAttributeListener();
        this.cacheSamplesPanel.stop();
    }

    public void clientConnected(IClient client) {
        ObjectName on = client.getTunneledBeanName(this.tmplName);
        client.addPolledAttributeListener(on, POLLED_ATTRS_SET, (PolledAttributeListener)this);
    }

    public void clientDisconnected(IClient client) {
        ObjectName on = client.getTunneledBeanName(this.tmplName);
        client.removePolledAttributeListener(on, POLLED_ATTRS_SET, (PolledAttributeListener)this);
    }

    protected void addPolledAttributeListener() {
        for (IClient client : this.clusterModel.getClients()) {
            this.clientConnected(client);
        }
    }

    protected void removePolledAttributeListener() {
        for (IClient client : this.clusterModel.getClients()) {
            this.clientDisconnected(client);
        }
    }

    private void setupCacheSamplesPanel() {
        this.cacheSamplesPanel = new CacheSamplesPanel();
        if (this.globalMode) {
            this.add(this.cacheSamplesPanel);
        } else {
            this.cacheSamplesScrollPane = new JScrollPane(this.cacheSamplesPanel);
            this.cacheSamplesScrollPane.setHorizontalScrollBarPolicy(31);
            this.cacheSamplesScrollPane.setVerticalScrollBarPolicy(20);
            this.cacheSamplesScrollPane.getVerticalScrollBar().setUnitIncrement(16);
            this.add(this.cacheSamplesScrollPane);
        }
        this.repaint();
    }

    private void repaintCacheSamplesPanel() {
        SwingUtilities.invokeLater(this);
    }

    public void attributesPolled(PolledAttributesResult result) {
        HashMap<String, long[]> aggregated = new HashMap<String, long[]>();
        for (IClient client : this.clusterModel.getClients()) {
            ObjectName on = client.getTunneledBeanName(this.tmplName);
            Map clientSamples = (Map)result.getPolledAttribute((IClusterNode)client, on, CACHE_METRICS_ATTR);
            if (clientSamples == null) continue;
            for (Map.Entry entry : clientSamples.entrySet()) {
                String cacheName = this.globalMode ? GLOBAL_MODE_CACHE_NAME : (String)entry.getKey();
                if (cacheName.endsWith("org.hibernate.cache.UpdateTimestampsCache")) continue;
                long[] currentSamples = (long[])entry.getValue();
                long[] existingSamples = (long[])aggregated.get(cacheName);
                if (null == existingSamples) {
                    existingSamples = new long[currentSamples.length];
                    System.arraycopy(currentSamples, 0, existingSamples, 0, currentSamples.length);
                    aggregated.put(cacheName, existingSamples);
                    continue;
                }
                for (int i = 0; i < currentSamples.length; ++i) {
                    int n = i;
                    existingSamples[n] = existingSamples[n] + currentSamples[i];
                }
            }
        }
        this.cacheSamplesPanel.setCacheSamples(aggregated);
        this.repaintCacheSamplesPanel();
    }

    public void tearDown() {
        this.removePolledAttributeListener();
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            activeCoord.removeClientConnectionListener((ClientConnectionListener)this);
        }
        this.clusterModel.removePropertyChangeListener((PropertyChangeListener)((Object)this.clusterListener));
        this.clusterListener.tearDown();
        super.tearDown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CacheSamplesPanel
    extends JPanel
    implements Runnable {
        private long lastCacheSamplesUpdate = System.currentTimeMillis();
        private double lastScaleFactor = -1.0;
        private volatile Map<String, long[]> currentCacheSamples;
        private volatile Map<String, long[]> previousCacheRenders;
        private volatile Map<String, long[]> currentCacheRenders;
        private final Map<String, MaxLevel[]> maxLevels = new HashMap<String, MaxLevel[]>();
        private Thread thread;

        CacheSamplesPanel() {
            this.setOpaque(false);
        }

        public synchronized boolean isStarted() {
            return this.thread != null;
        }

        public synchronized void start() {
            if (!this.isStarted()) {
                this.thread = new Thread(this);
                this.thread.setPriority(1);
                this.thread.start();
            }
        }

        public synchronized void stop() {
            Thread theThread = this.thread;
            this.thread = null;
            if (theThread != null) {
                theThread.interrupt();
            }
        }

        private synchronized Thread getThread() {
            return this.thread;
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.stop();
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.getThread() == me) {
                AggregateVuMeterPanel.this.repaintCacheSamplesPanel();
                try {
                    Thread.sleep(66L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            this.thread = null;
        }

        private long getPollPeriodMillis() {
            RuntimeStatsOption runtimeStatsOption = (RuntimeStatsOption)AggregateVuMeterPanel.this.appContext.getOption("RuntimeStats");
            if (runtimeStatsOption != null) {
                return runtimeStatsOption.getPollPeriodSeconds() * 1000;
            }
            return 0L;
        }

        private synchronized Map<String, long[]> calculateRenderedSamples(double scaleFactor) {
            TreeMap<String, long[]> calculatedSamples = new TreeMap<String, long[]>();
            if (null == this.currentCacheSamples || this.currentCacheSamples.isEmpty()) {
                return calculatedSamples;
            }
            long animationPeriod = this.getPollPeriodMillis() / 15L;
            if (null == this.currentCacheRenders || this.lastScaleFactor != scaleFactor) {
                TreeMap<String, long[]> renders = new TreeMap<String, long[]>();
                for (Map.Entry<String, long[]> entry : this.currentCacheSamples.entrySet()) {
                    long[] current = entry.getValue();
                    long[] calculated = new long[current.length];
                    for (int i = 0; i < current.length; ++i) {
                        calculated[i] = (long)((double)current[i] * scaleFactor);
                    }
                    renders.put(entry.getKey(), calculated);
                }
                this.currentCacheRenders = renders;
            }
            long timeSinceLastUpdate = System.currentTimeMillis() - this.lastCacheSamplesUpdate;
            if (this.lastScaleFactor != scaleFactor) {
                this.lastScaleFactor = scaleFactor;
                return this.currentCacheRenders;
            }
            if (null == this.previousCacheRenders || timeSinceLastUpdate > animationPeriod) {
                return this.currentCacheRenders;
            }
            double animationCoefficient = (double)timeSinceLastUpdate / (double)animationPeriod;
            for (Map.Entry<String, long[]> entry : this.currentCacheRenders.entrySet()) {
                long[] previousScaled = this.previousCacheRenders.get(entry.getKey());
                long[] currentScaled = entry.getValue();
                if (null == previousScaled) {
                    previousScaled = currentScaled;
                }
                long[] calculated = new long[currentScaled.length];
                for (int i = 0; i < currentScaled.length; ++i) {
                    long calculatedValue;
                    calculated[i] = calculatedValue = (long)((double)previousScaled[i] + (double)(currentScaled[i] - previousScaled[i]) * animationCoefficient);
                }
                calculatedSamples.put(entry.getKey(), calculated);
            }
            return calculatedSamples;
        }

        private int getVerticalAlignment(int heightToAlignTo, FontMetrics metrics) {
            return (heightToAlignTo - metrics.getHeight()) / 2 + metrics.getDescent();
        }

        @Override
        public synchronized void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Dimension size = this.getSize();
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            Font statsFont = new Font("SansSerif", 0, 11);
            FontMetrics statsFontMetrics = g2.getFontMetrics(statsFont);
            Font cacheNamesFont = new Font("SansSerif", 0, 12);
            FontMetrics cacheNamesFontMetrics = g2.getFontMetrics(cacheNamesFont);
            if (this.currentCacheSamples != null) {
                long topRate = 0L;
                for (Map.Entry<String, long[]> entry : this.currentCacheSamples.entrySet()) {
                    if (entry.getValue()[0] > topRate) {
                        topRate = entry.getValue()[0];
                    }
                    if (entry.getValue()[1] > topRate) {
                        topRate = entry.getValue()[1];
                    }
                    long[] currentLevels = entry.getValue();
                    MaxLevel[] previousMaxLevels = this.maxLevels.get(entry.getKey());
                    MaxLevel[] currentMaxLevels = new MaxLevel[3];
                    if (null == previousMaxLevels) {
                        for (int i = 0; i < currentLevels.length; ++i) {
                            currentMaxLevels[i] = new MaxLevel(currentLevels[i]);
                        }
                    } else {
                        long maxLevelExpiration = this.getPollPeriodMillis() * 3L;
                        for (int i = 0; i < currentLevels.length; ++i) {
                            currentMaxLevels[i] = maxLevelExpiration > 0L && System.currentTimeMillis() - previousMaxLevels[i].getMoment() > maxLevelExpiration || currentLevels[i] > previousMaxLevels[i].getValue() ? new MaxLevel(currentLevels[i]) : previousMaxLevels[i];
                        }
                    }
                    this.maxLevels.put(entry.getKey(), currentMaxLevels);
                    for (MaxLevel currentMaxLevel : currentMaxLevels) {
                        if (currentMaxLevel.getValue() <= topRate) continue;
                        topRate = currentMaxLevel.getValue();
                    }
                }
                int maxWidth = (int)size.getWidth() - 110;
                double scaleFactor = 1.0;
                if (topRate > 0L) {
                    scaleFactor = (double)maxWidth / (double)topRate;
                }
                int y = 0;
                for (Map.Entry<String, long[]> entry : this.calculateRenderedSamples(scaleFactor).entrySet()) {
                    y += 35;
                    if (AggregateVuMeterPanel.this.globalMode) {
                        y -= cacheNamesFontMetrics.getHeight();
                    } else {
                        String cacheName = entry.getKey().toString();
                        g2.setFont(cacheNamesFont);
                        g2.setColor(Color.BLACK);
                        g2.drawString(cacheName, 55, y - 4);
                    }
                    g2.setFont(statsFont);
                    g2.setColor(VU_BACKGROUND_COLOR);
                    g2.fillRect(55, y, maxWidth, 30);
                    long hitWidth = entry.getValue()[0];
                    g2.setColor(VU_HIT_FILL_COLOR);
                    g2.fillRect(55, y, (int)hitWidth, 10);
                    String currentHitText = String.valueOf(this.currentCacheSamples.get(entry.getKey())[0]);
                    int currentHitTextWidth = statsFontMetrics.stringWidth(currentHitText);
                    g2.setColor(VU_HIT_DRAW_COLOR);
                    g2.drawString(currentHitText, 50 - currentHitTextWidth, 1 + (y += 10) - this.getVerticalAlignment(10, statsFontMetrics));
                    long missWidth = entry.getValue()[1];
                    g2.setColor(VU_MISS_FILL_COLOR);
                    g2.fillRect(55, y, (int)missWidth, 10);
                    String currentMissText = String.valueOf(this.currentCacheSamples.get(entry.getKey())[1]);
                    int currentMissTextWidth = statsFontMetrics.stringWidth(currentMissText);
                    g2.setColor(VU_MISS_DRAW_COLOR);
                    g2.drawString(currentMissText, 50 - currentMissTextWidth, 1 + (y += 10) - this.getVerticalAlignment(10, statsFontMetrics));
                    long putWidth = entry.getValue()[2];
                    g2.setColor(VU_PUT_FILL_COLOR);
                    g2.fillRect(55, y, (int)putWidth, 10);
                    String currentPutText = String.valueOf(this.currentCacheSamples.get(entry.getKey())[2]);
                    int currentPutTextWidth = statsFontMetrics.stringWidth(currentPutText);
                    g2.setColor(VU_PUT_DRAW_COLOR);
                    g2.drawString(currentPutText, 50 - currentPutTextWidth, 1 + (y += 10) - this.getVerticalAlignment(10, statsFontMetrics));
                    int adaptedY = y - 30;
                    g2.setColor(Color.BLACK);
                    g2.drawLine(55, adaptedY, maxWidth + 55, adaptedY);
                    g2.drawLine(55, adaptedY + 10, maxWidth + 55, adaptedY + 10);
                    g2.drawLine(55, adaptedY + 10 + 10, maxWidth + 55, adaptedY + 10 + 10);
                    g2.drawLine(55, adaptedY + 30, maxWidth + 55, adaptedY + 30);
                    g2.drawLine(55, adaptedY, 55, adaptedY + 30);
                    MaxLevel[] cacheMaxLevels = this.maxLevels.get(entry.getKey());
                    if (cacheMaxLevels == null) continue;
                    int maxHitX = (int)((double)cacheMaxLevels[0].getValue() * scaleFactor);
                    if (maxHitX < 2) {
                        maxHitX = 2;
                    }
                    g2.setColor(VU_HIT_DRAW_COLOR);
                    g2.fillRect(maxHitX - 1 + 55, adaptedY + 1, 2, 9);
                    int maxMissX = (int)((double)cacheMaxLevels[1].getValue() * scaleFactor);
                    if (maxMissX < 2) {
                        maxMissX = 2;
                    }
                    g2.setColor(VU_MISS_DRAW_COLOR);
                    g2.fillRect(maxMissX - 1 + 55, adaptedY + 1 + 10, 2, 9);
                    int maxPutX = (int)((double)cacheMaxLevels[2].getValue() * scaleFactor);
                    if (maxPutX < 2) {
                        maxPutX = 2;
                    }
                    g2.setColor(VU_PUT_DRAW_COLOR);
                    g2.fillRect(maxPutX - 1 + 55, adaptedY + 1 + 10 + 10, 2, 9);
                    g2.setFont(statsFont);
                    String maxHitText = String.valueOf(cacheMaxLevels[0].getValue());
                    g2.setColor(VU_HIT_DRAW_COLOR);
                    g2.drawString(maxHitText, 60 + maxWidth, 1 + adaptedY + 10 - this.getVerticalAlignment(10, statsFontMetrics));
                    String maxMissText = String.valueOf(cacheMaxLevels[1].getValue());
                    g2.setColor(VU_MISS_DRAW_COLOR);
                    g2.drawString(maxMissText, 60 + maxWidth, 1 + adaptedY + 10 + 10 - this.getVerticalAlignment(10, statsFontMetrics));
                    String maxPutText = String.valueOf(cacheMaxLevels[2].getValue());
                    g2.setColor(VU_PUT_DRAW_COLOR);
                    g2.drawString(maxPutText, 60 + maxWidth, 1 + adaptedY + 30 - this.getVerticalAlignment(10, statsFontMetrics));
                }
                int totalVUHeight = y + 35 - statsFontMetrics.getHeight();
                Dimension preferredSize = this.getPreferredSize();
                if (preferredSize.getWidth() != (double)this.getParent().getWidth() || preferredSize.getHeight() != (double)totalVUHeight) {
                    Dimension newPreferredSize = new Dimension(this.getParent().getWidth(), totalVUHeight);
                    this.setPreferredSize(newPreferredSize);
                    this.setMinimumSize(newPreferredSize);
                    this.setMaximumSize(newPreferredSize);
                    if (null == AggregateVuMeterPanel.this.cacheSamplesScrollPane) {
                        AggregateVuMeterPanel.this.revalidate();
                    } else {
                        AggregateVuMeterPanel.this.cacheSamplesScrollPane.revalidate();
                    }
                }
            }
        }

        public synchronized void setCacheSamples(Map<String, long[]> polledAttribute) {
            this.previousCacheRenders = this.currentCacheRenders;
            this.currentCacheSamples = new TreeMap<String, long[]>(polledAttribute);
            this.currentCacheRenders = null;
            this.lastCacheSamplesUpdate = System.currentTimeMillis();
        }
    }

    private static class MaxLevel {
        private final long value;
        private final long moment;

        public MaxLevel(long value) {
            this.value = value;
            this.moment = System.currentTimeMillis();
        }

        public long getValue() {
            return this.value;
        }

        public long getMoment() {
            return this.moment;
        }
    }

    private class ClusterListener
    extends AbstractClusterListener {
        private ClusterListener(IClusterModel clusterModel) {
            super(clusterModel);
        }

        protected void handleReady() {
            if (this.clusterModel.isReady()) {
                AggregateVuMeterPanel.this.init();
            } else {
                AggregateVuMeterPanel.this.suspend();
            }
        }

        protected void handleActiveCoordinator(IServer oldActive, IServer newActive) {
            if (oldActive != null) {
                oldActive.removeClientConnectionListener((ClientConnectionListener)AggregateVuMeterPanel.this);
            }
            if (newActive != null) {
                newActive.addClientConnectionListener((ClientConnectionListener)AggregateVuMeterPanel.this);
            }
        }

        protected void handleUncaughtError(Exception e) {
            AggregateVuMeterPanel.this.appContext.log((Throwable)e);
        }
    }
}

