/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.XContainer;
import com.tc.admin.common.XRootNode;
import com.tc.admin.common.XScrollPane;
import com.tc.admin.common.XTree;
import com.tc.admin.common.XTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.terracotta.modules.ehcache.presentation.CheckBoxNodeEditor;
import org.terracotta.modules.ehcache.presentation.CheckBoxNodeRenderer;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.EhcacheResourceBundle;
import org.terracotta.modules.ehcache.presentation.ManageChannel;
import org.terracotta.modules.ehcache.presentation.SelectionModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceListener;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.EhcacheModelListener;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractViewPage
extends XContainer
implements CacheManagerModelListener,
CacheManagerInstanceListener,
EhcacheModelListener,
Runnable {
    protected ManageChannel channel;
    protected CacheManagerModel cacheManagerModel;
    protected SelectionModelTreeModel treeModel;
    protected XTree tree;
    protected boolean isAllSelected;
    protected boolean isAllDeselected;
    protected boolean isSomeSelected;
    protected static final int CONTROL_OFFSET = 20;
    protected static final Insets CONTROL_MARGIN = new Insets(1, 1, 1, 1);
    public static final String ALL_SELECTED_PROP = "ALL_SELECTED";
    public static final String ALL_DESELECTED_PROP = "ALL_DESELECTED";
    public static final String SOME_SELECTED_PROP = "SOME_SELECTED";
    protected static final ResourceBundle bundle = ResourceBundle.getBundle(EhcacheResourceBundle.class.getName());

    protected AbstractViewPage(ManageChannel channel, CacheManagerModel cacheManagerModel) {
        super((LayoutManager)new BorderLayout());
        this.channel = channel;
        this.cacheManagerModel = cacheManagerModel;
        this.treeModel = new SelectionModelTreeModel();
        this.tree = new XTree((TreeModel)((Object)this.treeModel));
        XScrollPane scroller = new XScrollPane((Component)this.tree);
        scroller.setPreferredSize(new Dimension(325, 275));
        this.add((Component)scroller);
        this.tree.setSelectionModel(null);
        this.tree.setCellRenderer((TreeCellRenderer)new CheckBoxNodeRenderer());
        this.tree.setCellEditor((TreeCellEditor)new CheckBoxNodeEditor((JTree)this.tree));
        this.tree.setEditable(true);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = AbstractViewPage.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = AbstractViewPage.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 1) {
                    AbstractViewPage.this.tree.startEditingAtPath(selPath);
                    DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                    Object userObject = aNode.getUserObject();
                    if (userObject instanceof SelectionModel) {
                        SelectionModel selectionModel = (SelectionModel)userObject;
                        AbstractViewPage.this.treeModel.valueForPathChanged(selPath, !selectionModel.isSelected());
                        AbstractViewPage.this.tree.stopEditing();
                    }
                }
            }
        });
    }

    public abstract void initialize();

    public abstract void selectAll(boolean var1);

    public abstract void apply(Boolean var1);

    public abstract void handleAllSelector();

    public abstract Map<CacheModelInstance, CacheModelInstanceControl> getSelection();

    public abstract void setSelection(Map<CacheModelInstance, CacheModelInstanceControl> var1);

    public boolean isAllSelected() {
        return this.isAllSelected;
    }

    public boolean isAllDeselected() {
        return this.isAllDeselected;
    }

    public boolean isSomeSelected() {
        return this.isSomeSelected;
    }

    protected void updateAllNodes() {
        this.treeModel.nodesChanged((TreeNode)this.treeModel.getRoot(), null);
    }

    @Override
    public void cacheManagerModelAdded(CacheManagerModel theCacheManagerModel) {
    }

    @Override
    public void cacheManagerModelRemoved(CacheManagerModel theCacheManagerModel) {
        if (theCacheManagerModel == this.cacheManagerModel) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractViewPage.this.setVisible(false);
                }
            });
        }
    }

    @Override
    public void instanceAdded(CacheManagerInstance instance) {
        instance.addCacheManagerInstanceListener(this);
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void instanceRemoved(CacheManagerInstance instance) {
        instance.removeCacheManagerInstanceListener(this);
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void cacheModelAdded(CacheModel cacheModel) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void cacheModelRemoved(CacheModel cacheModel) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void cacheModelChanged(CacheModel cacheModel) {
    }

    @Override
    public void cacheManagerInstanceChanged(CacheManagerInstance cacheManagerInstance) {
    }

    @Override
    public void cacheModelInstanceAdded(CacheModelInstance cacheModelInstance) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void cacheModelInstanceRemoved(CacheModelInstance cacheModelInstance) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void cacheModelInstanceChanged(CacheModelInstance cacheModelInstance) {
    }

    @Override
    public void clusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void clusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void clusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
    }

    @Override
    public void run() {
        this.initialize();
    }

    public void tearDown() {
        this.cacheManagerModel.removeCacheManagerModelListener(this);
        this.cacheManagerModel.getEhcacheModel().removeEhcacheModelListener(this);
        ((XRootNode)this.treeModel.getRoot()).tearDownChildren();
        super.tearDown();
    }

    protected abstract class CacheModelControl
    extends BaseSelectionModel {
        protected final CacheModel cacheModel;

        public CacheModelControl(CacheModel cacheModel) {
            super(cacheModel.getCacheName(), AbstractViewPage.this.channel.getValue(cacheModel));
            this.setEnabled(AbstractViewPage.this.channel.isEnabled(cacheModel));
            this.cacheModel = cacheModel;
        }

        public CacheModel getCacheModel() {
            return this.cacheModel;
        }

        public abstract void setSelectedAndChildren(boolean var1);
    }

    protected class CacheModelInstanceControl
    extends BaseSelectionModel {
        protected final CacheModelInstance cacheModelInstance;

        public CacheModelInstanceControl(CacheModelInstance cacheModelInstance) {
            super(cacheModelInstance.getCacheName(), AbstractViewPage.this.channel.getValue(cacheModelInstance));
            this.setIcon(cacheModelInstance.isTerracottaClustered() ? EhcachePresentationUtils.CLUSTERED_ICON : EhcachePresentationUtils.NON_CLUSTERED_ICON);
            this.setEnabled(AbstractViewPage.this.channel.isEnabled(cacheModelInstance));
            this.cacheModelInstance = cacheModelInstance;
        }

        public CacheModelInstanceControl(String moniker, CacheModelInstance cacheModelInstance) {
            this(cacheModelInstance);
            this.setText(moniker);
        }

        public CacheModelInstance getCacheModelInstance() {
            return this.cacheModelInstance;
        }
    }

    protected abstract class CacheManagerInstanceControl
    extends BaseSelectionModel {
        protected final CacheManagerInstance cacheManagerInstance;

        public CacheManagerInstanceControl(CacheManagerInstance cacheManagerInstance) {
            super(cacheManagerInstance.getClientName(), AbstractViewPage.this.channel.getValue(cacheManagerInstance));
            this.setEnabled(AbstractViewPage.this.channel.isEnabled(cacheManagerInstance));
            this.cacheManagerInstance = cacheManagerInstance;
        }

        public CacheManagerInstance getCacheManagerInstance() {
            return this.cacheManagerInstance;
        }

        public abstract void setSelectedAndChildren(boolean var1);
    }

    private abstract class BaseSelectionModel
    implements SelectionModel {
        private String text;
        private Icon icon;
        private boolean selected;
        private boolean enabled;
        private final EventListenerList eventListenerList;

        BaseSelectionModel(String text, boolean selected, boolean enabled) {
            this.text = text;
            this.selected = selected;
            this.enabled = enabled;
            this.eventListenerList = new EventListenerList();
        }

        BaseSelectionModel(String text, boolean selected) {
            this(text, selected, true);
        }

        public synchronized void setText(String text) {
            this.text = text;
        }

        public synchronized String getText() {
            return this.text;
        }

        public synchronized void setIcon(Icon icon) {
            this.icon = icon;
        }

        public synchronized Icon getIcon() {
            return this.icon;
        }

        public void setSelected(boolean selected) {
            if (this.isEnabled()) {
                this.setSelectedQuietly(selected);
                this.fireActionPerformed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelectedQuietly(boolean selected) {
            if (this.isEnabled()) {
                BaseSelectionModel baseSelectionModel = this;
                synchronized (baseSelectionModel) {
                    this.selected = selected;
                }
            }
        }

        public synchronized boolean isSelected() {
            return this.selected;
        }

        public synchronized void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public synchronized boolean isEnabled() {
            return this.enabled;
        }

        public void addActionListener(ActionListener l) {
            this.eventListenerList.add(ActionListener.class, l);
        }

        public void removeActionListener(ActionListener l) {
            this.eventListenerList.remove(ActionListener.class, l);
        }

        protected void fireActionPerformed() {
            Object[] listeners = this.eventListenerList.getListenerList();
            ActionEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                if (e == null) {
                    e = new ActionEvent(this, 1001, this.getText(), System.currentTimeMillis(), 0);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
        }
    }

    protected static class SelectionModelTreeModel
    extends XTreeModel {
        protected SelectionModelTreeModel() {
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = aNode.getUserObject();
            if (userObject instanceof SelectionModel) {
                ((SelectionModel)userObject).setSelected((Boolean)newValue);
            } else {
                aNode.setUserObject(newValue);
            }
            this.nodeChanged(aNode);
        }
    }
}

