/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.impl;

import com.tc.cluster.DsoCluster;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.DistributedCache;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.cache.evictor.Evictable;
import org.terracotta.cache.evictor.EvictionScheduler;
import org.terracotta.cache.evictor.EvictionStatistics;
import org.terracotta.cache.evictor.Evictor;
import org.terracotta.cache.evictor.TargetCapacityMapSizeListener;
import org.terracotta.cache.impl.EntrySet;
import org.terracotta.cache.impl.SystemTimeSource;
import org.terracotta.cache.impl.TimeSource;
import org.terracotta.cache.value.DefaultTimestampedValue;
import org.terracotta.collections.ConcurrentDistributedMap;
import org.terracotta.collections.FinegrainedLock;
import org.terracotta.collections.FinegrainedLockNoDso;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCache<K, V>
implements DistributedCache<K, V>,
Evictable<K> {
    private final CacheConfig config;
    protected final ConcurrentDistributedMap<K, TimestampedValue<V>> data;
    private final AtomicBoolean statisticsEnabled = new AtomicBoolean(false);
    private transient EvictionScheduler evictionScheduler;
    private final AtomicBoolean evictionThreadStarted = new AtomicBoolean(false);
    private transient TimeSource timeSource;
    private transient EvictionStatistics statistics = new EvictionStatistics();

    public LocalCache(CacheConfig config) {
        this.config = config;
        this.data = new ConcurrentDistributedMap();
        this.initializeOnLoad();
    }

    public void initializeOnLoad() {
        this.timeSource = new SystemTimeSource();
        this.evictionScheduler = new EvictionScheduler(this.config, new Evictor(this));
        this.statistics = new EvictionStatistics();
        this.data.registerMapSizeListener(new TargetCapacityMapSizeListener(this.data, this.getConfig()));
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkExpired(key, false);
        return this.data.containsKey(key);
    }

    private V getValueSafe(TimestampedValue<V> entry) {
        return entry == null ? null : (entry.isExpired(this.getTime(), this.config) ? null : entry.getValue());
    }

    @Override
    public V get(Object key) {
        return this.getValueSafe(this.getTimestampedValue(key));
    }

    @Override
    public TimestampedValue<V> getTimestampedValue(Object key) {
        this.checkExpired(key, true);
        return (TimestampedValue)this.data.get(key);
    }

    @Override
    public TimestampedValue<V> getTimestampedValueQuiet(Object key) {
        return this.getTimestampedValue(key);
    }

    @Override
    public TimestampedValue<V> removeTimestampedValue(K key) {
        return (TimestampedValue)this.data.remove(key);
    }

    private void checkExpired(Object key, boolean markUsed) {
        TimestampedValue entry = (TimestampedValue)this.data.get(key);
        if (null == entry) {
            return;
        }
        if (this.isEvictionEnabled()) {
            int now = this.getTime();
            if (entry.isExpired(now, this.config)) {
                this.removeNoReturn(key);
            } else if (markUsed) {
                entry.markUsed(now, "", this.config);
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return this.data.keySet();
    }

    private TimestampedValue<V> newEntry(V value) {
        if (value instanceof TimestampedValue) {
            return (TimestampedValue)value;
        }
        return new DefaultTimestampedValue<V>(value, this.getTime());
    }

    @Override
    public V put(K key, V value) {
        this.startEvictionIfNecessary();
        return this.getValueSafe((TimestampedValue)this.data.put(key, this.newEntry(value)));
    }

    private void startEvictionIfNecessary() {
        if (this.evictionThreadStarted.compareAndSet(false, true)) {
            this.evictionScheduler.start();
        }
    }

    @Override
    public V remove(Object key) {
        return this.getValueSafe((TimestampedValue)this.data.remove(key));
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public int localSize() {
        return this.data.localSize();
    }

    @Override
    public void shutdown() {
        this.evictionScheduler.stop();
    }

    @Override
    public void evictExpiredLocalElements() {
        if (this.isEvictionEnabled()) {
            this.invalidateCacheEntries();
        }
    }

    @Override
    public void evictOrphanElements(DsoCluster cluster) {
    }

    private void invalidateCacheEntries() {
        int totalCnt = 0;
        int evaled = 0;
        int notEvaled = 0;
        int errors = 0;
        Iterator entryIter = this.data.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIter.next();
            try {
                TimestampedValue tsEntry = (TimestampedValue)entry.getValue();
                if (tsEntry == null) continue;
                ++totalCnt;
                if (tsEntry.isExpired(this.getTime(), this.config)) {
                    ++evaled;
                    entryIter.remove();
                    continue;
                }
                ++notEvaled;
            }
            catch (Throwable t) {
                ++errors;
            }
        }
        if (this.isStatisticsEnabled()) {
            this.statistics.increment(totalCnt, evaled);
        }
    }

    public void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    private int getTime() {
        return this.timeSource.now();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this, this.data.entrySet());
    }

    @Override
    public void putNoReturn(K key, V value) {
        this.data.putNoReturn(key, this.newEntry(value));
    }

    @Override
    public void removeNoReturn(Object key) {
        this.data.removeNoReturn(key);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.getValueSafe((TimestampedValue)this.data.putIfAbsent(key, this.newEntry(value)));
    }

    @Override
    public V replace(K key, V value) {
        return this.getValueSafe((TimestampedValue)this.data.replace(key, this.newEntry(value)));
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsEnabled(boolean enabled) {
        EvictionStatistics evictionStatistics = this.statistics;
        synchronized (evictionStatistics) {
            if (enabled) {
                this.statistics.reset();
            } else {
                this.statistics.shutdown();
            }
            this.statisticsEnabled.set(enabled);
        }
    }

    @Override
    public EvictionStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public CacheConfig getConfig() {
        return this.config;
    }

    protected boolean isEvictionEnabled() {
        return this.config.getMaxTTISeconds() > 0 || this.config.getMaxTTLSeconds() > 0;
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public FinegrainedLock createFinegrainedLock(K key) {
        return new FinegrainedLockNoDso();
    }

    public void lockEntry(K key) {
    }

    public void unlockEntry(K key) {
    }

    @Override
    public String getLockIdForKey(K key) {
        return null;
    }
}

