/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.impl;

import com.tc.cluster.DsoCluster;
import com.tc.logging.TCLogger;
import com.tc.object.bytecode.ManagerUtil;
import com.tc.object.bytecode.NotClearable;
import com.tc.util.Assert;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.DistributedCache;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.cache.evictor.CapacityEvictionPolicyData;
import org.terracotta.cache.evictor.Evictable;
import org.terracotta.cache.evictor.EvictionScheduler;
import org.terracotta.cache.evictor.EvictionStatistics;
import org.terracotta.cache.evictor.Evictor;
import org.terracotta.cache.evictor.EvictorLock;
import org.terracotta.cache.evictor.OrphanEvictionListener;
import org.terracotta.cache.evictor.TargetCapacityMapSizeListener;
import org.terracotta.cache.impl.EntrySet;
import org.terracotta.cache.impl.SystemTimeSource;
import org.terracotta.cache.impl.TimeSource;
import org.terracotta.cache.value.DefaultTimestampedValue;
import org.terracotta.collections.ConcurrentDistributedMap;
import org.terracotta.collections.FinegrainedLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedCacheImpl<K, V>
implements DistributedCache<K, V>,
Evictable<K>,
NotClearable {
    private static final TCLogger logger = ManagerUtil.getLogger((String)DistributedCacheImpl.class.getName());
    private final CacheConfig config;
    protected final ConcurrentDistributedMap<K, TimestampedValue<V>> data;
    private final EvictorLock orphanEvictorLock;
    private boolean statisticsEnabled = false;
    private OrphanEvictionListener<K> orphanEvictor;
    private transient EvictionScheduler evictionScheduler;
    private transient TimeSource timeSource;
    private transient EvictionStatistics statistics;

    public DistributedCacheImpl(CacheConfig config) {
        this(config, new ConcurrentDistributedMap());
    }

    protected DistributedCacheImpl(CacheConfig config, ConcurrentDistributedMap<K, TimestampedValue<V>> concurrentDistributedMap) {
        this.config = config;
        this.data = concurrentDistributedMap;
        this.orphanEvictorLock = new EvictorLock();
        this.initializeOnLoad(false);
    }

    public void initializeOnLoad() {
        this.initializeOnLoad(true);
    }

    protected void initializeOnLoad(boolean startEviction) {
        if (this.config.isLoggingEnabled()) {
            logger.info((Object)"Initializing CHMDistributedMap, starting eviction thread");
        }
        this.timeSource = new SystemTimeSource();
        this.orphanEvictor = new OrphanEvictionListener(this.config, this, this.orphanEvictorLock);
        this.evictionScheduler = new EvictionScheduler(this.config, new Evictor(this, this.orphanEvictor));
        this.statistics = new EvictionStatistics();
        this.data.registerMapSizeListener(new TargetCapacityMapSizeListener(this.data, this.getConfig()));
        if (startEviction) {
            this.startEviction();
        }
    }

    private void startEviction() {
        this.evictionScheduler.start();
    }

    @Override
    public boolean containsKey(Object key) {
        TimestampedValue<V> entry = this.getNonExpiredEntryCoherent(key, false);
        return entry != null;
    }

    private TimestampedValue<V> getNonExpiredEntryCoherent(K key, boolean markUsed) {
        return this.getNonExpiredEntry(key, markUsed, true);
    }

    private TimestampedValue<V> getNonExpiredEntryUnlocked(K key, boolean markUsed) {
        return this.getNonExpiredEntry(key, markUsed, false);
    }

    private TimestampedValue<V> filterExpired(TimestampedValue<V> entry) {
        if (entry != null && entry.isExpired(this.getTime(), this.config)) {
            return null;
        }
        return entry;
    }

    private V getValueSafe(TimestampedValue<V> entry) {
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public V get(Object key) {
        return this.getValueSafe(this.getNonExpiredEntryCoherent(key, true));
    }

    @Override
    public TimestampedValue<V> getTimestampedValue(K key) {
        return this.getNonExpiredEntryCoherent(key, true);
    }

    @Override
    public TimestampedValue<V> getTimestampedValueQuiet(K key) {
        return this.getNonExpiredEntryCoherent(key, false);
    }

    @Override
    public TimestampedValue<V> removeTimestampedValue(K key) {
        return this.filterExpired((TimestampedValue)this.data.remove(key));
    }

    private TimestampedValue<V> getNonExpiredEntry(K key, boolean markUsed, boolean coherent) {
        TimestampedValue entry = coherent ? (TimestampedValue)this.data.get(key) : (TimestampedValue)this.data.unlockedGet(key);
        if (null == entry) {
            return null;
        }
        if (this.isEvictionEnabled() || this.isCapacityEvictionEnabled()) {
            int now = this.getTime();
            String lockId = this.getLockIdForKey(key);
            if (entry.isExpired(now, this.config)) {
                if (!ManagerUtil.isLockHeldByCurrentThread((String)lockId, (int)1)) {
                    this.evict(key, entry, now);
                }
                return null;
            }
            if (markUsed) {
                entry.markUsed(now, lockId, this.config);
            }
        }
        return entry;
    }

    @Override
    public String getLockIdForKey(K key) {
        return this.data.getLockIdForKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.data.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.getValueSafe(this.filterExpired((TimestampedValue)this.data.put(key, this.wrapValue(value))));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.getValueSafe(this.filterExpired((TimestampedValue)this.data.putIfAbsent(key, this.wrapValue(value))));
    }

    @Override
    public V remove(Object key) {
        return this.getValueSafe(this.filterExpired((TimestampedValue)this.data.remove(key)));
    }

    @Override
    public V replace(K key, V value) {
        return this.getValueSafe(this.filterExpired((TimestampedValue)this.data.replace(key, this.wrapValue(value))));
    }

    private TimestampedValue<V> wrapValue(V value) {
        if (value instanceof TimestampedValue) {
            this.initCapacityEvictionPolicyFromConfig((TimestampedValue)value);
            return (TimestampedValue)value;
        }
        DefaultTimestampedValue<V> defaultTimestampedValue = new DefaultTimestampedValue<V>(value, this.getTime());
        this.initCapacityEvictionPolicyFromConfig(defaultTimestampedValue);
        return defaultTimestampedValue;
    }

    private void initCapacityEvictionPolicyFromConfig(TimestampedValue timestampedValue) {
        if (this.isCapacityEvictionEnabled()) {
            CapacityEvictionPolicyData current = timestampedValue.getCapacityEvictionPolicyData();
            if (!this.getConfig().getCapacityEvictionPolicyDataFactory().isProductOfFactory(current)) {
                CapacityEvictionPolicyData cep = this.getConfig().getCapacityEvictionPolicyDataFactory().newCapacityEvictionPolicyData();
                timestampedValue.setCapacityEvictionPolicyData(cep);
            }
        }
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public int localSize() {
        return this.data.localSize();
    }

    @Override
    public void shutdown() {
        this.evictionScheduler.stop();
    }

    @Override
    public void evictExpiredLocalElements() {
        if (this.isEvictionEnabled()) {
            Collection localEntries = this.data.getAllLocalEntriesSnapshot();
            this.invalidateCacheEntries(new EntrySnapshotIterator(localEntries));
        }
    }

    @Override
    public void evictOrphanElements(DsoCluster clusterInfo) {
        if (this.isEvictionEnabled() && this.getConfig().isOrphanEvictionEnabled()) {
            for (Map m : this.data.getConstituentMaps()) {
                Set keys = clusterInfo.getKeysForOrphanedValues(m);
                this.invalidateCacheEntries(keys.iterator());
            }
        }
    }

    protected void invalidateCacheEntries(Iterator<K> keys) {
        int examined = 0;
        int evicted = 0;
        while (keys.hasNext()) {
            K key = keys.next();
            try {
                TimestampedValue wrappedValue = (TimestampedValue)this.data.get(key);
                if (wrappedValue == null) continue;
                ++examined;
                int now = this.getTime();
                if (!wrappedValue.isExpired(now, this.config)) continue;
                ++evicted;
                this.evict(key, wrappedValue, now);
            }
            catch (Throwable t) {
                logger.error((Object)("Unhandled exception inspecting item for [" + key + "] for expiration"), t);
            }
        }
        if (this.isStatisticsEnabled()) {
            this.statistics.increment(examined, evicted);
        }
    }

    private void evict(K key, TimestampedValue<V> entry, int now) {
        Assert.pre((key != null ? 1 : 0) != 0);
        if (this.data.remove(key, entry)) {
            this.onEvict(key, entry.getValue());
            this.logEviction(key, entry, now);
        }
    }

    private void logEviction(K key, TimestampedValue<V> entry, int now) {
        if (this.config.isLoggingEnabled()) {
            logger.info((Object)(ManagerUtil.getClientID() + " expiring key: " + key + " (expiresAt = " + entry.expiresAt(this.config) + ", now = " + now + ")"));
        }
    }

    protected void onEvict(K key, V value) {
    }

    public void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    private int getTime() {
        return this.timeSource.now();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this, this.data.entrySet());
    }

    @Override
    public void putNoReturn(K key, V value) {
        this.data.putNoReturn(key, this.wrapValue(value));
    }

    public void unlockedPutNoReturn(K key, V value) {
        this.data.unlockedPutNoReturn(key, this.wrapValue(value));
    }

    public V unlockedGet(K key) {
        return this.getValueSafe(this.getNonExpiredEntryUnlocked(key, true));
    }

    public TimestampedValue<V> unlockedGetTimestampedValue(K key) {
        return this.getNonExpiredEntryUnlocked(key, true);
    }

    public TimestampedValue unlockedGetTimestampedValueQuite(K key) {
        return this.getNonExpiredEntryUnlocked(key, false);
    }

    public boolean unlockedContainsKey(Object key) {
        TimestampedValue<V> entry = this.getNonExpiredEntryUnlocked(key, false);
        return entry != null;
    }

    @Override
    public void removeNoReturn(Object key) {
        this.data.removeNoReturn(key);
    }

    public void unlockedRemoveNoReturn(Object key) {
        this.data.unlockedRemoveNoReturn(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStatisticsEnabled() {
        DistributedCacheImpl distributedCacheImpl = this;
        synchronized (distributedCacheImpl) {
            return this.statisticsEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsEnabled(boolean enabled) {
        DistributedCacheImpl distributedCacheImpl = this;
        synchronized (distributedCacheImpl) {
            if (this.statistics != null) {
                if (enabled) {
                    this.statistics.reset();
                } else {
                    this.statistics.shutdown();
                }
                this.statisticsEnabled = enabled;
            }
        }
    }

    @Override
    public EvictionStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public CacheConfig getConfig() {
        return this.config;
    }

    protected boolean isEvictionEnabled() {
        return this.config.getMaxTTISeconds() > 0 || this.config.getMaxTTLSeconds() > 0;
    }

    protected boolean isCapacityEvictionEnabled() {
        return this.config.getTargetMaxInMemoryCount() > 0 || this.config.getTargetMaxTotalCount() > 0;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.data.remove(key, this.wrapValue(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.data.replace(key, this.wrapValue(oldValue), this.wrapValue(newValue));
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public FinegrainedLock createFinegrainedLock(K key) {
        return this.data.createFinegrainedLock(key);
    }

    public void lockEntry(K key) {
        this.data.lockEntry(key);
    }

    public void unlockEntry(K key) {
        this.data.unlockEntry(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntrySnapshotIterator<K>
    implements Iterator<K> {
        private final Iterator<Map.Entry<K, ?>> localEntryIter;

        EntrySnapshotIterator(Collection<Map.Entry<K, ?>> localEntries) {
            this.localEntryIter = localEntries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.localEntryIter.hasNext();
        }

        @Override
        public K next() {
            Map.Entry<K, ?> nextEntry = this.localEntryIter.next();
            return nextEntry.getKey();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

