/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.evictor;

import com.tc.cluster.DsoCluster;
import com.tc.injection.annotations.InjectedDsoInstance;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.cache.evictor.CapacityEvictionPolicyData;
import org.terracotta.cache.evictor.ConcurrentHashSet;
import org.terracotta.collections.ConcurrentDistributedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetCapacityEvictor {
    private static final Logger LOGGER = Logger.getLogger(TargetCapacityEvictor.class.getName());
    private static final int SAMPLE_SIZE = 12;
    private static final int RETAINED_SIZE = 2;
    private static final int LOW_ORPHAN_COUNT = 100;
    private static final int LOW_ORPHAN_COUNT_WAIT = 10000;
    private static final long TRY_REMOVE_TIMEOUT = 200L;
    private static final int EVICTION_ATTEMPT_RATIO = 10;
    private static final Random RNDM = new Random();
    private static final Set ORPHAN_LOOKUP_IN_PROGRESS = Collections.emptySet();
    @InjectedDsoInstance
    private DsoCluster clusterInfo;
    private final ConcurrentDistributedMap map;
    private final Comparator<DetachedEntry> capacityEvictionComparator;
    private final AtomicReference<Set> orphanKeys = new AtomicReference(new ConcurrentHashSet());
    private final ThreadLocal<Set<DetachedEntry>> localSamples = new ThreadLocal<Set<DetachedEntry>>(){

        @Override
        protected Set<DetachedEntry> initialValue() {
            return new HashSet<DetachedEntry>(12);
        }
    };

    public TargetCapacityEvictor(ConcurrentDistributedMap map) {
        this.map = map;
        this.capacityEvictionComparator = new CapacityEvictionPolicyComparator();
    }

    public void evictLocalElements(int maxEvict) {
        Set<DetachedEntry> sample = this.localSamples.get();
        int attempts = maxEvict * 10;
        int evicted = 0;
        for (int j = 0; evicted < maxEvict && j < maxEvict * 10; ++j) {
            if (!this.evictLocalElement(sample, false)) continue;
            ++evicted;
        }
        if (evicted < maxEvict) {
            LOGGER.log(Level.WARNING, "Attempted to evict {0} local elements: aborted after {1} attempts - evicted {2}", new Object[]{maxEvict, attempts, evicted});
        }
    }

    public void evictOrphanElements(int maxEvict) {
        int attempts = maxEvict * 10;
        int evicted = 0;
        for (int j = 0; evicted < maxEvict && j < attempts * 10; ++j) {
            if (!this.evictOrphanElement()) continue;
            ++evicted;
        }
        if (evicted < maxEvict) {
            LOGGER.log(Level.WARNING, "Attempted to evict {0} orphan elements: aborted after {1} attempts - evicted {2}", new Object[]{maxEvict, attempts, evicted});
        }
    }

    private boolean evictLocalElement(Set<DetachedEntry> sample, boolean remove) {
        Map.Entry e;
        for (int i = 0; i < 120 && sample.size() < Math.min(12, this.map.localSize()) && (e = this.map.getRandomLocalEntry()) != null; ++i) {
            sample.add(new DetachedEntry(e));
        }
        if (sample.isEmpty()) {
            return false;
        }
        DetachedEntry[] entries = sample.toArray(new DetachedEntry[sample.size()]);
        Arrays.sort(entries, this.capacityEvictionComparator);
        DetachedEntry evictee = entries[0];
        boolean success = remove ? this.map.tryRemove(evictee.getKey(), 200L, TimeUnit.MILLISECONDS) : this.map.flush(evictee.getKey(), evictee.getValue());
        sample.clear();
        for (int i = 1; i < entries.length && i < 3; ++i) {
            sample.add(entries[i]);
        }
        return success;
    }

    private boolean evictOrphanElement() {
        boolean success = false;
        Set orphans = this.orphanKeys.get();
        if (orphans.isEmpty()) {
            success = this.evictLocalElement(this.localSamples.get(), true);
            if (!success) {
                success = this.map.tryRemove(this.map.getRandomEntry().getKey(), 200L, TimeUnit.SECONDS);
            }
            if (orphans != ORPHAN_LOOKUP_IN_PROGRESS && this.orphanKeys.compareAndSet(orphans, ORPHAN_LOOKUP_IN_PROGRESS)) {
                new Thread(new Runnable(){

                    public void run() {
                        List maps = TargetCapacityEvictor.this.map.getConstituentMaps();
                        ConcurrentHashSet newOrphansSet = new ConcurrentHashSet();
                        IdentityHashMap<Map, Boolean> usedMaps = new IdentityHashMap<Map, Boolean>();
                        while ((double)usedMaps.size() <= 0.1 * (double)maps.size()) {
                            Map m = (Map)maps.get(RNDM.nextInt(maps.size()));
                            if (usedMaps.put(m, Boolean.TRUE) != null) continue;
                            newOrphansSet.addAll(TargetCapacityEvictor.this.clusterInfo.getKeysForOrphanedValues(m));
                        }
                        if (newOrphansSet.size() < 100) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        TargetCapacityEvictor.this.orphanKeys.set(newOrphansSet);
                    }
                }).start();
            }
        } else {
            try {
                Iterator it = orphans.iterator();
                success = this.map.tryRemove(it.next(), 200L, TimeUnit.MILLISECONDS);
                it.remove();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return success;
    }

    private static class DetachedEntry {
        private final Object key;
        private final Object value;

        public DetachedEntry(Map.Entry original) {
            this.key = original.getKey();
            this.value = original.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DetachedEntry) {
                return this.getKey().equals(((DetachedEntry)o).getKey());
            }
            return false;
        }

        public int hashCode() {
            Object k = this.getKey();
            return k == null ? 0 : k.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CapacityEvictionPolicyComparator
    implements Comparator<DetachedEntry> {
        CapacityEvictionPolicyComparator() {
        }

        @Override
        public int compare(DetachedEntry o1, DetachedEntry o2) {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1 instanceof TimestampedValue && v2 instanceof TimestampedValue) {
                CapacityEvictionPolicyData d1 = ((TimestampedValue)v1).getCapacityEvictionPolicyData();
                CapacityEvictionPolicyData d2 = ((TimestampedValue)v2).getCapacityEvictionPolicyData();
                if (d1 == null) {
                    if (d2 == null) {
                        return 0;
                    }
                    return -1;
                }
                return d1.compareTo(d2);
            }
            return 0;
        }
    }
}

