/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.evictor;

import java.util.concurrent.atomic.AtomicInteger;
import org.terracotta.cache.evictor.CapacityEvictionPolicyData;

public class LFUCapacityEvictionPolicyData
implements CapacityEvictionPolicyData {
    private final AtomicInteger usedCount = new AtomicInteger();

    public void markUsed(int usedAtTime) {
        this.usedCount.incrementAndGet();
    }

    public int compareTo(CapacityEvictionPolicyData other) {
        if (other == null) {
            return 1;
        }
        if (!(other instanceof LFUCapacityEvictionPolicyData)) {
            return 0;
        }
        LFUCapacityEvictionPolicyData o = (LFUCapacityEvictionPolicyData)other;
        return this.usedCount.get() - o.usedCount.get();
    }

    public String toString() {
        return "LFUCapacityEvictionPolicyData {usedCount = " + this.usedCount.get() + "}";
    }

    public static class Factory
    implements CapacityEvictionPolicyData.Factory {
        public CapacityEvictionPolicyData newCapacityEvictionPolicyData() {
            return new LFUCapacityEvictionPolicyData();
        }

        public boolean isProductOfFactory(CapacityEvictionPolicyData capacityEvictionPolicyData) {
            return capacityEvictionPolicyData instanceof LFUCapacityEvictionPolicyData;
        }
    }
}

