/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.evictor;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.terracotta.cache.CacheConfigFactory;
import org.terracotta.cache.evictor.EvictionStatisticsSampled;
import org.terracotta.cache.evictor.EvictionStatisticsSampledDSO;
import org.terracotta.cache.evictor.EvictionStatisticsSampledNoDSO;

public class EvictionStatistics {
    private long examined = 0L;
    private long evicted = 0L;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final EvictionStatisticsSampled sampled = CacheConfigFactory.DSO_ACTIVE ? new EvictionStatisticsSampledDSO() : new EvictionStatisticsSampledNoDSO();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.writeLock.lock();
        try {
            this.examined = 0L;
            this.evicted = 0L;
            this.shutdown();
            this.sampled.reset();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.writeLock.lock();
        try {
            this.sampled.shutdown();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(long additionalExamined, long additionalEvicted) {
        this.sampled.increment(additionalExamined, additionalEvicted);
        this.writeLock.lock();
        try {
            this.examined += additionalExamined;
            this.evicted += additionalEvicted;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExamined() {
        this.readLock.lock();
        try {
            long l = this.examined;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getExaminedMostRecentSample() {
        return this.sampled.getExaminedMostRecentSample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEvicted() {
        this.readLock.lock();
        try {
            long l = this.evicted;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getEvictedMostRecentSample() {
        return this.sampled.getEvictedMostRecentSample();
    }
}

