/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.cache.value;

/**
 * Wraps a value in the map-evictor and adds an expiration timestamp for entries. Tracks timestamp information on when
 * the idle and TTL timers for a CacheData value will expire. The TTL timer (timeToDie) cannot be reset, but may not be
 * active. The idle timer is reset each time the item is used.
 */
public class DefaultTimestampedValue<V> extends AbstractTimestampedValue<V> {

  private final V   value;

  /**
   * Time at which this item was created, combined with TTL from config defines the max time this item can live final
   * field, items have only one createTime time is seconds since the epoch (System.currentTimeMillis() / 1000 for
   * example)
   */
  private final int createTime;

  public DefaultTimestampedValue(final V value, final int createTime) {
    this.value = value;
    this.createTime = createTime;
    this.setLastAccessedTimeInternal(createTime);
  }

  @Override
  public final V getValue() {
    return this.value;
  }

  @Override
  public int getCreateTime() {
    return this.createTime;
  }
}