/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright notice. All
 * rights reserved.
 */
package org.terracotta.cache.serialization;

import com.tc.object.ClientObjectManager;
import com.tc.object.TCObject;
import com.tc.object.TraversedReferences;
import com.tc.object.applicator.BaseApplicator;
import com.tc.object.bytecode.TransparentAccess;
import com.tc.object.dna.api.DNA;
import com.tc.object.dna.api.DNACursor;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.api.DNAWriter;
import com.tc.object.dna.api.PhysicalAction;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SerializedEntryApplicator extends BaseApplicator {

  public static final String  SERIALIZED_ENTRY           = "org.terracotta.cache.serialization.SerializedEntry";
  public static final String  ABSTRACT_TIMESTAMPED_VALUE = "org.terracotta.cache.value.AbstractTimestampedValue";

  private static final String VALUE_FIELD                = SERIALIZED_ENTRY + ".value";
  private static final String CREATE_TIME_FIELD          = SERIALIZED_ENTRY + ".createTime";
  private static final String LAST_ACCESS_TIME_FIELD     = ABSTRACT_TIMESTAMPED_VALUE + ".lastAccessedTime";

  public SerializedEntryApplicator(final DNAEncoding encoding) {
    super(encoding);
  }

  public void dehydrate(final ClientObjectManager objMgr, final TCObject tco, final DNAWriter writer, final Object pojo) {
    Map<String, Object> values = getAllFields(pojo);

    writer.addEntireArray(get(values, VALUE_FIELD));
    writer.addPhysicalAction(CREATE_TIME_FIELD, get(values, CREATE_TIME_FIELD));
    writer.addPhysicalAction(LAST_ACCESS_TIME_FIELD, get(values, LAST_ACCESS_TIME_FIELD));
  }

  protected static Object get(final Map<String, Object> values, final String field) {
    Object value = values.get(field);
    if (value == null) { throw new AssertionError("null value for field " + field); }
    return value;
  }

  public Object getNewInstance(final ClientObjectManager objMgr, final DNA dna) {
    throw new UnsupportedOperationException();
  }

  public TraversedReferences getPortableObjects(final Object pojo, final TraversedReferences addTo) {
    return addTo;
  }

  Map<String, Object> getAllFields(final Object pojo) {
    TransparentAccess ta = (TransparentAccess) pojo;
    Map<String, Object> values = new HashMap<String, Object>();
    ta.__tc_getallfields(values);
    return values;
  }

  public void hydrate(final ClientObjectManager objMgr, final TCObject tco, final DNA dna, final Object pojo) throws IOException,
      ClassNotFoundException {
    DNACursor cursor = dna.getCursor();

    while (cursor.next(encoding)) {
      PhysicalAction a = cursor.getPhysicalAction();
      if (a.isEntireArray()) {
        tco.setValue(VALUE_FIELD, a.getObject());
      } else {
        tco.setValue(a.getFieldName(), a.getObject());
      }
    }
  }
}
