/*
 * All content copyright (c) 2003-2009 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.cache.impl;


/**
 * A {@link TimeSource} that uses System.currentTimeMillis().
 */
public class SystemTimeSource implements TimeSource {

  /**
   * @return Current time from system clock
   */
  public int now() {
    return (int) (System.currentTimeMillis() / 1000);
  }

}
