/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.cache.evictor;

/**
 * @author abhi.sanoujam
 */
public class NullCapacityEvictionPolicyData implements CapacityEvictionPolicyData {

  public static class NullCapacityEvictionPolicyDataFactory implements CapacityEvictionPolicyData.Factory {

    public boolean isProductOfFactory(CapacityEvictionPolicyData capacityEvictionPolicyData) {
      return (capacityEvictionPolicyData instanceof NullCapacityEvictionPolicyData);
    }

    public CapacityEvictionPolicyData newCapacityEvictionPolicyData() {
      return NullCapacityEvictionPolicyData.SINGLE_INSTANCE;
    }

  }

  public static NullCapacityEvictionPolicyData SINGLE_INSTANCE = new NullCapacityEvictionPolicyData();

  public void markUsed(int usedAtTime) {
    // no-op
  }

  public int compareTo(CapacityEvictionPolicyData o) {
    // always return 1, other policy data gets evicted when compared
    return 1;
  }

  @Override
  public String toString() {
    return "NullCapacityEvictionPolicyData{}";
  }

}
