/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.cache.evictor;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author abhi.sanoujam
 */
public class LFUCapacityEvictionPolicyData implements CapacityEvictionPolicyData {

  public static class Factory implements CapacityEvictionPolicyData.Factory {
    public CapacityEvictionPolicyData newCapacityEvictionPolicyData() {
      return new LFUCapacityEvictionPolicyData();
    }

    public boolean isProductOfFactory(CapacityEvictionPolicyData capacityEvictionPolicyData) {
      return (capacityEvictionPolicyData instanceof LFUCapacityEvictionPolicyData);
    }
  }

  private final AtomicInteger usedCount = new AtomicInteger();

  public void markUsed(int usedAtTime) {
    usedCount.incrementAndGet();
  }

  public int compareTo(CapacityEvictionPolicyData other) {
    if (other == null) {
      return 1;
    } else {
      if (!(other instanceof LFUCapacityEvictionPolicyData)) return 0;
      LFUCapacityEvictionPolicyData o = (LFUCapacityEvictionPolicyData) other;
      return (usedCount.get() - o.usedCount.get());
    }
  }

  @Override
  public String toString() {
    return "LFUCapacityEvictionPolicyData {usedCount = " + usedCount.get() + "}";
  }

}
