/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.cache.evictor;

import org.terracotta.cache.CacheConfigFactory;

import com.tc.object.bytecode.Manager;
import com.tc.object.bytecode.ManagerUtil;

public class EvictorLock {

  private boolean        locked;
  private Thread         owner;

  public boolean tryLock() {
    if (CacheConfigFactory.DSO_ACTIVE) { return ManagerUtil.tryMonitorEnter(this, Manager.LOCK_TYPE_WRITE); }

    synchronized (this) {
      if (locked) return false;

      locked = true;
      owner = Thread.currentThread();
      return true;
    }
  }

  public void unlock() {
    if (CacheConfigFactory.DSO_ACTIVE) {
      ManagerUtil.monitorExit(this, Manager.LOCK_TYPE_WRITE);
      return;
    }

    synchronized (this) {
      if (!locked) { throw new IllegalStateException("not locked"); }
      if (Thread.currentThread() != owner) { throw new IllegalStateException("not owning thread"); }
      locked = false;
      owner = null;
    }
  }

  public boolean isLocked() {
    if (CacheConfigFactory.DSO_ACTIVE) { return ManagerUtil.isLocked(this, Manager.LOCK_TYPE_WRITE); }

    synchronized (this) {
      return locked;
    }
  }

  public boolean isHeldByCurrentThread() {
    if (CacheConfigFactory.DSO_ACTIVE) { return ManagerUtil.isHeldByCurrentThread(this, Manager.LOCK_TYPE_WRITE); }

    synchronized (this) {
      return locked && owner == Thread.currentThread();
    }
  }
}
