/*
 * All content copyright (c) 2003-2009 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.cache.evictor;

/**
 * Methods are callbacks fired during the eviction thread lifecycle.
 */
public interface EvictionListener {

  /**
   * This is called before every local eviction cycle.
   */
  void startLocalEviction();

  /**
   * This is called after each local eviction.
   */
  void endLocalEviction();

  /**
   * Hook for eviction thread shutdown
   */
  void onShutdown();

}
