/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.collections.chm;

import com.tc.object.ObjectID;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.terracotta.collections.chm.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableConcurrentHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private final Random rndm = new Random();

    public SelectableConcurrentHashMap() {
    }

    public SelectableConcurrentHashMap(int initialCapacity, float loadFactor, int concurrency) {
        super(initialCapacity, loadFactor, concurrency);
    }

    public Map.Entry<K, V> getRandomEntry() {
        int segmentIndex;
        int i = segmentIndex = this.rndm.nextInt(this.segments.length);
        do {
            int tableIndex;
            ConcurrentHashMap.Segment seg = this.segments[i];
            ConcurrentHashMap.HashEntry<K, V>[] table = seg.table;
            int j = tableIndex = this.rndm.nextInt(table.length);
            do {
                ConcurrentHashMap.HashEntry e;
                if ((e = table[j]) != null && e.next == null) {
                    if (e.value == null) continue;
                    return new MapEntry(e);
                }
                if (e == null) continue;
                ArrayList list = new ArrayList();
                while (e != null) {
                    if (e.value != null) {
                        list.add(e);
                    }
                    e = e.next;
                }
                if (list.isEmpty()) continue;
                return new MapEntry((ConcurrentHashMap.HashEntry)list.get(this.rndm.nextInt(list.size())));
            } while ((j = j + 1 & table.length - 1) != tableIndex);
        } while ((i = i + 1 & this.segmentMask) != segmentIndex);
        return null;
    }

    public Map.Entry<K, V> getRandomLocalEntry() {
        int segmentIndex;
        int i = segmentIndex = this.rndm.nextInt(this.segments.length);
        do {
            int tableIndex;
            ConcurrentHashMap.Segment seg = this.segments[i];
            ConcurrentHashMap.HashEntry<K, V>[] table = seg.table;
            int j = tableIndex = this.rndm.nextInt(table.length);
            do {
                ConcurrentHashMap.HashEntry e;
                if ((e = table[j]) != null && e.next == null) {
                    if (e.value == null || e.value instanceof ObjectID) continue;
                    return new MapEntry(e);
                }
                if (e == null) continue;
                ArrayList list = new ArrayList();
                while (e != null) {
                    if (e.value != null && !(e.value instanceof ObjectID)) {
                        list.add(e);
                    }
                    e = e.next;
                }
                if (list.isEmpty()) continue;
                return new MapEntry((ConcurrentHashMap.HashEntry)list.get(this.rndm.nextInt(list.size())));
            } while ((j = (j + 1) % table.length) != tableIndex);
        } while ((i = i + 1 & this.segmentMask) != segmentIndex);
        return null;
    }

    public boolean replaceUsingReferenceEquality(K key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replaceUsingReferenceEquality(key, hash, oldValue, newValue);
    }

    public ConcurrentHashMap.HashEntry<K, V> removeReturnHashEntry(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null);
    }

    public ConcurrentHashMap.HashEntry<K, V> removeReturnHashEntry(Object key, Object value) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, value);
    }

    public ConcurrentHashMap.HashEntry<K, V> replaceReturnHashEntry(K key, V oldValue, V newValue) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    public ConcurrentHashMap.HashEntry<K, V> putReturnHashEntry(K key, V newValue) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, newValue, false);
    }

    public ConcurrentHashMap.HashEntry<K, V> replaceReturnHashEntry(K key, V newValue) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, newValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private final ConcurrentHashMap.HashEntry<K, V> entry;

        public MapEntry(ConcurrentHashMap.HashEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.entry.key;
        }

        @Override
        public V getValue() {
            return this.entry.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K key = this.getKey();
            return MapEntry.eq(key, e.getKey()) && MapEntry.eq(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

