/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.terracotta.collections.ConcurrentDistributedMap;
import org.terracotta.collections.LockStrategy;
import org.terracotta.collections.LockType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentDistributedSet<E>
implements Set<E> {
    private static final Object PRESENT = Boolean.TRUE;
    private final ConcurrentDistributedMap<E, Object> map;

    public ConcurrentDistributedSet() {
        this.map = new ConcurrentDistributedMap();
    }

    public ConcurrentDistributedSet(LockType lockType, LockStrategy<? super E> lockStrategy) {
        this.map = new ConcurrentDistributedMap(lockType, lockStrategy);
    }

    public ConcurrentDistributedSet(LockType lockType, LockStrategy<? super E> lockStrategy, int concurrency) {
        this.map = new ConcurrentDistributedMap(lockType, lockStrategy, concurrency);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean rv = false;
        for (E e : c) {
            rv |= this.add(e);
        }
        return rv;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean rv = false;
        if (this.size() > c.size()) {
            for (Object o : c) {
                rv |= this.remove(o);
            }
        } else {
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                if (!c.contains(iter.next())) continue;
                iter.remove();
                rv = true;
            }
        }
        return rv;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean rv = false;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            rv = true;
        }
        return rv;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }
}

