/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.collections;

import com.tc.object.bytecode.ManagerUtil;
import com.tc.object.locks.LockLevel;

public class NullLockStrategy<K> extends BasicLockStrategy<K> {

  public String generateLockIdForKey(String instanceQualifier, K key) {
    return null;
  }

  @Override
  public void beginLock(String lockID, int type) {
    if (!LockLevel.fromInt(type).isRead()) {
      ManagerUtil.checkWriteAccess(this);
    }
  }

  @Override
  public void commitLock(String lockID, int type) {
    //
  }

  @Override
  public void unpinLock(String lockID) {
    //
  }

  @Override
  public void pinLock(String lockID) {
    //
  }

  @Override
  public boolean tryBeginLock(String lockID, int type, long nanos) {
    ManagerUtil.checkWriteAccess(this);
    return true;
  }
}
