/*
 * All content copyright (c) 2003-2008 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.collections;

import com.tc.object.bytecode.Manager;

/**
 * Enum that contains the selectable lock types that are supported by Terracotta DSO for the internal implementation of
 * concurrent collections.
 *
 * @author Geert Bevin
 */
public enum LockType {
  /**
   * Asynchronously flush changes to the Terracotta Server Array.
   */
  WRITE(Manager.LOCK_TYPE_WRITE),

  /**
   * Synchronously flush changes to the Terracotta Server Array, blocking the calling method until data has been
   * acknowledged as being committed.
   */
  SYNCHRONOUS_WRITE(Manager.LOCK_TYPE_SYNCHRONOUS_WRITE),

  /**
   * Read locks going up to the Terracotta Server Array.
   */
  READ(Manager.LOCK_TYPE_READ),

  /**
   * Dirty writes and dirty reads that only gives transaction boundaries and no exclusion. Use at your own risk.
   */
  CONCURRENT(Manager.LOCK_TYPE_CONCURRENT);

  private final int dsoLockType;

  private LockType(final int dsoLockType) {
    this.dsoLockType = dsoLockType;
  }

  int getDsoLockType() {
    return dsoLockType;
  }
}