/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.collections;

import com.tc.object.bytecode.ManagerUtil;

import java.util.concurrent.TimeUnit;

public class FinegrainedLockDso implements FinegrainedLock, Comparable<FinegrainedLockDso> {

  private final transient String lockId;
  private final transient int defaultLockType;

  FinegrainedLockDso(final String lockId, final int defaultLockType) {
    this.lockId = lockId;
    this.defaultLockType = defaultLockType;
  }

  public void lock() {
    ManagerUtil.beginLock(lockId, defaultLockType);
  }

  public void lock(final LockType lockType) {
    ManagerUtil.beginLock(lockId, lockType.getDsoLockType());
  }

  public boolean tryLock() {
    return ManagerUtil.tryBeginLock(lockId, defaultLockType);
  }

  public boolean tryLock(final LockType lockType) {
    return ManagerUtil.tryBeginLock(lockId, lockType.getDsoLockType());
  }

  public boolean tryLock(final long timeout, final TimeUnit unit) throws InterruptedException {
    return ManagerUtil.tryBeginLock(lockId, defaultLockType, unit.toNanos(timeout));
  }

  public boolean tryLock(final LockType lockType, final long timeout, final TimeUnit unit) throws InterruptedException {
    return ManagerUtil.tryBeginLock(lockId, lockType.getDsoLockType(), unit.toNanos(timeout));
  }

  public void unlock() {
    ManagerUtil.commitLock(lockId, defaultLockType);
  }

  public void unlock(final LockType lockType) {
    ManagerUtil.commitLock(lockId, lockType.getDsoLockType());
  }

  public boolean isHeldByCurrentThread() {
    return ManagerUtil.isLockHeldByCurrentThread(lockId, defaultLockType);
  }

  public boolean isHeldByCurrentThread(final LockType lockType) {
    return ManagerUtil.isLockHeldByCurrentThread(lockId, lockType.getDsoLockType());
  }

  public int compareTo(final FinegrainedLockDso o) {
    return lockId.compareTo(o.lockId);
  }
}