/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.collections;

import java.util.ArrayList;
import java.util.List;

import com.tc.asm.ClassAdapter;
import com.tc.asm.ClassVisitor;
import com.tc.object.bytecode.ByteCodeUtil;
import com.tc.object.bytecode.ClassAdapterFactory;
import com.tc.object.bytecode.NotClearable;
import com.tc.object.bytecode.TCMap;

public class ConcurrentDistributedMapAdapter extends ClassAdapter implements ClassAdapterFactory {

  public ConcurrentDistributedMapAdapter(ClassVisitor cv) {
    super(cv);
  }

  public ConcurrentDistributedMapAdapter() {
    super(null);
  }

  public ClassAdapter create(ClassVisitor visitor, ClassLoader loader) {
    return new ConcurrentDistributedMapAdapter(visitor);
  }

  @Override
  public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
    List<String> toAdd = new ArrayList<String>();
    toAdd.add(TCMap.class.getName().replace('.', '/'));
    toAdd.add(NotClearable.class.getName().replace('.', '/'));

    interfaces = ByteCodeUtil.addInterfaces(interfaces, toAdd.toArray(new String[toAdd.size()]));

    super.visit(version, access, name, signature, superName, interfaces);
  }

}
