/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright notice. All
 * rights reserved.
 */
package org.terracotta.collections;

import com.tc.object.bytecode.ManagerUtil;

public abstract class BasicLockStrategy<K> implements LockStrategy<K> {

  public void beginLock(String lockID, int type) {
    ManagerUtil.beginLock(lockID, type);
  }

  public void pinLock(String lockID) {
    ManagerUtil.pinLock(lockID);
  }

  public void unpinLock(String lockID) {
    ManagerUtil.unpinLock(lockID);
  }

  public void commitLock(String lockID, int type) {
    ManagerUtil.commitLock(lockID, type);
  }

  public boolean tryBeginLock(String lockID, int type, long nanos) throws InterruptedException {
    return ManagerUtil.tryBeginLock(lockID, type, nanos);
  }

}
