/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.terracotta.collections.ConcurrentDistributedMapBackend;
import org.terracotta.collections.MapSizeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConcurrentDistributedMapNoDso<K, V>
extends ConcurrentHashMap<K, V>
implements ConcurrentDistributedMapBackend<K, V> {
    private final Random rndm = new Random();
    private MapSizeListener mapSizeListener = null;

    ConcurrentDistributedMapNoDso() {
    }

    @Override
    public int localSize() {
        return this.size();
    }

    @Override
    public void removeNoReturn(K key) {
        this.remove(key);
    }

    @Override
    public V remove(Object key) {
        Object val = super.remove(key);
        if (val != null) {
            this.sizeDecrement();
        }
        return val;
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (null == value) {
            throw new NullPointerException();
        }
        boolean removed = super.remove(key, value);
        if (removed) {
            this.sizeDecrement();
        }
        return removed;
    }

    @Override
    public Collection<Map.Entry<K, V>> getAllEntriesSnapshot() {
        return new ArrayList(this.entrySet());
    }

    @Override
    public Collection<Map.Entry<K, V>> getAllLocalEntriesSnapshot() {
        return new ArrayList(this.entrySet());
    }

    @Override
    public void putNoReturn(K key, V value) {
        this.put(key, value);
    }

    @Override
    public V put(K key, V value) {
        V val = super.put(key, value);
        if (val == null) {
            this.sizeIncrement();
        }
        return val;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V val = super.putIfAbsent(key, value);
        if (val == null) {
            this.sizeIncrement();
        }
        return val;
    }

    @Override
    public void lockEntry(K key) {
    }

    @Override
    public void unlockEntry(K key) {
    }

    @Override
    public V unsafeGet(K key) {
        return this.get(key);
    }

    @Override
    public String getLockIdForKey(K key) {
        return "";
    }

    @Override
    public List<Map<K, ?>> getConstituentMaps() {
        return Collections.singletonList(this);
    }

    @Override
    public Map.Entry<K, V> getRandomEntry() {
        int index = this.rndm.nextInt(this.size());
        Iterator it = this.entrySet().iterator();
        Map.Entry entry = null;
        do {
            entry = it.next();
        } while (it.hasNext() && index-- > 0);
        return entry;
    }

    @Override
    public Map.Entry<K, V> getRandomLocalEntry() {
        return this.getRandomEntry();
    }

    @Override
    public boolean flush(Object key, Object value) {
        boolean success = this.remove(key, value);
        if (success) {
            this.sizeDecrement();
        }
        return success;
    }

    @Override
    public boolean tryRemove(Object key, long time, TimeUnit unit) {
        return this.remove(key) != null;
    }

    private void sizeIncrement() {
        MapSizeListener l = this.mapSizeListener;
        if (l != null) {
            l.sizeChanged(1);
            l.localSizeChanged(1);
        }
    }

    private void sizeDecrement() {
        MapSizeListener l = this.mapSizeListener;
        if (l != null) {
            l.sizeChanged(-1);
            l.localSizeChanged(-1);
        }
    }

    @Override
    public MapSizeListener registerMapSizeListener(MapSizeListener newListener) {
        MapSizeListener old = this.mapSizeListener;
        this.mapSizeListener = newListener;
        return old;
    }
}

