/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.collections;

import com.tc.exception.TCObjectNotFoundException;
import com.tc.logging.TCLogger;
import com.tc.object.ObjectID;
import com.tc.object.TCObject;
import com.tc.object.bytecode.AAFairDistributionPolicyMarker;
import com.tc.object.bytecode.Clearable;
import com.tc.object.bytecode.Manageable;
import com.tc.object.bytecode.ManagerUtil;
import com.tc.object.bytecode.NullManager;
import com.tc.object.bytecode.TCMap;
import com.tc.util.Assert;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.terracotta.collections.ConcurrentDistributedMapBackend;
import org.terracotta.collections.LockStrategy;
import org.terracotta.collections.LockType;
import org.terracotta.collections.MapSizeListener;
import org.terracotta.repackaged.org.cliffc.high_scale_lib.NonBlockingHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConcurrentDistributedMapDso<K, V>
extends AbstractMap<K, V>
implements ConcurrentDistributedMapBackend<K, V>,
TCMap,
Manageable,
Clearable,
AAFairDistributionPolicyMarker {
    private static final TCLogger LOGGER = ManagerUtil.getLogger((String)ConcurrentDistributedMapDso.class.getName());
    private static final Object[] NO_ARGS = new Object[0];
    private volatile transient TCObject $__tc_MANAGED;
    private volatile boolean evictionEnabled = true;
    private final int dsoLockType;
    private final NonBlockingHashMap store;
    private final LockStrategy<? super K> lockStrategy;
    private volatile transient MapSizeListener listener;
    private transient AtomicInteger localSize;
    private volatile transient String instanceDsoLockName = null;

    ConcurrentDistributedMapDso(LockType lockType, LockStrategy<? super K> lockingStrategy) {
        this(lockType.getDsoLockType(), lockingStrategy);
    }

    public static <K, V> ConcurrentDistributedMapDso<K, V> newCDM(int lockLevel, Object strategy) {
        return new ConcurrentDistributedMapDso<K, V>(lockLevel, (LockStrategy)strategy);
    }

    private ConcurrentDistributedMapDso(int lockLevel, LockStrategy<? super K> lockStrategy) {
        Assert.pre((!(ManagerUtil.getManager() instanceof NullManager) ? 1 : 0) != 0);
        this.dsoLockType = lockLevel;
        this.store = new NonBlockingHashMap();
        this.lockStrategy = lockStrategy;
        this.localSize = new AtomicInteger(0);
        Assert.post((this.store != null ? 1 : 0) != 0);
    }

    private String getInstanceDsoLockName() {
        if (this.instanceDsoLockName != null) {
            return this.instanceDsoLockName;
        }
        this.instanceDsoLockName = "@CSM" + this.__tc_managed().getObjectID().toLong() + ":";
        return this.instanceDsoLockName;
    }

    private String generateLockIdForKey(K key) {
        if (null == key) {
            throw new NullPointerException();
        }
        return this.lockStrategy.generateLockIdForKey(this.getInstanceDsoLockName(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (this.__tc_isManaged()) {
            V old;
            if (null == value) {
                throw new NullPointerException();
            }
            String lockID = this.generateLockIdForKey(key);
            boolean sizeChanged = false;
            this.prefetch(key);
            ManagerUtil.beginLock((String)lockID, (int)this.dsoLockType);
            try {
                ConcurrentDistributedMapDso.pinLock(lockID);
                old = this.store.put(key, value);
                if (old != value) {
                    ManagerUtil.logicalInvoke((Object)this, (String)"put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key, value});
                    if (old == null) {
                        this.localSizeIncrement();
                        sizeChanged = true;
                    } else if (old instanceof ObjectID) {
                        this.localSizeIncrement();
                    }
                }
                old = this.lookup(old);
            }
            finally {
                ManagerUtil.commitLock((String)lockID);
            }
            if (sizeChanged) {
                this.sizeIncrement();
            }
            return old;
        }
        V old = this.store.put(key, value);
        if (old == null) {
            this.localSizeIncrement();
            this.sizeIncrement();
        }
        return old;
    }

    @Override
    public V unsafeGet(K key) {
        Object obj = this.store.get(key);
        if (obj instanceof ObjectID) {
            return null;
        }
        return (V)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        if (this.__tc_isManaged()) {
            Object val = this.prefetch(key);
            if (val == null && this.lockStrategy.allowNonCoherentReadsForNonExistentMapping()) {
                return null;
            }
            if (!(val instanceof ObjectID) && this.lockStrategy.allowNonCoherentReadsForLocalEntries()) {
                return (V)val;
            }
            String lockID = this.generateLockIdForKey(key);
            ManagerUtil.beginLock((String)lockID, (int)1);
            try {
                V result = this.lookupAndFaultIn(key, this.store.get(key));
                if (result != null) {
                    ConcurrentDistributedMapDso.pinLock(lockID);
                }
                V v = result;
                return v;
            }
            finally {
                ManagerUtil.commitLock((String)lockID);
            }
        }
        return (V)this.store.get(key);
    }

    private Object prefetch(Object key) {
        Object obj = this.store.get(key);
        if (obj instanceof ObjectID) {
            ManagerUtil.preFetchObject((ObjectID)((ObjectID)obj));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (this.__tc_isManaged()) {
            Object old;
            String lockID = this.generateLockIdForKey(key);
            boolean sizeChanged = false;
            this.prefetch(key);
            ManagerUtil.beginLock((String)lockID, (int)this.dsoLockType);
            try {
                old = this.store.remove(key);
                if (old != null) {
                    ManagerUtil.logicalInvoke((Object)this, (String)"remove(Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key});
                    if (!(old instanceof ObjectID)) {
                        this.localSizeDecrement();
                    }
                    sizeChanged = true;
                }
                old = this.lookup(old);
            }
            finally {
                ManagerUtil.commitLock((String)lockID);
                ConcurrentDistributedMapDso.evictLock(lockID);
            }
            if (sizeChanged) {
                this.sizeDecrement();
            }
            return (V)old;
        }
        Object old = this.store.remove(key);
        if (old != null) {
            this.localSizeDecrement();
            this.sizeDecrement();
        }
        return (V)old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNoReturn(K key) {
        if (this.__tc_isManaged()) {
            String lockID = this.generateLockIdForKey(key);
            boolean sizeChanged = false;
            ManagerUtil.beginLock((String)lockID, (int)this.dsoLockType);
            try {
                Object old = this.store.remove(key);
                if (old != null) {
                    ManagerUtil.logicalInvoke((Object)this, (String)"remove(Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key});
                    if (!(old instanceof ObjectID)) {
                        this.localSizeDecrement();
                    }
                    sizeChanged = true;
                }
            }
            finally {
                ManagerUtil.commitLock((String)lockID);
                ConcurrentDistributedMapDso.evictLock(lockID);
            }
            if (sizeChanged) {
                this.sizeDecrement();
            }
        } else if (this.store.remove(key) != null) {
            this.localSizeDecrement();
            this.sizeDecrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putNoReturn(K key, V value) {
        if (this.__tc_isManaged()) {
            String lockID = this.generateLockIdForKey(key);
            boolean sizeChanged = false;
            ManagerUtil.beginLock((String)lockID, (int)this.dsoLockType);
            try {
                ConcurrentDistributedMapDso.pinLock(lockID);
                V old = this.store.put(key, value);
                if (old != value) {
                    ManagerUtil.logicalInvoke((Object)this, (String)"put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key, value});
                    if (old == null) {
                        this.localSizeIncrement();
                        sizeChanged = true;
                    } else if (old instanceof ObjectID) {
                        this.localSizeIncrement();
                    }
                }
            }
            finally {
                ManagerUtil.commitLock((String)lockID);
            }
            if (sizeChanged) {
                this.sizeIncrement();
            }
        } else if (this.store.put(key, value) == null) {
            this.localSizeIncrement();
            this.sizeIncrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.__tc_isManaged()) {
            String lockID = this.generateLockIdForKey(key);
            ManagerUtil.beginLock((String)lockID, (int)1);
            try {
                boolean bl = this.store.containsKey(key);
                return bl;
            }
            finally {
                ManagerUtil.commitLock((String)lockID);
            }
        }
        return this.store.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (this.__tc_isManaged()) {
            if (null == value) {
                throw new NullPointerException();
            }
            for (Map.Entry<K, V> entry : this.entrySet()) {
                String lockID = this.generateLockIdForKey(entry.getKey());
                ManagerUtil.beginLock((String)lockID, (int)1);
                try {
                    if (!value.equals(this.lookupAndFaultIn(entry.getKey(), entry.getValue()))) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    ManagerUtil.commitLock((String)lockID);
                }
            }
            return false;
        }
        return this.store.containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.__tc_isManaged()) {
            ManagerUtil.beginLock((String)this.getInstanceDsoLockName(), (int)1);
            try {
                int n = this.store.size();
                return n;
            }
            finally {
                ManagerUtil.commitLock((String)this.getInstanceDsoLockName());
            }
        }
        return this.store.size();
    }

    @Override
    public int localSize() {
        if (this.__tc_isManaged()) {
            return this.localSize.get();
        }
        return this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.__tc_isManaged()) {
            ManagerUtil.beginLock((String)this.getInstanceDsoLockName(), (int)this.dsoLockType);
            try {
                this.evictAllLocks();
                int size = this.store.size();
                this.store.clear();
                int local = this.localSize.getAndSet(0);
                if (this.listener != null) {
                    this.listener.localSizeChanged(-local);
                    this.listener.sizeChanged(-size);
                }
                ManagerUtil.logicalInvoke((Object)this, (String)"clear()V", (Object[])NO_ARGS);
            }
            finally {
                ManagerUtil.commitLock((String)this.getInstanceDsoLockName());
            }
        } else {
            int local = this.localSize.getAndSet(0);
            this.store.clear();
            int size = this.store.size();
            if (this.listener != null) {
                this.listener.localSizeChanged(-local);
                this.listener.sizeChanged(-size);
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return new KeySet(this.store.keySet());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this.store.entrySet());
    }

    private String generateLockIdForEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object key = entry.getKey();
        String lockID = this.generateLockIdForKey(key);
        return lockID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (this.__tc_isManaged()) {
            V old;
            if (null == value) {
                throw new NullPointerException();
            }
            String lockID = this.generateLockIdForKey(key);
            boolean sizeChanged = false;
            this.prefetch(key);
            ManagerUtil.beginLock((String)lockID, (int)this.dsoLockType);
            try {
                ConcurrentDistributedMapDso.pinLock(lockID);
                old = this.store.putIfAbsent(key, value);
                if (old == null) {
                    ManagerUtil.logicalInvoke((Object)this, (String)"put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key, value});
                    this.localSizeIncrement();
                    sizeChanged = true;
                }
                old = this.lookupAndFaultIn(key, old);
            }
            finally {
                ManagerUtil.commitLock((String)lockID);
            }
            if (sizeChanged) {
                this.sizeIncrement();
            }
            return old;
        }
        V old = this.store.putIfAbsent(key, value);
        if (old == null) {
            this.localSizeIncrement();
            this.sizeIncrement();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        if (this.__tc_isManaged()) {
            if (null == value) {
                throw new NullPointerException();
            }
            String lockID = this.generateLockIdForKey(key);
            boolean success = false;
            ManagerUtil.beginLock((String)lockID, (int)this.dsoLockType);
            try {
                this.fault(key);
                if (this.store.remove(key, value)) {
                    ManagerUtil.logicalInvoke((Object)this, (String)"remove(Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key});
                    this.localSizeDecrement();
                    success = true;
                } else {
                    success = false;
                }
            }
            finally {
                ManagerUtil.commitLock((String)lockID);
                if (success) {
                    ConcurrentDistributedMapDso.evictLock(lockID);
                }
            }
            if (success) {
                this.sizeDecrement();
            }
            return success;
        }
        if (this.store.remove(key, value)) {
            this.localSizeDecrement();
            this.sizeDecrement();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.__tc_isManaged()) {
            if (null == oldValue) {
                throw new NullPointerException();
            }
            if (null == newValue) {
                throw new NullPointerException();
            }
            String lockID = this.generateLockIdForKey(key);
            this.prefetch(key);
            ManagerUtil.beginLock((String)lockID, (int)this.dsoLockType);
            try {
                ConcurrentDistributedMapDso.pinLock(lockID);
                this.fault(key);
                if (this.store.replace(key, oldValue, newValue)) {
                    ManagerUtil.logicalInvoke((Object)this, (String)"put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key, newValue});
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                ManagerUtil.commitLock((String)lockID);
            }
        }
        return this.store.replace(key, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        if (this.__tc_isManaged()) {
            if (null == value) {
                throw new NullPointerException();
            }
            String lockID = this.generateLockIdForKey(key);
            this.prefetch(key);
            ManagerUtil.beginLock((String)lockID, (int)this.dsoLockType);
            try {
                V old = this.store.replace(key, value);
                if (old != null) {
                    ManagerUtil.logicalInvoke((Object)this, (String)"put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key, value});
                    if (old instanceof ObjectID) {
                        this.localSizeIncrement();
                    }
                }
                V v = this.lookup(old);
                return v;
            }
            finally {
                ManagerUtil.commitLock((String)lockID);
            }
        }
        return this.store.replace(key, value);
    }

    @Override
    public Collection<Map.Entry<K, V>> getAllEntriesSnapshot() {
        return Collections.unmodifiableCollection(this.store.entrySet());
    }

    @Override
    public Collection<Map.Entry<K, V>> getAllLocalEntriesSnapshot() {
        return new LocalEntriesCollection();
    }

    private void fault(Object key) {
        Object obj = this.store.get(key);
        if (obj instanceof ObjectID) {
            try {
                Object value = ManagerUtil.lookupObject((ObjectID)((ObjectID)obj));
                if (this.store.replace(key, obj, value)) {
                    this.localSizeIncrement();
                }
            }
            catch (TCObjectNotFoundException e) {
                LOGGER.info((Object)("Missing object caused by concurrent map-level and key-level operations\nRemoving local entry for this key [" + key + "] to restore L1-L2 correspondence."), (Throwable)e);
                this.store.remove(key, obj);
                ConcurrentDistributedMapDso.evictLock(this.generateLockIdForKey(key));
            }
        }
    }

    private V lookupAndFaultIn(Object key, Object obj) {
        if (obj instanceof ObjectID) {
            try {
                Object value = ManagerUtil.lookupObject((ObjectID)((ObjectID)obj));
                if (this.store.replace(key, obj, value)) {
                    this.localSizeIncrement();
                }
                return (V)value;
            }
            catch (TCObjectNotFoundException e) {
                LOGGER.info((Object)("Missing object caused by concurrent map-level and key-level operations\nRemoving local entry for this key [" + key + "] to restore L1-L2 correspondence."), (Throwable)e);
                this.store.remove(key, obj);
                ConcurrentDistributedMapDso.evictLock(this.generateLockIdForKey(key));
                return null;
            }
        }
        return (V)obj;
    }

    private V lookup(Object obj) {
        if (obj instanceof ObjectID) {
            try {
                return (V)ManagerUtil.lookupObject((ObjectID)((ObjectID)obj));
            }
            catch (TCObjectNotFoundException e) {
                LOGGER.info((Object)"Missing object caused by concurrent map-level and key-level operations\nReturning null as the only sensible result.  Caller should have removed the local mapping.", (Throwable)e);
                return null;
            }
        }
        return (V)obj;
    }

    public void __tc_applicator_clear() {
        this.store.clear();
    }

    public void __tc_applicator_put(Object key, Object value) {
        Object old = this.store.put(key, value);
        if (value instanceof ObjectID) {
            if (old != null && !(old instanceof ObjectID)) {
                this.localSizeDecrement();
            }
        } else if (old == null || old instanceof ObjectID) {
            this.localSizeIncrement();
        }
    }

    public void __tc_applicator_remove(Object key) {
        Object old = this.store.remove(key);
        if (old != null && !(old instanceof ObjectID)) {
            this.localSizeDecrement();
        }
    }

    public Collection __tc_getAllEntriesSnapshot() {
        return this.getAllEntriesSnapshot();
    }

    public Collection __tc_getAllLocalEntriesSnapshot() {
        return this.getAllLocalEntriesSnapshot();
    }

    public void __tc_put_logical(Object key, Object value) {
        this.putNoReturn(key, value);
    }

    public void __tc_remove_logical(Object key) {
        this.removeNoReturn(key);
    }

    public boolean __tc_isManaged() {
        return this.$__tc_MANAGED != null;
    }

    public TCObject __tc_managed() {
        return this.$__tc_MANAGED;
    }

    public void __tc_managed(TCObject tcObject) {
        this.$__tc_MANAGED = tcObject;
    }

    public int __tc_clearReferences(int toClear) {
        if (!this.__tc_isManaged()) {
            throw new AssertionError((Object)"clearReferences() called on Unmanaged Map");
        }
        int cleared = 0;
        for (Object key : this.store.keySet()) {
            ObjectID oid;
            TCObject tcObject;
            Object v = this.store.get(key);
            if (v instanceof ObjectID || (tcObject = ManagerUtil.lookupExistingOrNull(v)) == null || tcObject.recentlyAccessed() || !this.store.replace(key, v, oid = tcObject.getObjectID())) continue;
            this.localSizeDecrement();
            ConcurrentDistributedMapDso.evictLock(this.generateLockIdForKey(key));
            if (++cleared != toClear) continue;
            break;
        }
        return cleared;
    }

    public boolean isEvictionEnabled() {
        return this.evictionEnabled;
    }

    public void setEvictionEnabled(boolean flag) {
        this.evictionEnabled = flag;
    }

    private static void pinLock(String lock) {
        ManagerUtil.pinLock((String)lock);
    }

    private static void evictLock(String lock) {
        ManagerUtil.evictLock((String)lock);
    }

    private void evictAllLocks() {
        for (Object key : this.store.keySet()) {
            ConcurrentDistributedMapDso.evictLock(this.generateLockIdForKey(key));
        }
    }

    @Override
    public void lockEntry(K key) {
        if (this.__tc_isManaged()) {
            String lockId = this.generateLockIdForKey(key);
            ManagerUtil.beginLock((String)lockId, (int)this.dsoLockType);
            ConcurrentDistributedMapDso.pinLock(lockId);
        }
    }

    @Override
    public void unlockEntry(K key) {
        if (this.__tc_isManaged()) {
            String lockId = this.generateLockIdForKey(key);
            boolean validKey = this.containsKey(key);
            ManagerUtil.commitLock((String)lockId);
            if (!validKey) {
                ConcurrentDistributedMapDso.evictLock(lockId);
            }
        }
    }

    @Override
    public String getLockIdForKey(K key) {
        if (this.__tc_isManaged()) {
            return this.generateLockIdForKey(key);
        }
        return "";
    }

    @Override
    public List<Map<K, ?>> getConstituentMaps() {
        return Collections.singletonList(this);
    }

    @Override
    public Map.Entry<K, V> getRandomEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.store.getRandomEntry();
    }

    @Override
    public Map.Entry<K, V> getRandomLocalEntry() {
        if (this.localSize() == 0) {
            return null;
        }
        return this.store.getRandomEntryNotTyped(null, ObjectID.class);
    }

    @Override
    public boolean flush(Object key, Object value) {
        if (this.__tc_isManaged()) {
            if (value instanceof ObjectID) {
                return false;
            }
            TCObject tcObject = ManagerUtil.lookupExistingOrNull((Object)value);
            if (tcObject == null) {
                return false;
            }
            ObjectID oid = tcObject.getObjectID();
            boolean success = this.store.replace(key, value, oid);
            if (success) {
                this.localSizeDecrement();
                ConcurrentDistributedMapDso.evictLock(this.generateLockIdForKey(key));
            }
            return success;
        }
        return this.remove(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryRemove(Object key, long time, TimeUnit unit) {
        if (this.__tc_isManaged()) {
            String lockID = this.generateLockIdForKey(key);
            if (ManagerUtil.tryBeginLock((String)lockID, (int)this.dsoLockType, (long)unit.toNanos(time))) {
                boolean removed = false;
                try {
                    Object old = this.store.remove(key);
                    if (old != null) {
                        ManagerUtil.logicalInvoke((Object)this, (String)"remove(Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key});
                        if (!(old instanceof ObjectID)) {
                            this.localSizeDecrement();
                        }
                        removed = true;
                    }
                }
                finally {
                    ManagerUtil.commitLock((String)lockID);
                    ConcurrentDistributedMapDso.evictLock(lockID);
                }
                if (removed) {
                    this.sizeDecrement();
                }
                return removed;
            }
            return false;
        }
        if (this.store.remove(key) != null) {
            this.localSizeDecrement();
            this.sizeDecrement();
            return true;
        }
        return false;
    }

    private void localSizeIncrement() {
        this.localSize.incrementAndGet();
        MapSizeListener l = this.listener;
        if (l != null) {
            l.localSizeChanged(1);
        }
    }

    private void localSizeDecrement() {
        this.localSize.decrementAndGet();
        MapSizeListener l = this.listener;
        if (l != null) {
            l.localSizeChanged(-1);
        }
    }

    private void sizeIncrement() {
        MapSizeListener l = this.listener;
        if (l != null) {
            l.sizeChanged(1);
        }
    }

    private void sizeDecrement() {
        MapSizeListener l = this.listener;
        if (l != null) {
            l.sizeChanged(-1);
        }
    }

    @Override
    public MapSizeListener registerMapSizeListener(MapSizeListener newListener) {
        MapSizeListener old = this.listener;
        this.listener = newListener;
        return old;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalEntriesIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> delegate;
        private Map.Entry<K, V> next;

        public LocalEntriesIterator(Iterator<Map.Entry<K, V>> delegate) {
            this.delegate = delegate;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry<K, V> result = this.findNext();
            if (result == null) {
                throw new NoSuchElementException();
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Map.Entry<K, V> findNext() {
            Map.Entry<K, V> current = this.next;
            while (this.delegate.hasNext()) {
                Map.Entry<K, V> obj = this.delegate.next();
                if (obj.getValue() instanceof ObjectID) continue;
                this.next = obj;
                return current;
            }
            this.next = null;
            return current;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalEntriesCollection
    extends AbstractCollection<Map.Entry<K, V>> {
        private final Collection<Map.Entry<K, V>> delegate;

        private LocalEntriesCollection() {
            this.delegate = ConcurrentDistributedMapDso.this.store.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LocalEntriesIterator(this.delegate.iterator());
        }

        @Override
        public int size() {
            int size = 0;
            for (Object o : ConcurrentDistributedMapDso.this.store.values()) {
                if (o instanceof ObjectID) continue;
                ++size;
            }
            return size;
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TcmEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> delegate;

        private TcmEntry(Map.Entry<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public K getKey() {
            return this.delegate.getKey();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getValue() {
            if (ManagerUtil.isManaged((Object)ConcurrentDistributedMapDso.this)) {
                String lockId = ConcurrentDistributedMapDso.this.generateLockIdForKey(this.delegate.getKey());
                ConcurrentDistributedMapDso.this.prefetch(this.delegate.getKey());
                ManagerUtil.beginLock((String)lockId, (int)1);
                try {
                    Object object = ConcurrentDistributedMapDso.this.lookupAndFaultIn(this.delegate.getKey(), this.delegate.getValue());
                    return object;
                }
                finally {
                    ManagerUtil.commitLock((String)lockId);
                }
            }
            return this.delegate.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V setValue(V value) {
            if (ManagerUtil.isManaged((Object)ConcurrentDistributedMapDso.this)) {
                String lockId = ConcurrentDistributedMapDso.this.generateLockIdForKey(this.delegate.getKey());
                ConcurrentDistributedMapDso.this.prefetch(this.delegate.getKey());
                ManagerUtil.beginLock((String)lockId, (int)ConcurrentDistributedMapDso.this.dsoLockType);
                try {
                    ConcurrentDistributedMapDso.pinLock(lockId);
                    Object old = this.delegate.setValue(value);
                    if (old != value) {
                        ManagerUtil.logicalInvoke((Object)ConcurrentDistributedMapDso.this, (String)"put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{this.delegate.getKey(), value});
                        if (old instanceof ObjectID) {
                            ConcurrentDistributedMapDso.this.localSizeIncrement();
                        }
                    }
                    Object object = ConcurrentDistributedMapDso.this.lookup(old);
                    return object;
                }
                finally {
                    ManagerUtil.commitLock((String)lockId);
                }
            }
            return this.delegate.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> delegate;
        private Map.Entry<K, V> lastEntry;

        private EntryIterator(Iterator<Map.Entry<K, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public synchronized Map.Entry<K, V> next() {
            Map.Entry result = this.delegate.next();
            if (null == result) {
                this.lastEntry = null;
                return null;
            }
            this.lastEntry = new TcmEntry(result);
            return this.lastEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void remove() {
            if (null == this.lastEntry) {
                throw new IllegalStateException("next needs to be called before calling remove");
            }
            if (ManagerUtil.isManaged((Object)ConcurrentDistributedMapDso.this)) {
                String lockID = ConcurrentDistributedMapDso.this.generateLockIdForEntry(this.lastEntry);
                if (null == lockID) {
                    throw new IllegalStateException("can't obtain lockId for entry");
                }
                boolean success = false;
                ConcurrentDistributedMapDso.this.prefetch(this.lastEntry.getKey());
                ManagerUtil.beginLock((String)lockID, (int)ConcurrentDistributedMapDso.this.dsoLockType);
                try {
                    ConcurrentDistributedMapDso.this.fault(this.lastEntry.getKey());
                    if (ConcurrentDistributedMapDso.this.store.remove(this.lastEntry.getKey(), this.lastEntry.getValue())) {
                        ManagerUtil.logicalInvoke((Object)ConcurrentDistributedMapDso.this, (String)"remove(Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{this.lastEntry.getKey()});
                        ConcurrentDistributedMapDso.this.localSizeDecrement();
                        success = true;
                    }
                    this.delegate.remove();
                }
                finally {
                    ManagerUtil.commitLock((String)lockID);
                    if (success) {
                        ConcurrentDistributedMapDso.evictLock(lockID);
                    }
                }
                if (success) {
                    ConcurrentDistributedMapDso.this.sizeDecrement();
                }
            } else if (ConcurrentDistributedMapDso.this.store.remove(this.lastEntry.getKey(), this.lastEntry.getValue())) {
                this.delegate.remove();
                ConcurrentDistributedMapDso.this.localSizeDecrement();
                ConcurrentDistributedMapDso.this.sizeDecrement();
            }
            this.lastEntry = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, V>> delegate;

        private EntrySet(Set<Map.Entry<K, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.delegate.iterator());
        }

        @Override
        public int size() {
            return ConcurrentDistributedMapDso.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            if (ManagerUtil.isManaged((Object)ConcurrentDistributedMapDso.this)) {
                String lockID = ConcurrentDistributedMapDso.this.generateLockIdForEntry(o);
                if (null == lockID) {
                    return false;
                }
                ManagerUtil.beginLock((String)lockID, (int)1);
                try {
                    ConcurrentDistributedMapDso.this.fault(((Map.Entry)o).getKey());
                    boolean bl = this.delegate.contains(o);
                    return bl;
                }
                finally {
                    ManagerUtil.commitLock((String)lockID);
                }
            }
            return this.delegate.contains(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            if (ManagerUtil.isManaged((Object)ConcurrentDistributedMapDso.this)) {
                String lockID = ConcurrentDistributedMapDso.this.generateLockIdForEntry(o);
                if (null == lockID) {
                    return false;
                }
                boolean success = false;
                Map.Entry e = (Map.Entry)o;
                ConcurrentDistributedMapDso.this.prefetch(e.getKey());
                ManagerUtil.beginLock((String)lockID, (int)ConcurrentDistributedMapDso.this.dsoLockType);
                try {
                    ConcurrentDistributedMapDso.this.fault(e.getKey());
                    if (this.delegate.remove(o)) {
                        ManagerUtil.logicalInvoke((Object)ConcurrentDistributedMapDso.this, (String)"remove(Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{e.getKey()});
                        ConcurrentDistributedMapDso.this.localSizeDecrement();
                        success = true;
                    } else {
                        success = false;
                    }
                }
                finally {
                    ManagerUtil.commitLock((String)lockID);
                    if (success) {
                        ConcurrentDistributedMapDso.evictLock(lockID);
                    }
                }
                if (success) {
                    ConcurrentDistributedMapDso.this.sizeDecrement();
                }
                return success;
            }
            if (this.delegate.remove(o)) {
                ConcurrentDistributedMapDso.this.localSizeDecrement();
                ConcurrentDistributedMapDso.this.sizeDecrement();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            ConcurrentDistributedMapDso.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<K> {
        private final Iterator<K> delegate;
        private K lastKey;

        public KeyIterator(Iterator<K> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public K next() {
            Object result = this.delegate.next();
            this.lastKey = result;
            return result;
        }

        @Override
        public void remove() {
            if (null == this.lastKey) {
                throw new IllegalStateException("next needs to be called before calling remove");
            }
            if (ManagerUtil.isManaged((Object)ConcurrentDistributedMapDso.this)) {
                String lockID = ConcurrentDistributedMapDso.this.generateLockIdForKey(this.lastKey);
                if (null == lockID) {
                    throw new IllegalStateException("can't obtain lockId for entry");
                }
                ConcurrentDistributedMapDso.this.remove(this.lastKey);
            } else {
                this.delegate.remove();
            }
            this.lastKey = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private final Set<K> delegate;

        private KeySet(Set<K> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return ConcurrentDistributedMapDso.this.size();
        }

        @Override
        public boolean contains(Object key) {
            return ConcurrentDistributedMapDso.this.containsKey(key);
        }

        @Override
        public void clear() {
            ConcurrentDistributedMapDso.this.clear();
        }

        @Override
        public boolean remove(Object key) {
            return ConcurrentDistributedMapDso.this.remove(key) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(this.delegate.iterator());
        }
    }
}

