/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.terracotta.collections.ConcurrentDistributedMapBackend;
import org.terracotta.collections.ConcurrentDistributedMapDsoArray;
import org.terracotta.collections.ConcurrentDistributedMapDsoConfig;
import org.terracotta.collections.ConcurrentDistributedMapNoDso;
import org.terracotta.collections.HashcodeLockStrategy;
import org.terracotta.collections.LockStrategy;
import org.terracotta.collections.LockType;
import org.terracotta.collections.LockableMap;
import org.terracotta.collections.MapSizeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentDistributedMap<K, V>
implements ConcurrentMap<K, V>,
LockableMap<K> {
    private final ConcurrentDistributedMapBackend<K, V> map;

    public ConcurrentDistributedMap() {
        this(LockType.WRITE, new HashcodeLockStrategy());
    }

    public ConcurrentDistributedMap(LockType lockType, LockStrategy<? super K> lockStrategy) {
        if (null == lockType) {
            throw new IllegalArgumentException("lockType can't be null");
        }
        if (null == lockStrategy) {
            throw new IllegalArgumentException("lockStrategy can't be null");
        }
        this.map = this.isDsoActive() ? new ConcurrentDistributedMapDsoArray<K, V>(lockType, new ConcurrentDistributedMapDsoConfig(), lockStrategy) : new ConcurrentDistributedMapNoDso();
    }

    private boolean isDsoActive() {
        return Boolean.getBoolean("tc.active");
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public V replace(K key, V value) {
        return this.map.replace(key, value);
    }

    public void removeNoReturn(K key) {
        this.map.removeNoReturn(key);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public V unsafeGet(K key) {
        return this.map.unsafeGet(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    public void putNoReturn(K key, V value) {
        this.map.putNoReturn(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.map.putAll(t);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public int localSize() {
        return this.map.localSize();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    public Collection<Map.Entry<K, V>> getAllLocalEntriesSnapshot() {
        return this.map.getAllLocalEntriesSnapshot();
    }

    public Collection<Map.Entry<K, V>> getAllEntriesSnapshot() {
        return this.map.getAllEntriesSnapshot();
    }

    @Override
    public void lockEntry(K key) {
        this.map.lockEntry(key);
    }

    @Override
    public void unlockEntry(K key) {
        this.map.unlockEntry(key);
    }

    public String getLockIdForKey(K key) {
        return this.map.getLockIdForKey(key);
    }

    public void __tc_applicator_clear() {
        throw new AssertionError();
    }

    public void __tc_applicator_put(Object obj, Object obj1) {
        throw new AssertionError();
    }

    public void __tc_applicator_remove(Object obj) {
        throw new AssertionError();
    }

    public Collection __tc_getAllEntriesSnapshot() {
        return this.getAllEntriesSnapshot();
    }

    public Collection __tc_getAllLocalEntriesSnapshot() {
        if (this.map == null) {
            return Collections.emptyList();
        }
        return this.map.getAllLocalEntriesSnapshot();
    }

    public void __tc_put_logical(Object key, Object value) {
        this.putNoReturn(key, value);
    }

    public void __tc_remove_logical(Object key) {
        this.removeNoReturn(key);
    }

    public List<Map<K, ?>> getConstituentMaps() {
        return this.map.getConstituentMaps();
    }

    public Map.Entry<K, V> getRandomEntry() {
        return this.map.getRandomEntry();
    }

    public Map.Entry<K, V> getRandomLocalEntry() {
        return this.map.getRandomLocalEntry();
    }

    public boolean flush(Object key, Object value) {
        return this.map.flush(key, value);
    }

    public boolean tryRemove(Object key, long time, TimeUnit unit) {
        return this.map.tryRemove(key, time, unit);
    }

    public MapSizeListener registerMapSizeListener(MapSizeListener newListener) {
        return this.map.registerMapSizeListener(newListener);
    }
}

