/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.collections;

/**
 * Instances of LockableMap can have their individual entries independently locked and unlocked. This allows the
 * implementation of atomic operations with arbitrary contents.
 * 
 * @author Chris Dennis
 * @param <K> key type
 */
public interface LockableMap<K> {
  /**
   * Lock the entry corresponding to this key
   * 
   * @param key
   */
  public void lockEntry(K key);

  /**
   * Unlock the entry corresponding to this key
   * 
   * @param key
   */
  public void unlockEntry(K key);
}
