/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright notice. All
 * rights reserved.
 */
package org.terracotta.collections;

public interface LockStrategy<K> {

  /**
   * Generate the terracotta lock identifier used when performing operations for the given key.
   * 
   * @param instanceQualifier A unique identifier for the map being operated on. To avoid lock collisions with other
   *        maps, this identifier should be part of the return lockId
   * @param key
   * @return lock identifier
   */
  String generateLockIdForKey(String instanceQualifier, K key);

  /**
   * Allows the map to skip acquiring a lock to read mapping the don't exist in the local copy of the map.
   * 
   * @return false if lock should be acquired, true if otherwise
   */
  boolean allowNonCoherentReadsForNonExistentMapping();

  /**
   * Allows the map to skip acquiring a lock to read mapping that exist in the local copy of the map, both key and value
   * faulted in.
   * 
   * @return false if lock should be acquired, true if otherwise
   */
  public boolean allowNonCoherentReadsForLocalEntries();
}
