/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.collections;

import com.tc.object.bytecode.ManagerUtil;
import com.tc.properties.TCProperties;

public class ConcurrentDistributedMapDsoConfig {

  private static final int   DEFAULT_CONCURRENCY = 128;
  private final TCProperties csmProperties;
  private final int          concurrency;

  public ConcurrentDistributedMapDsoConfig() {
    csmProperties = ManagerUtil.getManager().getTCProperties().getPropertiesFor("csm");
    concurrency = csmProperties.getInt("concurrency", DEFAULT_CONCURRENCY);
  }

  public int getConcurrency() {
    return concurrency;
  }

}
