/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.collections;

import static org.terracotta.collections.ConcurrentDistributedMapDsoApplicator.CDM_DSO_APPLICATOR_CLASSNAME;
import static org.terracotta.collections.ConcurrentDistributedMapDsoApplicator.CDM_DSO_CLASSNAME;

import org.osgi.framework.BundleContext;
import org.terracotta.modules.configuration.TerracottaConfiguratorModule;

import com.tc.object.config.ChangeApplicatorSpec;
import com.tc.object.config.TransparencyClassSpec;

public final class ConcurrentCollectionsTerracottaConfigurator extends TerracottaConfiguratorModule {

  @Override
  protected final void addInstrumentation(final BundleContext context) {
    super.addInstrumentation(context);
    TransparencyClassSpec spec;
    spec = configHelper.getOrCreateSpec("org.terracotta.collections.ConcurrentDistributedMap");
    spec.addCustomClassAdapter(new ConcurrentDistributedMapAdapter());

    spec = configHelper.getOrCreateSpec("org.terracotta.collections.ConcurrentDistributedMapDsoArray");
    spec.setHonorTransient(true);
    spec.setCallMethodOnLoad("onLoad");
    
    configHelper.addIncludePattern("org.terracotta.collections.BasicLockStrategy");
    configHelper.addIncludePattern("org.terracotta.collections.HashcodeLockStrategy");
    configHelper.addIncludePattern("org.terracotta.collections.OneToOneLockStrategy");

    spec = configHelper.getOrCreateSpec(CDM_DSO_CLASSNAME, CDM_DSO_APPLICATOR_CLASSNAME);
    spec.setUseNonDefaultConstructor(true);
    spec.setCallConstructorOnLoad(true);
    spec.setChangeApplicatorSpec(new ChangeApplicatorSpec() {
      public Class getChangeApplicator(final Class target) {
        return ConcurrentDistributedMapDsoApplicator.class;
      }
    });

    spec = configHelper.getOrCreateSpec("org.terracotta.modules.concurrent.collections.ConcurrentStringMap");
  }
}
