/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.collections;

public abstract class BasicLockStrategy<K> implements LockStrategy<K> {
  private final boolean allowNonCoherentReadsForNonExistentMapping;
  private final boolean allowNonCoherentReadsForLocalEntries;

  BasicLockStrategy(boolean allowNonCoherentReadsForNonExistentMapping, boolean allowNonCoherentReadsForLocalEntries) {
    this.allowNonCoherentReadsForNonExistentMapping = allowNonCoherentReadsForNonExistentMapping;
    this.allowNonCoherentReadsForLocalEntries = allowNonCoherentReadsForLocalEntries;
  }

  public boolean allowNonCoherentReadsForNonExistentMapping() {
    return allowNonCoherentReadsForNonExistentMapping;
  }

  public boolean allowNonCoherentReadsForLocalEntries() {
    return allowNonCoherentReadsForLocalEntries;
  }

}
