/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.configuration;

import com.tc.bundles.BundleSpec;
import com.tc.object.bytecode.ByteCodeUtil;
import com.tc.object.config.LockDefinition;
import com.tc.object.config.StandardDSOClientConfigHelper;
import com.tc.object.config.TransparencyClassSpec;
import com.tc.util.Assert;
import java.net.MalformedURLException;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public abstract class TerracottaConfiguratorModule
implements BundleActivator {
    protected StandardDSOClientConfigHelper configHelper;
    private Bundle thisBundle;

    protected ServiceReference getConfigHelperReference(BundleContext context) throws Exception {
        String CONFIGHELPER_CLASS_NAME = "com.tc.object.config.StandardDSOClientConfigHelper";
        ServiceReference configHelperRef = context.getServiceReference("com.tc.object.config.StandardDSOClientConfigHelper");
        if (configHelperRef == null) {
            throw new BundleException("Expected the com.tc.object.config.StandardDSOClientConfigHelper service to be registered, was unable to find it");
        }
        return configHelperRef;
    }

    public final void start(BundleContext context) throws Exception {
        this.thisBundle = context.getBundle();
        ServiceReference configHelperRef = this.getConfigHelperReference(context);
        this.configHelper = (StandardDSOClientConfigHelper)context.getService(configHelperRef);
        Assert.assertNotNull((Object)this.configHelper);
        this.addInstrumentation(context);
        context.ungetService(configHelperRef);
        this.registerModuleSpec(context);
    }

    protected Bundle getThisBundle() {
        return this.thisBundle;
    }

    public void stop(BundleContext context) throws Exception {
    }

    protected void addInstrumentation(BundleContext context) {
    }

    protected void registerModuleSpec(BundleContext context) {
    }

    protected final String getBundleJarUrl(Bundle bundle) {
        return "jar:" + bundle.getLocation() + "!/";
    }

    protected final void addClassReplacement(Bundle bundle, String originalClassName, String replacementClassName) {
        String url = this.getBundleJarUrl(bundle) + ByteCodeUtil.classNameToFileName((String)replacementClassName);
        try {
            this.configHelper.addClassReplacement(originalClassName, replacementClassName, new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected error while constructing the URL '" + url + "'", e);
        }
    }

    protected final void addExportedBundleClass(Bundle bundle, String classname) {
        String url = this.getBundleJarUrl(bundle) + ByteCodeUtil.classNameToFileName((String)classname);
        try {
            this.configHelper.addClassResource(classname, new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected error while constructing the URL '" + url + "'", e);
        }
    }

    protected final void addExportedTcJarClass(String classname) {
        URL resource = TerracottaConfiguratorModule.class.getClassLoader().getResource(ByteCodeUtil.classNameToFileName((String)classname));
        if (resource == null) {
            throw new RuntimeException("Exported TC jar class " + classname + " does not exist.");
        }
        this.configHelper.addClassResource(classname, resource);
    }

    protected TransparencyClassSpec getOrCreateSpec(String expr, boolean markAsPreInstrumented) {
        TransparencyClassSpec spec = this.configHelper.getOrCreateSpec(expr);
        if (markAsPreInstrumented) {
            spec.markPreInstrumented();
        }
        return spec;
    }

    protected TransparencyClassSpec getOrCreateSpec(String expr) {
        return this.getOrCreateSpec(expr, true);
    }

    protected void addLock(String expr, LockDefinition ld) {
        this.configHelper.addLock(expr, ld);
    }

    protected Bundle getExportedBundle(BundleContext context, String targetBundleName) {
        Bundle[] bundles = context.getBundles();
        Bundle bundle = null;
        for (int i = 0; i < bundles.length; ++i) {
            if (!BundleSpec.isMatchingSymbolicName((String)targetBundleName, (String)bundles[i].getSymbolicName())) continue;
            bundle = bundles[i];
            break;
        }
        return bundle;
    }
}

