/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.configuration;

import com.tc.bundles.BundleSpec;
import com.tc.object.bytecode.ByteCodeUtil;
import com.tc.object.config.ClassReplacementTest;
import com.tc.object.config.LockDefinition;
import com.tc.object.config.StandardDSOClientConfigHelper;
import com.tc.object.config.TransparencyClassSpec;
import com.tc.util.Assert;
import java.net.MalformedURLException;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public abstract class TerracottaConfiguratorModule
implements BundleActivator {
    protected StandardDSOClientConfigHelper configHelper;
    private Bundle thisBundle;

    protected ServiceReference getConfigHelperReference(BundleContext context) throws Exception {
        String CONFIGHELPER_CLASS_NAME = "com.tc.object.config.StandardDSOClientConfigHelper";
        ServiceReference configHelperRef = context.getServiceReference("com.tc.object.config.StandardDSOClientConfigHelper");
        if (configHelperRef == null) {
            throw new BundleException("Expected the com.tc.object.config.StandardDSOClientConfigHelper service to be registered, was unable to find it");
        }
        return configHelperRef;
    }

    public final void start(BundleContext context) throws Exception {
        this.thisBundle = context.getBundle();
        ServiceReference configHelperRef = this.getConfigHelperReference(context);
        this.configHelper = (StandardDSOClientConfigHelper)context.getService(configHelperRef);
        Assert.assertNotNull((Object)this.configHelper);
        this.addInstrumentation(context);
        context.ungetService(configHelperRef);
        this.registerModuleSpec(context);
        if (!Boolean.getBoolean("tc.bootjar.creation")) {
            this.registerMBeanSpec(context);
            this.registerSRASpec(context);
        }
    }

    protected Bundle getThisBundle() {
        return this.thisBundle;
    }

    public void stop(BundleContext context) throws Exception {
    }

    protected void addInstrumentation(BundleContext context) {
    }

    protected void registerModuleSpec(BundleContext context) {
    }

    protected void registerMBeanSpec(BundleContext context) {
    }

    protected void registerSRASpec(BundleContext context) {
    }

    protected final String getBundleJarUrl(Bundle bundle) {
        String location = bundle.getLocation();
        boolean isJar = location.startsWith("file:") && location.endsWith(".jar");
        return (isJar ? "jar:" : "") + location + "!/";
    }

    protected final void addClassReplacement(Bundle bundle, String originalClassName, String replacementClassName) {
        this.addClassReplacement(bundle, originalClassName, replacementClassName, null);
    }

    protected final void addClassReplacement(Bundle bundle, String originalClassName, String replacementClassName, ClassReplacementTest test) {
        String url = this.getBundleJarUrl(bundle) + ByteCodeUtil.classNameToFileName((String)replacementClassName);
        try {
            this.configHelper.addClassReplacement(originalClassName, replacementClassName, new URL(url), test);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected error while constructing the URL '" + url + "'", e);
        }
    }

    protected final void addExportedBundleClass(Bundle bundle, String classname, boolean targetSystemLoaderOnly) {
        String url = this.getBundleJarUrl(bundle) + ByteCodeUtil.classNameToFileName((String)classname);
        try {
            this.configHelper.addClassResource(classname, new URL(url), targetSystemLoaderOnly);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected error while constructing the URL '" + url + "'", e);
        }
    }

    protected final void addExportedBundleClass(Bundle bundle, String classname) {
        this.addExportedBundleClass(bundle, classname, false);
    }

    protected final void addExportedTcJarClass(String classname) {
        URL resource = TerracottaConfiguratorModule.class.getClassLoader().getResource(ByteCodeUtil.classNameToFileName((String)classname));
        if (resource == null) {
            throw new RuntimeException("Exported TC jar class " + classname + " does not exist.");
        }
        this.configHelper.addClassResource(classname, resource, false);
    }

    protected TransparencyClassSpec getOrCreateSpec(String expr, boolean markAsPreInstrumented) {
        TransparencyClassSpec spec = this.configHelper.getOrCreateSpec(expr);
        if (markAsPreInstrumented) {
            spec.markPreInstrumented();
        }
        return spec;
    }

    protected TransparencyClassSpec getOrCreateSpec(String expr) {
        return this.getOrCreateSpec(expr, true);
    }

    protected void addLock(String expr, LockDefinition ld) {
        this.configHelper.addLock(expr, ld);
    }

    protected Bundle getExportedBundle(BundleContext context, String targetBundleName) {
        for (Bundle bundle : context.getBundles()) {
            if (!BundleSpec.isMatchingSymbolicName((String)targetBundleName, (String)bundle.getSymbolicName())) continue;
            return bundle;
        }
        return null;
    }
}

