/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="setl2classpath", requiresDependencyResolution=ResolutionScope.TEST)
public class SetL2ClasspathMojo
extends AbstractMojo {
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    private MavenProject project;
    @Parameter(required=true, readonly=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<Repository> remoteRepositories;
    @Component
    protected ProjectDependenciesResolver projectDependenciesResolver;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private ArtifactFactory defaultArtifactFactory;

    public void execute() throws MojoExecutionException {
        File terracottaJarFile = this.getTerracottaJar();
        if (terracottaJarFile == null) {
            throw new MojoExecutionException("Couldn't find Terracotta core artifact");
        }
        try {
            String l2Classppath = this.getTerracottaClassPath();
            this.getLog().debug((CharSequence)("Setting tc.tests.info.l2.classpath to: " + l2Classppath));
            this.project.getProperties().put("tc.tests.info.l2.classpath", l2Classppath);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error trying to find L2 classpath", e);
        }
    }

    private File getTerracottaJar() {
        Set artifacts = this.project.getDependencyArtifacts();
        for (Artifact a : artifacts) {
            if (!a.getArtifactId().equals("terracotta") && !a.getArtifactId().equals("terracotta-ee") || !a.getGroupId().equals("org.terracotta")) continue;
            return a.getFile();
        }
        return null;
    }

    private String getTerracottaClassPath() throws Exception {
        Set artifacts = this.project.getDependencyArtifacts();
        for (Artifact a : artifacts) {
            if (!a.getArtifactId().equals("terracotta") && !a.getArtifactId().equals("terracotta-ee") || !a.getGroupId().equals("org.terracotta")) continue;
            StringBuilder sb = new StringBuilder();
            MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(a, this.remoteRepositories, this.localRepository);
            DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph(pomProject, (ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            HashSet<DependencyNode> nodes = new HashSet<DependencyNode>();
            this.getAllNodes(rootNode, nodes);
            nodes.remove(rootNode);
            TreeSet<Artifact> terracottaDirectAndTransitiveDependencies = new TreeSet<Artifact>();
            for (DependencyNode node : nodes) {
                Artifact nodeArtifact = node.getArtifact();
                Artifact completeArtifact = this.defaultArtifactFactory.createArtifact(nodeArtifact.getGroupId(), nodeArtifact.getArtifactId(), nodeArtifact.getVersion(), nodeArtifact.getScope(), nodeArtifact.getType());
                completeArtifact.setFile(new File(this.localRepository.getBasedir(), this.localRepository.pathOf(completeArtifact)));
                terracottaDirectAndTransitiveDependencies.add(completeArtifact);
            }
            terracottaDirectAndTransitiveDependencies.add(a);
            int size = terracottaDirectAndTransitiveDependencies.size();
            int currentPosition = 0;
            for (Artifact artifact : terracottaDirectAndTransitiveDependencies) {
                if (artifact.getScope().equals("test")) continue;
                File file = artifact.getFile();
                sb.append(file.getCanonicalPath());
                if (currentPosition < size - 1) {
                    sb.append(File.pathSeparator);
                }
                ++currentPosition;
            }
            return sb.toString();
        }
        this.getLog().error((CharSequence)"No org.terracotta:terracotta(-ee) could be found among this project dependencies; hence no terracotta classpath will be generated!");
        return "";
    }

    private void getAllNodes(DependencyNode node, Set<DependencyNode> currentNodes) {
        currentNodes.add(node);
        for (DependencyNode currentNode : node.getChildren()) {
            this.getAllNodes(currentNode, currentNodes);
        }
    }
}

