/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseVerifyMojo
extends AbstractMojo {
    protected MavenProject project;
    private String excludeArtifactIds;

    public void execute() throws MojoExecutionException {
        if (this.project.getArtifact().isSnapshot()) {
            this.getLog().info((CharSequence)"Project is a SNAPSHOT, checking of SNAPSHOT dependencies is not required");
            return;
        }
        Set<Artifact> artifacts = this.filterExcludeArtifactIds(this.project.getArtifacts());
        for (Artifact a : artifacts) {
            this.getLog().info((CharSequence)("Testing artifact " + a));
            if (!a.isSnapshot()) continue;
            throw new MojoExecutionException("SNAPSHOT dependencies detected for a release project: " + a.toString());
        }
    }

    private Set<Artifact> filterExcludeArtifactIds(Set<Artifact> artifacts) {
        if (ReleaseVerifyMojo.isEmpty(this.excludeArtifactIds)) {
            return artifacts;
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        List<String> excludes = Arrays.asList(this.excludeArtifactIds.split("\\s*,\\s*"));
        for (Artifact a : artifacts) {
            if (!excludes.contains(a.getArtifactId())) {
                result.add(a);
                continue;
            }
            this.getLog().info((CharSequence)("Exclude " + a + " from scanning"));
        }
        return result;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

