/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.terracotta.forge.plugin.AbstractResolveDependenciesMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="copy-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE)
public class CopyArtifactDependenciesMojo
extends AbstractResolveDependenciesMojo {
    @Parameter(required=true)
    private File outputDir;
    @Parameter(required=false, defaultValue="false")
    private boolean removeVersion;

    public void execute() throws MojoExecutionException {
        try {
            Collection<Artifact> deps = this.resolve();
            this.copyDeps(deps);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void copyDeps(Collection<Artifact> deps) throws IOException {
        for (Artifact a : deps) {
            File destFile;
            String filename = a.getFile().getName();
            if (a.isSnapshot()) {
                filename = a.getArtifactId() + "-" + a.getBaseVersion() + "." + a.getType();
            }
            if (this.removeVersion) {
                filename = a.getArtifactId() + "." + a.getType();
            }
            if ((destFile = new File(this.outputDir, filename)).exists()) {
                FileUtils.deleteQuietly((File)destFile);
            }
            FileUtils.copyFile((File)a.getFile(), (File)destFile);
        }
    }
}

