/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.terracotta.forge.plugin.util.Util;

public class BuildInfoMojo
extends AbstractMojo {
    private static final String LAST_CHANGED_REV = "Last Changed Rev";
    private static final String URL = "URL";
    static final String UNKNOWN = "unknown";
    protected MavenProject project;
    private String rootPath;
    private String eeRootPath;
    private String osRootPath;
    private boolean generateBuildInfoFile;
    private String buildInfoLocation;
    private final Properties buildInfoProps = new Properties();

    public void execute() throws MojoExecutionException {
        String svnUrl = UNKNOWN;
        String revision = UNKNOWN;
        String eeSvnUrl = UNKNOWN;
        String eeRevision = UNKNOWN;
        String osSvnUrl = UNKNOWN;
        String osRevision = UNKNOWN;
        if (this.rootPath == null) {
            this.rootPath = this.project.getBasedir().getAbsolutePath();
        }
        if (this.eeRootPath != null && this.osRootPath != null) {
            throw new MojoExecutionException("eeRootPath and osRootPath are mutual exclusive. Both cannot be set.");
        }
        try {
            Properties svnInfo = Util.getSvnInfo(new File(this.rootPath).getCanonicalPath(), this.getLog());
            svnUrl = svnInfo.getProperty(URL, UNKNOWN);
            revision = svnInfo.getProperty(LAST_CHANGED_REV, UNKNOWN);
            if (this.eeRootPath != null) {
                Properties eeSvnInfo = Util.getSvnInfo(new File(this.eeRootPath).getCanonicalPath(), this.getLog());
                eeSvnUrl = eeSvnInfo.getProperty(URL, UNKNOWN);
                eeRevision = eeSvnInfo.getProperty(LAST_CHANGED_REV, UNKNOWN);
            }
            if (this.osRootPath != null) {
                Properties osSvnInfo = Util.getSvnInfo(new File(this.osRootPath).getCanonicalPath(), this.getLog());
                osSvnUrl = osSvnInfo.getProperty(URL, UNKNOWN);
                osRevision = osSvnInfo.getProperty(LAST_CHANGED_REV, UNKNOWN);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error reading svn info", (Exception)ioe);
        }
        String host = UNKNOWN;
        String user = System.getProperty("user.name", UNKNOWN);
        String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Exception while finding host name", (Throwable)e);
        }
        this.setBuildInfoProperty("build.user", user);
        this.setBuildInfoProperty("build.host", host);
        this.setBuildInfoProperty("build.hostname", host);
        this.setBuildInfoProperty("build.timestamp", timestamp);
        if (this.eeRootPath != null) {
            this.setBuildInfoProperty("build.ee.revision", eeRevision);
            this.setBuildInfoProperty("build.ee.svn.url", eeSvnUrl);
            this.setBuildInfoProperty("build.ee.branch", this.guessBranchOrTagFromUrl(eeSvnUrl));
            BuildInfoMojo.checkMatchingBranch(this.guessBranchOrTagFromUrl(svnUrl), this.guessBranchOrTagFromUrl(eeSvnUrl));
        }
        if (this.osRootPath != null) {
            this.setBuildInfoProperty("build.os.revision", osRevision);
            this.setBuildInfoProperty("build.os.svn.url", osSvnUrl);
            this.setBuildInfoProperty("build.os.branch", this.guessBranchOrTagFromUrl(osSvnUrl));
            BuildInfoMojo.checkMatchingBranch(this.guessBranchOrTagFromUrl(osSvnUrl), this.guessBranchOrTagFromUrl(svnUrl));
        }
        String fullRevision = revision;
        if (!UNKNOWN.equals(eeRevision)) {
            fullRevision = eeRevision + "-" + revision;
        }
        if (!UNKNOWN.equals(osRevision)) {
            fullRevision = revision + "-" + osRevision;
        }
        this.getLog().debug((CharSequence)("Setting build.revision to " + fullRevision));
        this.getLog().debug((CharSequence)("Setting build.svn.url to " + svnUrl));
        this.setBuildInfoProperty("build.revision", fullRevision);
        this.setBuildInfoProperty("build.svn.url", svnUrl);
        this.setBuildInfoProperty("build.branch", this.guessBranchOrTagFromUrl(svnUrl));
        if (this.generateBuildInfoFile) {
            this.generateBuildInfoFile();
        }
    }

    private String guessBranchOrTagFromUrl(String url) {
        if (url.contains("trunk")) {
            return "trunk";
        }
        int startIndex = url.indexOf("branches/");
        if (startIndex > 0) {
            int endIndex = url.indexOf("/", startIndex + 9);
            if (endIndex < 0) {
                endIndex = url.length();
            }
            return url.substring(startIndex + 9, endIndex);
        }
        startIndex = url.indexOf("tags/");
        if (startIndex > 0) {
            int endIndex = url.indexOf("/", startIndex + 5);
            if (endIndex < 0) {
                endIndex = url.length();
            }
            return url.substring(startIndex + 5, endIndex);
        }
        return UNKNOWN;
    }

    private void generateBuildInfoFile() throws MojoExecutionException {
        PrintWriter out = null;
        try {
            File buildInfoFile = new File(this.buildInfoLocation, "build-info.properties");
            buildInfoFile.getParentFile().mkdirs();
            out = new PrintWriter(buildInfoFile);
            this.buildInfoProps.list(out);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("IO Error:", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
    }

    private void setBuildInfoProperty(String key, String value) {
        this.buildInfoProps.setProperty(key, value);
        this.project.getProperties().setProperty(key, value);
    }

    static void checkMatchingBranch(String osBranch, String eeBranch) throws MojoExecutionException {
        String ee;
        if (UNKNOWN.equals(eeBranch)) {
            return;
        }
        String os = osBranch.replace("-core-ee", "");
        if (!os.equals(ee = eeBranch.replace("-core-ee", ""))) {
            throw new MojoExecutionException("branch doesn't match between EE (" + eeBranch + ") and OS (" + osBranch + "). Check your svn:externals property");
        }
    }
}

