/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;

public class Util {
    public static final String LOG_PREFIX = "maven-forge-plugin: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String exec(String command, List<String> params, File workDir, Log log) {
        String param222;
        File outputFile;
        try {
            outputFile = File.createTempFile("exec", ".out");
            outputFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Project dummyProject = new Project();
        dummyProject.init();
        ExecTask execTask = new ExecTask();
        execTask.setProject(dummyProject);
        execTask.setOutput(outputFile);
        execTask.setDir(workDir != null ? workDir : new File(System.getProperty("user.dir")));
        execTask.setExecutable(command);
        execTask.setResultProperty("svninfoexitcode");
        if (params != null) {
            for (String param222 : params) {
                execTask.createArg().setValue(param222);
            }
        }
        FileReader reader = null;
        try {
            execTask.execute();
            reader = new FileReader(outputFile);
            param222 = IOUtils.toString((Reader)reader);
        }
        catch (Exception e) {
            try {
                log.warn((CharSequence)("Unable to use svn info : " + e));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                outputFile.delete();
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
            outputFile.delete();
            return "";
        }
        IOUtils.closeQuietly((Reader)reader);
        outputFile.delete();
        return param222;
    }

    public static Properties getSvnInfo(String svnRepo, Log log) throws IOException {
        String svnCommand = "svn";
        String svnHome = System.getenv("SVN_HOME");
        if (svnHome != null) {
            svnCommand = svnHome + "/bin/svn";
        }
        if ((svnHome = System.getProperty("SVN_HOME")) != null) {
            svnCommand = svnHome + "/bin/svn";
        }
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win") && new File(svnCommand + ".bat").exists()) {
            svnCommand = svnCommand + ".bat";
        }
        String result = Util.exec(svnCommand, Arrays.asList("info", svnRepo), null, log);
        log.debug((CharSequence)("svn info " + svnRepo + ": " + result));
        return Util.parseSvnInfo(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getZipEntries(File file) throws IOException {
        StringBuilder buff = new StringBuilder();
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                buff.append(zipEntries.nextElement().getName()).append("\n");
            }
            String string = buff.toString();
            return string;
        }
    }

    public static Properties parseSvnInfo(String svnInfo) throws IOException {
        Properties props = new Properties();
        BufferedReader br = new BufferedReader(new StringReader(svnInfo));
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] tokens = line.split(":", 2);
            if (tokens.length != 2) continue;
            props.put(tokens[0].trim(), tokens[1].trim());
        }
        return props;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static void overrideToolchainConfiguration(Map<String, String> toolchainSpec, ToolchainManager manager, MavenSession session, Log logger, AbstractSurefireMojo pluginInstance) throws MojoExecutionException {
        if (toolchainSpec != null && toolchainSpec.size() > 0 && manager != null) {
            String javaHomeFromToolchain;
            String javaExecutableFromToolchain;
            Toolchain selectedToolchain;
            List toolchains = manager.getToolchains(session, "jdk", toolchainSpec);
            if (toolchains.size() > 0) {
                selectedToolchain = (Toolchain)toolchains.get(0);
                javaExecutableFromToolchain = selectedToolchain.findTool("java");
                javaHomeFromToolchain = ((DefaultJavaToolChain)selectedToolchain).getJavaHome();
                if (!new File(javaExecutableFromToolchain).canExecute()) {
                    throw new MojoExecutionException("Identified matching toolchain " + javaExecutableFromToolchain + " but it is not an executable file");
                }
            } else {
                throw new MojoExecutionException("Unable to find a matching toolchain for configuration " + toolchainSpec);
            }
            logger.debug((CharSequence)("maven-forge-plugin: Setting surefire's jvm to " + javaExecutableFromToolchain + " from toolchain " + selectedToolchain + ", requirements: " + toolchainSpec));
            try {
                Field jvmField = AbstractSurefireMojo.class.getDeclaredField("jvm");
                jvmField.setAccessible(true);
                jvmField.set(pluginInstance, javaExecutableFromToolchain);
                Map environmentVariables = pluginInstance.getEnvironmentVariables();
                environmentVariables.put("JAVA_HOME", javaHomeFromToolchain);
                for (Field f : FieldUtils.getAllFieldsList(pluginInstance.getClass())) {
                    if (!f.getName().equals("excludedEnvironmentVariables")) continue;
                    f.setAccessible(true);
                    String[] newExcludedList = (String[])ArrayUtils.add((Object[])((String[])f.get(pluginInstance)), (Object)"JAVA_HOME");
                    f.set(pluginInstance, newExcludedList);
                    logger.debug((CharSequence)("maven-forge-plugin: Added JAVA_HOME to excluded list on field " + f + ", now: " + ArrayUtils.toString((Object)f.get(pluginInstance))));
                }
                logger.debug((CharSequence)("maven-forge-plugin: Set JAVA_HOME to " + javaHomeFromToolchain));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to set jvm field in superclass " + pluginInstance.getClass() + " to " + javaExecutableFromToolchain, e);
            }
            logger.debug((CharSequence)("maven-forge-plugin: environment at this stage: " + pluginInstance.getEnvironmentVariables()));
        }
    }
}

