/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.terracotta.forge.plugin.AbstractArtifactResolvingMojo;

@Mojo(name="packageClusteredEntity", requiresDependencyResolution=ResolutionScope.COMPILE)
public class PackageClusteredEntityMojo
extends AbstractArtifactResolvingMojo {
    @Component
    protected MavenProject project;
    @Parameter(required=false, defaultValue=".class_terracotta")
    private String privateClassSuffix;
    @Parameter(required=false, defaultValue="server-content.txt")
    private String serverContentFilename;
    @Parameter(required=false, defaultValue="client-content.txt")
    private String clientContentFilename;
    @Parameter(required=false, defaultValue="false")
    private boolean skip;
    @Parameter(required=true)
    private String serverArtifact;
    @Parameter(required=true)
    private String clientArtifact;
    @Parameter(required=true)
    private String apiArtifact;
    @Parameter(required=false, defaultValue="true")
    private boolean attachJavadoc;
    @Parameter(required=false, defaultValue="true")
    private boolean createShadeRecord;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping clustered entity packaging");
            return;
        }
        File buildDirectory = new File(this.project.getBuild().getOutputDirectory());
        ShadeRecordTracker shadeRecordTracker = new ShadeRecordTracker();
        Artifact serverImpl = this.completeArtifact(this.createArtifact(this.serverArtifact));
        shadeRecordTracker.add(serverImpl);
        this.extractArtifactJarTo(new File(buildDirectory, "server" + File.separator + serverImpl.getFile().getName()), serverImpl);
        Artifact clientImpl = this.completeArtifact(this.createArtifact(this.clientArtifact));
        shadeRecordTracker.add(clientImpl);
        this.extractArtifactJarTo(new File(buildDirectory, "client" + File.separator + clientImpl.getFile().getName()), clientImpl);
        for (Artifact dependency : this.collectDependencies(serverImpl, clientImpl)) {
            shadeRecordTracker.add(dependency);
            this.extractArtifactJarTo(new File(buildDirectory, "common" + File.separator + dependency.getFile().getName()), dependency);
        }
        File serverEntriesFile = new File(buildDirectory, this.serverContentFilename);
        File clientEntriesFile = new File(buildDirectory, this.clientContentFilename);
        if (!this.privateClassSuffix.trim().equals("")) {
            this.getLog().info((CharSequence)("Renaming private classes to use suffix " + this.privateClassSuffix));
            LinkedHashSet<String> commonResources = new LinkedHashSet<String>(this.renameResources(buildDirectory, "common"));
            LinkedHashSet<String> clientResources = new LinkedHashSet<String>(this.renameResources(buildDirectory, "client"));
            clientResources.addAll(commonResources);
            LinkedHashSet<String> serverResources = new LinkedHashSet<String>(this.renameResources(buildDirectory, "server"));
            serverResources.addAll(commonResources);
            this.writeContentFile(serverEntriesFile, serverResources);
            this.writeContentFile(clientEntriesFile, clientResources);
        }
        Artifact api = this.completeArtifact(this.createArtifact(this.apiArtifact));
        shadeRecordTracker.add(api);
        this.extractArtifactJarTo(buildDirectory, api);
        if (this.attachJavadoc) {
            Artifact apiJavadoc = this.getJavadocArtifact(api);
            File javadocFile = new File(buildDirectory, this.project.getArtifactId() + "-" + this.project.getVersion() + "-javadoc.jar");
            try {
                FileUtils.copyFile((File)apiJavadoc.getFile(), (File)javadocFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy javadoc", (Exception)e);
            }
            Artifact javadocArtifact = this.defaultArtifactFactory.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "jar", "javadoc");
            javadocArtifact.setFile(javadocFile);
            this.project.addAttachedArtifact(javadocArtifact);
        }
        try {
            shadeRecordTracker.writeTo(buildDirectory);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Failed to create shade record", (Exception)e);
        }
    }

    private void extractArtifactJarTo(File dir, Artifact artifact) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Exploding " + artifact.getFile()));
            this.ensureMkdirs(dir);
            this.unzip(dir, artifact.getFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to extra jar.", (Exception)e);
        }
    }

    private Set<Artifact> collectDependencies(Artifact serverImpl, Artifact clientImpl) throws MojoExecutionException {
        HashSet<Artifact> dependencies = new HashSet<Artifact>();
        try {
            dependencies.addAll(this.resolveArtifact(serverImpl));
            dependencies.addAll(this.resolveArtifact(clientImpl));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to collect depdendencies.", e);
        }
        dependencies.remove(serverImpl);
        dependencies.remove(clientImpl);
        return dependencies;
    }

    private void writeContentFile(File entriesFilename, Set<String> resources) throws MojoExecutionException {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(entriesFilename);
            for (String resource : resources) {
                pw.println(resource);
            }
            pw.close();
        }
    }

    private Set<String> renameResources(File buildDirectory, String subDir) {
        File dir = new File(buildDirectory, subDir);
        if (!dir.isDirectory()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> renamed = new LinkedHashSet<String>();
        Iterator it = FileUtils.iterateFiles((File)dir, null, (boolean)true);
        while (it.hasNext()) {
            File resource = (File)it.next();
            if (resource.getName().endsWith(".class")) {
                File clazzFile = new File(resource.getParentFile(), resource.getName().replace(".class", this.privateClassSuffix));
                resource.renameTo(clazzFile);
                renamed.add(PackageClusteredEntityMojo.cleanupSuffix(buildDirectory.getAbsolutePath() + File.separator, clazzFile.getAbsolutePath()));
                continue;
            }
            renamed.add(PackageClusteredEntityMojo.cleanupSuffix(buildDirectory.getAbsolutePath() + File.separator, resource.getAbsolutePath()));
        }
        return renamed;
    }

    private void unzip(File dest, File source) {
        Project dummyProject = new Project();
        dummyProject.init();
        Expand unzip = new Expand();
        unzip.setProject(dummyProject);
        unzip.setDest(dest);
        unzip.setSrc(source);
        unzip.execute();
    }

    private void ensureMkdirs(File f) throws IOException {
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new IOException("Failed to mkdirs " + f);
        }
    }

    private static String cleanupSuffix(String suffix, String path) {
        String cleaned = path.replace(suffix, "");
        return cleaned.replace('\\', '/');
    }

    private class ShadeRecordTracker
    extends HashSet<Artifact> {
        private ShadeRecordTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeTo(File dir) throws FileNotFoundException {
            if (!PackageClusteredEntityMojo.this.createShadeRecord) {
                return;
            }
            try (PrintWriter writer = new PrintWriter(new FileOutputStream(new File(dir, "shade-record.txt")));){
                for (Artifact artifact : this) {
                    writer.println(artifact.toString());
                }
            }
        }
    }
}

