/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.terracotta.forge.plugin.AbstractResolveDependenciesMojo;

@Mojo(name="list-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE)
public class ListArtifactDependenciesMojo
extends AbstractResolveDependenciesMojo {
    @Parameter(required=false)
    private File outputFile;
    @Parameter(required=false, defaultValue="false")
    private boolean appendFile;
    @Parameter(required=false, defaultValue="true")
    private boolean listAsUrl;
    @Parameter(required=false, defaultValue="")
    private String comment;

    public void execute() throws MojoExecutionException {
        PrintStream out = null;
        try {
            Collection<Artifact> deps = this.resolve();
            if (this.outputFile != null) {
                this.outputFile.getParentFile().mkdirs();
                out = new PrintStream(new FileOutputStream(this.outputFile, this.appendFile));
                this.getLog().info((CharSequence)("Printing dependencies of " + this.artifacts + " to file " + this.outputFile));
                this.printDeps(deps, out);
            } else {
                this.printDeps(deps, System.out);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    private void printDeps(Collection<Artifact> deps, PrintStream out) throws MalformedURLException {
        if (this.comment != null && !"".equals(this.comment)) {
            out.println("#" + this.comment);
        }
        for (Artifact a : deps) {
            if (this.listAsUrl) {
                out.println(a.getFile().toURI().toURL().toString());
                continue;
            }
            out.println(a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getType() + ":" + a.getBaseVersion() + ":runtime");
        }
    }
}

