/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.terracotta.forge.plugin.AbstractResolveDependenciesMojo;

@Mojo(name="copy-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE)
public class CopyArtifactDependenciesMojo
extends AbstractResolveDependenciesMojo {
    @Parameter(required=true)
    private File outputDir;
    @Parameter(required=false, defaultValue="false")
    private boolean removeVersion;
    @Parameter(required=false, defaultValue="false")
    private boolean createShadeRecord;

    public void execute() throws MojoExecutionException {
        try {
            Collection<Artifact> deps = this.resolve();
            this.copyDeps(deps);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void copyDeps(Collection<Artifact> deps) throws IOException {
        StringBuilder shadeRecord = new StringBuilder();
        for (Artifact a : deps) {
            File destFile;
            String filename = a.getFile().getName();
            if (a.isSnapshot()) {
                filename = a.getArtifactId() + "-" + a.getBaseVersion() + "." + a.getType();
            }
            if (this.removeVersion) {
                filename = a.getArtifactId() + "." + a.getType();
            }
            if ((destFile = new File(this.outputDir, filename)).exists()) {
                FileUtils.deleteQuietly((File)destFile);
            }
            FileUtils.copyFile((File)a.getFile(), (File)destFile);
            if (!this.createShadeRecord) continue;
            shadeRecord.append(a.toString()).append("\n");
        }
        if (this.createShadeRecord) {
            FileUtils.writeStringToFile((File)new File(this.outputDir, "shade-record.txt"), (String)shadeRecord.toString());
        }
    }
}

