/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Parameter;
import org.terracotta.forge.plugin.AbstractArtifactResolvingMojo;

public abstract class AbstractResolveDependenciesMojo
extends AbstractArtifactResolvingMojo {
    @Parameter(required=true, readonly=true)
    protected List<String> artifacts;
    @Parameter(required=false)
    protected String excludeGroupIds;
    @Parameter(required=false)
    protected String excludeArtifactIds;
    @Parameter(required=false, defaultValue="true")
    protected boolean resolveTransitively;
    @Parameter(required=false, defaultValue="false")
    protected boolean doNotResolve;

    protected Collection<Artifact> resolve() throws Exception {
        ArrayList<Artifact> deps = new ArrayList<Artifact>();
        if (this.doNotResolve) {
            for (String artifact : this.artifacts) {
                deps.add(this.createArtifact(artifact));
            }
        } else {
            for (String artifact : this.artifacts) {
                deps.addAll(this.resolveArtifact(this.createArtifact(artifact)));
            }
        }
        if (!this.resolveTransitively) {
            this.retainOriginalArtifacts(deps);
        }
        this.excludeGroupIds(deps);
        this.excludeArtifactIds(deps);
        return deps;
    }

    private void excludeGroupIds(Collection<Artifact> deps) {
        if (this.excludeGroupIds == null) {
            return;
        }
        HashSet<String> exclusions = new HashSet<String>();
        for (String groupId : this.excludeGroupIds.split(",")) {
            exclusions.add(groupId.trim());
        }
        Iterator<Artifact> it = deps.iterator();
        while (it.hasNext()) {
            if (!exclusions.contains(it.next().getGroupId())) continue;
            it.remove();
        }
    }

    private void excludeArtifactIds(Collection<Artifact> deps) {
        if (this.excludeArtifactIds == null) {
            return;
        }
        HashSet<String> exclusions = new HashSet<String>();
        for (String groupId : this.excludeArtifactIds.split(",")) {
            exclusions.add(groupId.trim());
        }
        Iterator<Artifact> it = deps.iterator();
        while (it.hasNext()) {
            if (!exclusions.contains(it.next().getArtifactId())) continue;
            it.remove();
        }
    }

    private Collection<Artifact> getConfiguredArtifacts() {
        ArrayList<Artifact> ret = new ArrayList<Artifact>();
        for (String coords : this.artifacts) {
            ret.add(this.createArtifact(coords));
        }
        return ret;
    }

    private boolean isConfiguredArtifact(Artifact a, Collection<Artifact> configuredArtifacts) {
        for (Artifact itArtifact : configuredArtifacts) {
            if (!a.getGroupId().equals(itArtifact.getGroupId()) || !a.getArtifactId().equals(itArtifact.getArtifactId()) || !a.getBaseVersion().equals(itArtifact.getBaseVersion()) || !a.getType().equals(itArtifact.getType())) continue;
            return true;
        }
        return false;
    }

    private void retainOriginalArtifacts(Collection<Artifact> resolvedArtifacts) {
        Collection<Artifact> configuredArtifacts = this.getConfiguredArtifacts();
        Iterator<Artifact> it = resolvedArtifacts.iterator();
        while (it.hasNext()) {
            if (this.isConfiguredArtifact(it.next(), configuredArtifacts)) continue;
            it.remove();
        }
    }
}

