/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefirePlugin;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugin.surefire.log.PluginConsoleLogger;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.terracotta.forge.plugin.FixJUnitReportMojo;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class TerracottaSurefirePlugin
extends SurefirePlugin {
    @Parameter(property="cleanJunitReports", defaultValue="true")
    private boolean cleanJunitReports;
    @Parameter(property="listFile")
    private File listFile;
    @Parameter(property="poundTimes", defaultValue="1")
    private int poundTimes;
    @Parameter(property="poundEmail", required=false)
    private String poundEmail;
    @Parameter(property="devLog", defaultValue="false")
    private boolean devLog;
    @Parameter(property="useReflectionFile", defaultValue="false")
    private boolean useReflectionFile;
    @Parameter(alias="jdk")
    private Map<String, String> toolchainSpec;

    private void findMatchingToolchain() throws MojoExecutionException {
        if (this.toolchainSpec != null && this.toolchainSpec.size() > 0 && this.getToolchainManager() != null) {
            String jvmFromToolchain;
            Toolchain selectedToolchain;
            List toolchains = this.getToolchainManager().getToolchains(this.getSession(), "jdk", this.toolchainSpec);
            if (toolchains.size() > 0) {
                selectedToolchain = (Toolchain)toolchains.get(0);
                jvmFromToolchain = selectedToolchain.findTool("java");
                if (!new File(jvmFromToolchain).canExecute()) {
                    throw new MojoExecutionException("Identified matching toolchain " + jvmFromToolchain + " but it is not an executable file");
                }
            } else {
                throw new MojoExecutionException("Unable to find a matching toolchain for configuration " + this.toolchainSpec);
            }
            this.getLog().info((CharSequence)("Setting surefire's jvm to " + jvmFromToolchain + " from toolchain " + selectedToolchain + ", requirements: " + this.toolchainSpec));
            try {
                Field jvmField = AbstractSurefireMojo.class.getDeclaredField("jvm");
                jvmField.setAccessible(true);
                jvmField.set((Object)this, jvmFromToolchain);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new MojoExecutionException("Unable to set jvm field in superclass to " + jvmFromToolchain, (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block40: {
            this.findMatchingToolchain();
            int absoluteTimeoutSecs = 0;
            try {
                absoluteTimeoutSecs = Integer.valueOf(this.getProject().getProperties().getProperty("absolute-test-timeout-secs"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (absoluteTimeoutSecs != this.getForkedProcessTimeoutInSeconds()) {
                this.getLog().info((CharSequence)("Overwriting test timeout using absolute-test-timeout-secs: " + absoluteTimeoutSecs + " seconds"));
                this.setForkedProcessTimeoutInSeconds(absoluteTimeoutSecs);
            }
            if (this.devLog) {
                File devLog4jFile;
                File currentDir = super.getWorkingDirectory();
                if (currentDir == null) {
                    currentDir = new File(".");
                }
                if (!(devLog4jFile = new File(currentDir, ".tc.dev.log4j.properties")).exists()) {
                    try {
                        devLog4jFile.getParentFile().mkdirs();
                        if (!devLog4jFile.createNewFile()) {
                            throw new IOException("createNewFile return false");
                        }
                    }
                    catch (IOException e1) {
                        this.getLog().error((Throwable)e1);
                        throw new MojoExecutionException("Failed to create " + devLog4jFile);
                    }
                }
            }
            try {
                String shouldSkipTestsValue = this.getProject().getProperties().getProperty("should_skip_tests");
                if (shouldSkipTestsValue != null) {
                    this.getLog().warn((CharSequence)("'should_skip_tests' property found, value is " + shouldSkipTestsValue + ". This value overrides the 'skipTests' original setting."));
                    boolean shouldSkipTests = Boolean.valueOf(shouldSkipTestsValue);
                    this.setSkipTests(shouldSkipTests);
                }
                File reflectionFile = new File(this.getProject().getBuild().getDirectory(), "reflections.xml");
                if (this.useReflectionFile && reflectionFile.exists()) {
                    try {
                        List<String> includeList = this.getCategorizedTests(reflectionFile);
                        if (includeList.size() == 0) {
                            includeList.add("**/FAKEFAKEFAKE.java");
                        } else {
                            this.getLog().info((CharSequence)("Including these tests found in " + reflectionFile + " file"));
                            this.getLog().info((CharSequence)includeList.toString());
                        }
                        this.setIncludes(includeList);
                    }
                    catch (DocumentException e) {
                        throw new MojoExecutionException(e.getMessage());
                    }
                }
                if (this.listFile != null) {
                    if (!this.listFile.exists()) {
                        this.getLog().warn((CharSequence)("listFile '" + this.listFile + "' specified but does not exist. No tests will be run"));
                        return;
                    }
                    this.getLog().info((CharSequence)("Running tests found in file " + this.listFile));
                    FileInputStream input = null;
                    try {
                        input = new FileInputStream(this.listFile);
                        List line = IOUtils.readLines((InputStream)input);
                        ArrayList<String> includeList = new ArrayList<String>();
                        for (String test : line) {
                            if ((test = test.trim()).length() == 0 || test.startsWith("#")) continue;
                            if (!test.endsWith(".java")) {
                                test = test + ".java";
                            }
                            includeList.add("**/" + test);
                        }
                        this.getLog().info((CharSequence)("Tests to run: " + includeList));
                        this.setIncludes(includeList);
                    }
                    catch (IOException e) {
                        try {
                            throw new MojoExecutionException(e.getMessage());
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(input);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)input);
                }
                if (this.poundTimes > 1) {
                    if (this.getTest() == null) {
                        this.getLog().error((CharSequence)"poundTimes was set but -Dtest isn't");
                        throw new MojoFailureException("poundTimes was set but -Dtest isn't");
                    }
                    for (int i = 1; i <= this.poundTimes; ++i) {
                        this.getLog().info((CharSequence)("* POUNDING ITERATION: " + i));
                        try {
                            super.execute();
                            continue;
                        }
                        catch (Exception e) {
                            this.getLog().error((CharSequence)("Test failed after iteration #" + i));
                            this.poundAlertIfNeeded("Pounding finished: " + this.getTest() + " failed", "Test " + this.getTest() + " failed after iteration #" + i);
                            if (e instanceof MojoExecutionException) {
                                throw (MojoExecutionException)((Object)e);
                            }
                            if (e instanceof MojoFailureException) {
                                throw (MojoFailureException)e;
                            }
                            throw new MojoExecutionException("Failed", e);
                        }
                    }
                    this.getLog().info((CharSequence)("*** Pounded " + this.poundTimes + " times! Test passed."));
                    this.poundAlertIfNeeded("Pounding finished: " + this.getTest() + " passed", "Pounded " + this.poundTimes + " times! Test " + this.getTest() + " passed");
                } else {
                    super.execute();
                }
            }
            catch (MojoExecutionException e) {
                if (e.getCause() instanceof SurefireBooterForkException) {
                    this.getLog().error((Throwable)e);
                    PluginConsoleLogger logger = new PluginConsoleLogger((Logger)new ConsoleLogger(3, "console"));
                    SurefireHelper.reportExecution((SurefireReportParameters)this, (RunResult)new RunResult(0, 0, 0, 0, "timeout", true), (PluginConsoleLogger)logger, null);
                    break block40;
                }
                throw e;
            }
            finally {
                if (this.cleanJunitReports) {
                    this.getLog().info((CharSequence)"Fix Junit reports if needed");
                    FixJUnitReportMojo fixUnitReportMojo = new FixJUnitReportMojo();
                    fixUnitReportMojo.setPluginContext(this.getPluginContext());
                    fixUnitReportMojo.setProject(this.getProject());
                    fixUnitReportMojo.execute();
                }
            }
        }
    }

    private void poundAlertIfNeeded(String subject, String text) throws MojoExecutionException {
        if (this.poundEmail == null) {
            return;
        }
        try {
            Properties sendmailProps = new Properties();
            File mailProps = new File(System.getProperty("user.home"), ".tc/poundmail.properties");
            if (!mailProps.exists()) {
                sendmailProps = TerracottaSurefirePlugin.getDefaultSendMailProps();
                sendmailProps.list(System.out);
                this.getLog().info((CharSequence)(mailProps.getCanonicalPath() + " doesn't exist. Using default SAG smtp, you'll need to be in VPN to be able to send mail"));
            } else {
                sendmailProps.load(new FileReader(mailProps));
            }
            final String username = sendmailProps.getProperty("username");
            final String password = sendmailProps.getProperty("password");
            Authenticator auth = null;
            if (username != null && password != null) {
                auth = new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password);
                    }
                };
            }
            Session mailSession = Session.getInstance((Properties)sendmailProps, auth);
            MimeMessage message = new MimeMessage(mailSession);
            message.setFrom((Address)new InternetAddress("pounder@terracottatech.com"));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.poundEmail));
            message.setSubject(subject);
            message.setText(text);
            Transport.send((Message)message);
            this.getLog().info((CharSequence)("Sent result email to " + this.poundEmail));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error emailing", e);
        }
    }

    private static Properties getDefaultSendMailProps() {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", "hqcas.eur.ad.sag");
        props.setProperty("mail.smtp.port", "25");
        return props;
    }

    protected boolean hasExecutedBefore() {
        if (this.poundTimes > 1) {
            return false;
        }
        return super.hasExecutedBefore();
    }

    private List<String> getCategorizedTests(File reflectionFile) throws DocumentException {
        Document doc = new SAXReader().read(reflectionFile);
        List list = doc.selectNodes("//Reflections/TypeAnnotationsScanner/entry");
        ArrayList<String> result = new ArrayList<String>();
        for (Node node : list) {
            Element entry = (Element)node;
            Element key = entry.element("key");
            if (!key.getText().equals("org.junit.experimental.categories.Category")) continue;
            Element values = entry.element("values");
            for (Element value : values.elements()) {
                String className = value.getText();
                result.add("**/" + className.substring(className.lastIndexOf(".") + 1) + ".java");
            }
        }
        return result;
    }
}

