/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.PrintWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.terracotta.forge.plugin.util.Util;

public class GenerateZipEntriesMojo
extends AbstractMojo {
    protected MavenProject project;
    private File zipFile;
    private String entriesFilename;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.zipFile.exists()) {
            throw new MojoExecutionException("File not found: " + this.zipFile);
        }
        File entriesFile = new File(this.project.getBuild().getDirectory(), this.entriesFilename);
        try (PrintWriter pw = null;){
            pw = new PrintWriter(entriesFile);
            pw.println(Util.getZipEntries(this.zipFile));
            pw.close();
        }
        Project dummyProject = new Project();
        dummyProject.init();
        Zip zip = new Zip();
        zip.setProject(dummyProject);
        zip.setUpdate(true);
        zip.setBasedir(new File(this.project.getBuild().getDirectory()));
        zip.setIncludes("**/" + this.entriesFilename);
        zip.setDestFile(this.zipFile);
        this.getLog().info((CharSequence)("Adding " + entriesFile + " to archive " + this.zipFile));
        zip.execute();
    }
}

