/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.terracotta.forge.plugin.util.MinimalArtifact;
import org.terracotta.forge.plugin.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="sag-finder", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SAGFinderMojo
extends AbstractMojo {
    @Parameter(required=true, property="project", readonly=true)
    private MavenProject project;
    @Parameter(required=false)
    private String excludeGroupIds;
    @Parameter(required=false)
    private String excludeArtifactIds;
    @Parameter(required=false, defaultValue="false", property="skipSagFinder")
    private boolean skip;
    @Parameter(required=false, defaultValue="false", property="onlyRunWhenSagDepsIsTrue")
    private boolean onlyRunWhenSagDepsIsTrue;
    @Parameter(required=false, property="scanDirectory")
    private String scanDirectory;
    @Parameter(required=false, property="exclusionList")
    private String exclusionList;
    @Parameter(required=false)
    private List<String> excludeArtifacts;
    @Component
    private RepositorySystem repoSystem;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skip is set to true. Skipping");
            return;
        }
        if (this.onlyRunWhenSagDepsIsTrue && !Boolean.getBoolean("sag-deps")) {
            this.getLog().info((CharSequence)"Skipped condition found: onlyRunWhenSagDepsIsTrue = true and sag-deps = false");
            return;
        }
        try {
            if (!Util.isEmpty(this.scanDirectory)) {
                this.doScanDirectory();
            } else {
                this.doScanDependencies();
            }
            this.getLog().info((CharSequence)"Scanning completed! Nothing flagged by Finder");
        }
        catch (Exception e) {
            if (e instanceof MojoExecutionException) {
                throw (MojoExecutionException)((Object)e);
            }
            throw new MojoExecutionException("Error", e);
        }
    }

    private void doScanDirectory() throws Exception {
        File scanDirectoryAbs = new File(this.scanDirectory);
        if (!scanDirectoryAbs.exists() || !scanDirectoryAbs.isDirectory()) {
            throw new MojoExecutionException(scanDirectoryAbs.getAbsolutePath() + " is not a directory or doesn't exist");
        }
        this.getLog().info((CharSequence)("About to scan " + scanDirectoryAbs.getAbsolutePath() + " with Finder"));
        if (Util.isFlaggedByFinder(scanDirectoryAbs.getAbsolutePath(), this.exclusionList, this.getLog())) {
            throw new MojoExecutionException("Finder found Oracle jar(s)");
        }
    }

    private void doScanDependencies() throws Exception {
        this.getLog().info((CharSequence)"About to scan dependencies with Finder");
        Set<Artifact> artifacts = SAGFinderMojo.filterCompileAndRuntimeScope(this.project.getArtifacts());
        artifacts = this.filterExcludeGroupIds(artifacts);
        artifacts = this.filterExcludeArtifactIds(artifacts);
        artifacts = this.filterExcludeArtifacts(artifacts);
        for (Artifact a : artifacts) {
            this.getLog().info((CharSequence)("Scanning " + a));
            if (!Util.isFlaggedByFinder(a.getFile().getAbsolutePath(), this.exclusionList, this.getLog())) continue;
            throw new MojoFailureException("Artifact " + a + " was flagged by Finder");
        }
    }

    private static Set<Artifact> filterCompileAndRuntimeScope(Set<Artifact> artifacts) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact a : artifacts) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            result.add(a);
        }
        return result;
    }

    private Set<Artifact> filterExcludeGroupIds(Set<Artifact> artifacts) {
        if (Util.isEmpty(this.excludeGroupIds)) {
            return artifacts;
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        List<String> excludes = Arrays.asList(this.excludeGroupIds.split("\\s*,\\s*"));
        for (Artifact a : artifacts) {
            if (!excludes.contains(a.getGroupId())) {
                result.add(a);
                continue;
            }
            this.getLog().info((CharSequence)("Exclude " + a + " from scanning"));
        }
        return result;
    }

    private Set<Artifact> filterExcludeArtifactIds(Set<Artifact> artifacts) {
        if (Util.isEmpty(this.excludeArtifactIds)) {
            return artifacts;
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        List<String> excludes = Arrays.asList(this.excludeArtifactIds.split("\\s*,\\s*"));
        for (Artifact a : artifacts) {
            if (!excludes.contains(a.getArtifactId())) {
                result.add(a);
                continue;
            }
            this.getLog().info((CharSequence)("Exclude " + a + " from scanning"));
        }
        return result;
    }

    private Set<Artifact> filterExcludeArtifacts(Set<Artifact> artifacts) {
        if (this.excludeArtifacts == null) {
            return artifacts;
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        HashSet<MinimalArtifact> excludes = new HashSet<MinimalArtifact>();
        for (String coords : this.excludeArtifacts) {
            excludes.add(new MinimalArtifact(coords));
        }
        for (Artifact a : artifacts) {
            boolean found = false;
            for (MinimalArtifact excludedArtifact : excludes) {
                if (!a.getGroupId().equals(excludedArtifact.getGroupId()) || !a.getArtifactId().equals(excludedArtifact.getArtifactId())) continue;
                this.getLog().info((CharSequence)("Exclude " + a + " from scanning"));
                found = true;
                break;
            }
            if (found) continue;
            result.add(a);
        }
        return result;
    }
}

