/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.terracotta.forge.plugin.util.Util;

public class PrepareToolkitContentMojo
extends AbstractMojo {
    private static final String EMBEDDED_JARS_REGEX = PrepareToolkitContentMojo.createToolkitEmbeddedJarsRegex();
    private static final Pattern EMBEDDED_JARS_PATTERN = Pattern.compile(EMBEDDED_JARS_REGEX);
    protected MavenProject project;
    private File packagingDir;
    private String privateClassSuffix;
    private String toolkitContentFilename;
    private boolean skip;
    private String finderExclusionList;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping toolkit content packaging");
            return;
        }
        if (!this.packagingDir.exists()) {
            throw new MojoExecutionException("Packaging dir not found: " + this.packagingDir);
        }
        if (Boolean.getBoolean("sag-deps")) {
            this.getLog().info((CharSequence)("sag-deps=true, scanning embedded jars in " + this.packagingDir));
            try {
                if (Util.isFlaggedByFinder(this.packagingDir.getAbsolutePath(), this.finderExclusionList, this.getLog())) {
                    throw new MojoExecutionException("Finder found Oracle copyrighted jars");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        String buildDirectory = this.project.getBuild().getOutputDirectory() + File.separator;
        File entriesFile = new File(this.packagingDir, this.toolkitContentFilename);
        try {
            StringBuilder internalResources = new StringBuilder();
            Iterator it = FileUtils.iterateFiles((File)this.packagingDir, (String[])new String[]{"jar"}, (boolean)true);
            while (it.hasNext()) {
                File jar = (File)it.next();
                Matcher m = EMBEDDED_JARS_PATTERN.matcher(jar.getAbsolutePath());
                if (!m.matches()) continue;
                this.getLog().info((CharSequence)("Exploding " + jar));
                String name = jar.getName();
                File renamedJar = new File(jar.getParent(), name + ".tmp");
                this.ensureRename(jar, renamedJar);
                this.ensureMkdirs(jar);
                this.unzip(jar, renamedJar);
                this.ensureDelete(renamedJar);
            }
            if (this.privateClassSuffix != null) {
                this.getLog().info((CharSequence)("Renaming private classes to use suffix " + this.privateClassSuffix));
                for (String subDir : Arrays.asList("ehcache", "L1", "TIMs")) {
                    File dir = new File(this.packagingDir, subDir);
                    if (!dir.isDirectory()) continue;
                    it = FileUtils.iterateFiles((File)dir, null, (boolean)true);
                    while (it.hasNext()) {
                        File resource = (File)it.next();
                        if (resource.getName().endsWith(".class")) {
                            File clazzFile = new File(resource.getParentFile(), resource.getName().replace(".class", this.privateClassSuffix));
                            resource.renameTo(clazzFile);
                            internalResources.append(PrepareToolkitContentMojo.cleanupSuffix(buildDirectory, clazzFile.getAbsolutePath())).append("\n");
                            continue;
                        }
                        internalResources.append(PrepareToolkitContentMojo.cleanupSuffix(buildDirectory, resource.getAbsolutePath())).append("\n");
                    }
                }
            }
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(entriesFile);
                pw.print(internalResources.toString());
                pw.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("IO error", (Exception)e);
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error", (Exception)e);
        }
    }

    private void unzip(File dest, File source) {
        Project dummyProject = new Project();
        dummyProject.init();
        Expand unzip = new Expand();
        unzip.setProject(dummyProject);
        unzip.setDest(dest);
        unzip.setSrc(source);
        unzip.execute();
    }

    private void ensureDelete(File f) throws IOException {
        if (!f.delete()) {
            throw new IOException("Failed to delete file " + f);
        }
    }

    private void ensureMkdirs(File f) throws IOException {
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new IOException("Failed to mkdirs " + f);
        }
    }

    private void ensureRename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("Failed to rename " + from + " to " + to);
        }
        from.delete();
    }

    private static String createToolkitEmbeddedJarsRegex() {
        String pathRegex = "[\\\\/]";
        String notPathRegex = "[^\\\\/]";
        return ".*" + pathRegex + "?(((ehcache)|(L1)|(TIMs))" + pathRegex + notPathRegex + "+\\.jar)" + pathRegex + "?";
    }

    private static String cleanupSuffix(String suffix, String path) {
        String cleaned = path.replace(suffix, "");
        return cleaned.replace('\\', '/');
    }
}

